/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.parameters;

import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.DiskFileUpload;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.summit.parameters.RequestParameterParser;
import org.codehaus.plexus.summit.parameters.RequestParameters;

public class BaseRequestParameterParser
extends AbstractLogEnabled
implements RequestParameterParser,
Initializable {
    private DiskFileUpload fileUpload = new DiskFileUpload();
    private int maxUploadSize;
    private int maxMemorySize;
    private String tempDirectory;
    private String defaultEncoding;

    public void initialize() throws InitializationException {
        this.fileUpload.setSizeMax((long)this.maxUploadSize);
        this.fileUpload.setSizeThreshold(this.maxMemorySize);
        this.fileUpload.setRepositoryPath(this.tempDirectory);
    }

    public RequestParameters parse(HttpServletRequest request) {
        String encoding;
        HashMap parameterMap = new HashMap();
        String string = encoding = request.getCharacterEncoding() == null ? this.defaultEncoding : request.getCharacterEncoding();
        if (FileUploadBase.isMultipartContent((HttpServletRequest)request)) {
            this.processFileUploadItems(request, parameterMap, encoding);
        }
        this.processQueryInfo(request, parameterMap);
        this.doParse(request, parameterMap);
        return new RequestParameters(parameterMap, encoding);
    }

    protected void doParse(HttpServletRequest request, Map parameterMap) {
    }

    private void processFileUploadItems(HttpServletRequest request, Map parameterMap, String encoding) {
        try {
            List items = this.fileUpload.parseRequest(request);
            Iterator i = items.iterator();
            while (i.hasNext()) {
                FileItem item = (FileItem)i.next();
                if (item.isFormField()) {
                    this.addParameter(parameterMap, item.getFieldName(), this.getFormField(item, encoding));
                    continue;
                }
                this.addFileItem(parameterMap, item.getFieldName(), item);
            }
        }
        catch (FileUploadException e) {
            this.getLogger().error("FileUpload failed", (Throwable)e);
        }
    }

    private void processQueryInfo(HttpServletRequest request, Map parameterMap) {
        Enumeration e = request.getParameterNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            parameterMap.put(name, request.getParameterValues(name));
        }
    }

    protected void addFileItem(Map parameterMap, String name, FileItem item) {
        FileItem[] items = (FileItem[])parameterMap.get(name);
        if (items == null) {
            items = new FileItem[]{item};
            parameterMap.put(name, items);
        } else {
            FileItem[] newItems = new FileItem[items.length + 1];
            System.arraycopy(items, 0, newItems, 0, items.length);
            newItems[items.length] = item;
            parameterMap.put(name, newItems);
        }
    }

    protected void addParameter(Map parameterMap, String name, String value) {
        String[] values = (String[])parameterMap.get(name);
        if (values == null) {
            values = new String[]{value};
            parameterMap.put(name, values);
        } else {
            String[] newItems = new String[values.length + 1];
            System.arraycopy(values, 0, newItems, 0, values.length);
            newItems[values.length] = value;
            parameterMap.put(name, newItems);
        }
    }

    private String getFormField(FileItem item, String encoding) {
        String value = null;
        try {
            value = item.getString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            value = item.getString();
            this.getLogger().error("Unsupported encoding, used default");
        }
        return value;
    }
}

