/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.summit.pipeline.valve;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.fileupload.FileItem;
import org.codehaus.plexus.action.Action;
import org.codehaus.plexus.action.ActionManager;
import org.codehaus.plexus.summit.pipeline.valve.AbstractValve;
import org.codehaus.plexus.summit.pipeline.valve.ValveInvocationException;
import org.codehaus.plexus.summit.rundata.RunData;

public class ActionValve
extends AbstractValve {
    private ActionManager actionManager;

    public void invoke(RunData data) throws IOException, ValveInvocationException {
        String actionId = data.getParameters().getString("action", "");
        if (!actionId.equals("")) {
            try {
                Action action = this.actionManager.lookup(actionId.trim());
                Map m = this.createContext(data);
                m.put("data", data);
                action.execute(m);
                if (action.hasResultMessages(m)) {
                    data.setResultMessages(action.getResultMessages(m));
                }
            }
            catch (Exception e) {
                data.setError(e);
            }
        }
    }

    protected Map createContext(RunData data) throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        Iterator i = data.getParameters().keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            String value = null;
            FileItem fileItem = data.getParameters().getFileItem(key);
            if (fileItem != null) {
                if (!fileItem.isFormField()) {
                    File uploadedFile = File.createTempFile("summit-", ".tmp");
                    fileItem.write(uploadedFile);
                    value = uploadedFile.toURL().toExternalForm();
                } else {
                    value = fileItem.getString();
                }
            } else {
                value = data.getParameters().get(key);
            }
            m.put(key, value);
        }
        return m;
    }
}

