/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Extension;
import org.cometd.Listener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.client.Advice;
import org.cometd.server.MessageImpl;
import org.cometd.server.MessagePool;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.CachedExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferUtil;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.Utf8StringBuffer;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BayeuxClient
extends AbstractLifeCycle
implements Client {
    private static final String __TIMER = "org.cometd.client.Timer";
    private static final String __JSON = "org.cometd.client.JSON";
    private static final String __MSGPOOL = "org.cometd.server.MessagePool";
    private final ArrayQueue<Message> _inQ = new ArrayQueue();
    private final ArrayQueue<Message> _outQ = new ArrayQueue();
    private final HttpClient _httpClient;
    private final Buffer _scheme;
    private final Address _cometdAddress;
    private final String _path;
    private Timer _timer;
    protected MessagePool _msgPool;
    private Exchange _pull;
    private Exchange _push;
    private boolean _initialized = false;
    private boolean _disconnecting = false;
    private String _clientId;
    private Listener _listener;
    private List<MessageListener> _mListeners;
    private int _batch;
    private Map<String, ExpirableCookie> _cookies = new ConcurrentHashMap<String, ExpirableCookie>();
    private Advice _advice;
    private int _backoffInterval = 0;
    private int _backoffIncrement = 1000;
    private int _backoffMaxInterval = 60000;
    private Extension[] _extensions;
    private JSON _jsonOut;

    public BayeuxClient(HttpClient client, String url) {
        this(client, url, null);
    }

    public BayeuxClient(HttpClient client, String url, Timer timer) {
        HttpURI uri = new HttpURI(url);
        this._httpClient = client;
        this._scheme = "https".equals(uri.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER;
        int port = uri.getPort();
        if (port <= 0) {
            port = HttpSchemes.HTTPS_BUFFER == this._scheme ? 443 : 80;
        }
        this._cometdAddress = new Address(uri.getHost(), port);
        this._path = uri.getPath();
        this._timer = timer;
    }

    public BayeuxClient(HttpClient client, Address address, String path, Timer timer) {
        this._httpClient = client;
        this._scheme = HttpSchemes.HTTP_BUFFER;
        this._cometdAddress = address;
        this._path = path;
        this._timer = timer;
    }

    public BayeuxClient(HttpClient client, Address address, String uri) {
        this(client, address, uri, null);
    }

    public void addExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.addToArray((Object[])this._extensions, (Object)ext, Extension.class);
    }

    public void removeExtension(Extension ext) {
        this._extensions = (Extension[])LazyList.removeFromArray((Object[])this._extensions, (Object)ext);
    }

    Extension[] getExtensions() {
        return this._extensions;
    }

    public void setBackOffInterval(int interval) {
        this._backoffInterval = interval;
    }

    public int getBackoffInterval() {
        return this._backoffInterval;
    }

    public void setBackoffMaxRetries(int retries) {
    }

    public int getBackoffMaxRetries() {
        return -1;
    }

    public void setBackoffIncrement(int interval) {
        this._backoffIncrement = interval;
    }

    public int getBackoffIncrement() {
        return this._backoffIncrement;
    }

    public void setBackoffMaxInterval(int interval) {
        this._backoffMaxInterval = interval;
    }

    public int getBackoffMaxInterval() {
        return this._backoffMaxInterval;
    }

    public String getId() {
        return this._clientId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() throws Exception {
        if (!this._httpClient.isStarted()) {
            throw new IllegalStateException("!HttpClient.isStarted()");
        }
        ArrayQueue<Message> arrayQueue = this._httpClient;
        synchronized (arrayQueue) {
            if (this._jsonOut == null) {
                this._jsonOut = (JSON)this._httpClient.getAttribute(__JSON);
                if (this._jsonOut == null) {
                    this._jsonOut = new JSON();
                    this._httpClient.setAttribute(__JSON, (Object)this._jsonOut);
                }
            }
            if (this._timer == null) {
                this._timer = (Timer)this._httpClient.getAttribute(__TIMER);
                if (this._timer == null) {
                    this._timer = new Timer("org.cometd.client.Timer@" + ((Object)((Object)this)).hashCode(), true);
                    this._httpClient.setAttribute(__TIMER, (Object)this._timer);
                }
            }
            if (this._msgPool == null) {
                this._msgPool = (MessagePool)this._httpClient.getAttribute(__MSGPOOL);
                if (this._msgPool == null) {
                    this._msgPool = new MessagePool();
                    this._httpClient.setAttribute(__MSGPOOL, (Object)this._msgPool);
                }
            }
        }
        this._disconnecting = false;
        this._pull = null;
        this._push = null;
        super.doStart();
        arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._outQ.clear();
            if (!this._initialized && this._pull == null) {
                this._pull = new Handshake();
                this.send(this._pull, false);
            }
        }
    }

    protected void doStop() throws Exception {
        if (!this._disconnecting) {
            this.disconnect();
        }
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._outQ.clear();
            this._batch = 0;
            if (this._push != null) {
                this._push.cancel();
            }
            if (this._pull != null) {
                this._pull.cancel();
            }
            this._initialized = false;
            this._disconnecting = true;
            try {
                this.stop();
            }
            catch (Exception x) {
                Log.ignore((Throwable)x);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPolling() {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            return this.isRunning() && this._pull != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deliver(Client from, Message message) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        if (this._mListeners == null) {
            ArrayQueue<Message> arrayQueue = this._inQ;
            synchronized (arrayQueue) {
                if (message instanceof MessageImpl) {
                    ((MessageImpl)message).incRef();
                }
                this._inQ.add((Object)message);
            }
        } else {
            for (MessageListener l : this._mListeners) {
                this.notifyMessageListener(l, from, message);
            }
        }
    }

    public void deliver(Client from, String toChannel, Object data, String id) {
        if (!this.isRunning()) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl message = this._msgPool.newMessage();
        message.put("channel", (Object)toChannel);
        message.put("data", data);
        if (id != null) {
            message.put("id", (Object)id);
        }
        this.deliver(from, (Message)message);
        message.decRef();
    }

    private void notifyMessageListener(MessageListener listener, Client from, Message message) {
        try {
            listener.deliver(from, (Client)this, message);
        }
        catch (Throwable x) {
            Log.debug((Throwable)x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Listener getListener() {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            return this._listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMessages() {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            return this._inQ.size() > 0;
        }
    }

    public boolean isLocal() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(MessageImpl msg) {
        msg.incRef();
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._outQ.add((Object)msg);
            if (this._batch == 0 && this._initialized && this._push == null) {
                this._push = new Publish();
                try {
                    this.send((HttpExchange)this._push);
                }
                catch (IOException e) {
                    this.metaPublishFail(e, ((Publish)this._push).getOutboundMessages());
                }
                catch (IllegalStateException e) {
                    this.metaPublishFail(e, ((Publish)this._push).getOutboundMessages());
                }
            }
        }
    }

    public void publish(String toChannel, Object data, String msgId) {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)toChannel);
        msg.put("data", data);
        if (msgId != null) {
            msg.put("id", (Object)msgId);
        }
        this.publish(msg);
        msg.decRef();
    }

    public void subscribe(String toChannel) {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)"/meta/subscribe");
        msg.put("subscription", (Object)toChannel);
        this.publish(msg);
        msg.decRef();
    }

    public void unsubscribe(String toChannel) {
        if (!this.isRunning() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)"/meta/unsubscribe");
        msg.put("subscription", (Object)toChannel);
        this.publish(msg);
        msg.decRef();
    }

    public void remove() {
        this.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.isStopped() || this._disconnecting) {
            throw new IllegalStateException("Not running");
        }
        MessageImpl msg = this._msgPool.newMessage();
        msg.put("channel", (Object)"/meta/disconnect");
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._outQ.add((Object)msg);
            this._disconnecting = true;
            if (this._batch == 0 && this._initialized && this._push == null) {
                this._push = new Publish();
                try {
                    this.send((HttpExchange)this._push);
                }
                catch (IOException e) {
                    Log.warn((String)e.toString());
                    Log.debug((Throwable)e);
                    this.send(this._push, true);
                }
            }
            this._initialized = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(Listener listener) {
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            if (this._listener != null) {
                this.removeListener((ClientListener)this._listener);
            }
            this._listener = listener;
            if (this._listener != null) {
                this.addListener((ClientListener)this._listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Message> takeMessages() {
        LinkedList<Message> list;
        ArrayQueue<Message> arrayQueue = this._inQ;
        synchronized (arrayQueue) {
            list = new LinkedList<Message>((Collection<Message>)this._inQ);
            this._inQ.clear();
        }
        for (Message m : list) {
            if (!(m instanceof MessageImpl)) continue;
            ((MessageImpl)m).decRef();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch() {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            if (--this._batch <= 0) {
                this._batch = 0;
                if ((this._initialized || this._disconnecting) && this._push == null && this._outQ.size() > 0) {
                    this._push = new Publish();
                    try {
                        this.send((HttpExchange)this._push);
                    }
                    catch (IOException e) {
                        this.metaPublishFail(e, ((Publish)this._push).getOutboundMessages());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBatch() {
        if (this.isStopped()) {
            throw new IllegalStateException("Not running");
        }
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            ++this._batch;
        }
    }

    protected void customize(HttpExchange exchange) {
        StringBuilder builder = null;
        for (String cookieName : this._cookies.keySet()) {
            Cookie cookie;
            if (builder == null) {
                builder = new StringBuilder();
            } else {
                builder.append("; ");
            }
            if ((cookie = this.getCookie(cookieName)) == null) continue;
            builder.append(cookie.getName());
            builder.append("=");
            builder.append(cookie.getValue());
        }
        if (builder != null) {
            exchange.setRequestHeader("Cookie", builder.toString());
        }
    }

    public void setCookie(Cookie cookie) {
        long expirationTime = System.currentTimeMillis();
        int maxAge = cookie.getMaxAge();
        expirationTime = maxAge < 0 ? -1L : (expirationTime += TimeUnit.SECONDS.toMillis(maxAge));
        ExpirableCookie expirableCookie = new ExpirableCookie(cookie, expirationTime);
        this._cookies.put(cookie.getName(), expirableCookie);
    }

    public Cookie getCookie(String name) {
        ExpirableCookie cookie = this._cookies.get(name);
        if (cookie != null && cookie.isExpired()) {
            this._cookies.remove(name);
            cookie = null;
        }
        return cookie == null ? null : cookie.cookie;
    }

    public void addListener(ClientListener listener) {
        boolean added = false;
        if (listener instanceof MessageListener) {
            added = true;
            if (this._mListeners == null) {
                this._mListeners = new CopyOnWriteArrayList<MessageListener>();
            }
            this._mListeners.add((MessageListener)listener);
        }
        if (!added) {
            throw new IllegalArgumentException();
        }
    }

    public void removeListener(ClientListener listener) {
        if (listener instanceof MessageListener && this._mListeners != null) {
            this._mListeners.remove((MessageListener)listener);
        }
    }

    public int getMaxQueue() {
        return -1;
    }

    public Queue<Message> getQueue() {
        return this._inQ;
    }

    public void setMaxQueue(int max) {
        if (max != -1) {
            throw new UnsupportedOperationException();
        }
    }

    protected boolean send(final Exchange exchange, boolean backoff) {
        long interval;
        long l = interval = this._advice != null ? this._advice.getInterval() : 0L;
        if (backoff) {
            int backoffInterval = exchange.getBackoff();
            interval += (long)backoffInterval;
            exchange.incBackoff();
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Send with backoff, interval=" + interval + " for " + (Object)((Object)exchange)));
            }
        }
        if (interval > 0L) {
            TimerTask task = new TimerTask(){

                public void run() {
                    try {
                        BayeuxClient.this.send((HttpExchange)exchange);
                    }
                    catch (IOException e) {
                        Log.warn((String)("Delayed send, retry: " + e));
                        Log.debug((Throwable)e);
                        BayeuxClient.this.send(exchange, true);
                    }
                    catch (IllegalStateException e) {
                        Log.warn((String)("Delayed send, retry: " + e));
                        Log.debug((Throwable)e);
                        BayeuxClient.this.send(exchange, true);
                    }
                }
            };
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Delay " + interval + " send of " + (Object)((Object)exchange)));
            }
            this._timer.schedule(task, interval);
        } else {
            try {
                this.send((HttpExchange)exchange);
            }
            catch (IOException e) {
                Log.warn((String)("Send, retry on fail: " + e));
                Log.debug((Throwable)e);
                return this.send(exchange, true);
            }
            catch (IllegalStateException e) {
                Log.warn((String)("Send, retry on fail: " + e));
                Log.debug((Throwable)e);
                return this.send(exchange, true);
            }
        }
        return true;
    }

    protected void send(HttpExchange exchange) throws IOException {
        exchange.reset();
        this.customize(exchange);
        if (this.isRunning()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Send: using any connection=" + exchange));
            }
            this._httpClient.send(exchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInitialized(boolean value) {
        ArrayQueue<Message> arrayQueue = this._outQ;
        synchronized (arrayQueue) {
            this._initialized = value;
        }
    }

    protected boolean isInitialized() {
        return this._initialized;
    }

    protected void metaConnect(boolean success, Message message) {
        if (!success) {
            Log.warn((String)(this.toString() + ": connect failed, " + message.toString()));
        }
    }

    protected void metaHandshake(boolean success, boolean reestablish, Message message) {
        if (!success) {
            Log.warn((String)(this.toString() + ": handshake failed, " + message.toString()));
        }
    }

    protected void metaPublishFail(Throwable e, Message[] messages) {
        Log.warn((String)(this.toString() + ": publish failed, " + Arrays.toString(messages)));
        Log.debug((Throwable)e);
    }

    protected String extendOut(String msg) {
        if (this._extensions == null) {
            return msg;
        }
        try {
            Message[] messages = this._msgPool.parse(msg);
            for (int i = 0; i < messages.length; ++i) {
                this.extendOut(messages[i]);
            }
            if (messages.length == 1 && msg.charAt(0) == '{') {
                return this._msgPool.getMsgJSON().toJSON((Object)messages[0]);
            }
            return this._msgPool.getMsgJSON().toJSON((Object)messages);
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
            return msg;
        }
    }

    protected void extendOut(Message message) {
        if (this._extensions != null) {
            Message m = message;
            String channelId = m.getChannel();
            if (channelId != null) {
                int i;
                if (channelId.startsWith("/meta/")) {
                    for (i = 0; m != null && i < this._extensions.length; ++i) {
                        m = this._extensions[i].sendMeta((Client)this, m);
                    }
                } else {
                    for (i = 0; m != null && i < this._extensions.length; ++i) {
                        m = this._extensions[i].send((Client)this, m);
                    }
                }
            }
            if (message != m) {
                message.clear();
                if (m != null) {
                    for (Map.Entry entry : m.entrySet()) {
                        message.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    protected void extendIn(Message message) {
        if (this._extensions != null) {
            Message m = message;
            String channelId = m.getChannel();
            if (channelId != null) {
                int i;
                if (channelId.startsWith("/meta/")) {
                    i = this._extensions.length;
                    while (m != null && i-- > 0) {
                        m = this._extensions[i].rcvMeta((Client)this, m);
                    }
                } else {
                    i = this._extensions.length;
                    while (m != null && i-- > 0) {
                        m = this._extensions[i].rcv((Client)this, m);
                    }
                }
            }
            if (message != m) {
                message.clear();
                if (m != null) {
                    for (Map.Entry entry : m.entrySet()) {
                        message.put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
    }

    private static class ExpirableCookie {
        private final Cookie cookie;
        private final long expirationTime;

        private ExpirableCookie(Cookie cookie, long expirationTime) {
            this.cookie = cookie;
            this.expirationTime = expirationTime;
        }

        private boolean isExpired() {
            if (this.expirationTime < 0L) {
                return false;
            }
            return System.currentTimeMillis() >= this.expirationTime;
        }
    }

    protected class Publish
    extends Exchange {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Publish() {
            super("publish");
            StringBuffer json = new StringBuffer(256);
            ArrayQueue arrayQueue = BayeuxClient.this._outQ;
            synchronized (arrayQueue) {
                int s = BayeuxClient.this._outQ.size();
                if (s == 0) {
                    return;
                }
                for (int i = 0; i < s; ++i) {
                    Message message = (Message)BayeuxClient.this._outQ.getUnsafe(i);
                    message.put((Object)"clientId", (Object)BayeuxClient.this._clientId);
                    BayeuxClient.this.extendOut(message);
                    json.append(i == 0 ? (char)'[' : ',');
                    BayeuxClient.this._jsonOut.append(json, (Object)message);
                    if (!(message instanceof MessageImpl)) continue;
                    ((MessageImpl)message).decRef();
                }
                json.append(']');
                BayeuxClient.this._outQ.clear();
                this.setJson(json.toString());
            }
        }

        protected Message[] getOutboundMessages() {
            try {
                return BayeuxClient.this._msgPool.parse(this._json);
            }
            catch (IOException e) {
                Log.warn((String)"Error converting outbound messages");
                if (Log.isDebugEnabled()) {
                    Log.debug((Throwable)e);
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onResponseComplete() throws IOException {
            block12: {
                if (!BayeuxClient.this.isRunning()) {
                    return;
                }
                super.onResponseComplete();
                try {
                    ArrayQueue arrayQueue = BayeuxClient.this._outQ;
                    synchronized (arrayQueue) {
                        BayeuxClient.this.startBatch();
                        BayeuxClient.this._push = null;
                    }
                    if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                        for (int i = 0; i < this._responses.length; ++i) {
                            MessageImpl msg = (MessageImpl)this._responses[i];
                            BayeuxClient.this.deliver(null, (Message)msg);
                            if (!"/meta/disconnect".equals(msg.getChannel()) || !msg.isSuccessful()) continue;
                            if (BayeuxClient.this.isStarted()) {
                                try {
                                    BayeuxClient.this.stop();
                                }
                                catch (Exception e) {
                                    Log.ignore((Throwable)e);
                                }
                            }
                            break block12;
                        }
                        break block12;
                    }
                    Log.warn((String)("Publish, error=" + this.getResponseStatus()));
                }
                finally {
                    BayeuxClient.this.endBatch();
                }
            }
            this.recycle();
        }

        protected void onExpire() {
            super.onExpire();
            BayeuxClient.this.metaPublishFail(null, this.getOutboundMessages());
            if (BayeuxClient.this._disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        protected void onConnectionFailed(Throwable ex) {
            super.onConnectionFailed(ex);
            BayeuxClient.this.metaPublishFail(ex, this.getOutboundMessages());
            if (BayeuxClient.this._disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }

        protected void onException(Throwable ex) {
            super.onException(ex);
            BayeuxClient.this.metaPublishFail(ex, this.getOutboundMessages());
            if (BayeuxClient.this._disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
            }
        }
    }

    protected class Connect
    extends Exchange {
        String _connectString;

        Connect() {
            super("connect");
            this._connectString = "[{\"channel\":\"/meta/connect\",\"clientId\":\"" + BayeuxClient.this._clientId + "\"," + "\"connectionType\":\"long-polling\"" + "}]";
            this.setMessage(this._connectString);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                try {
                    BayeuxClient.this.startBatch();
                    for (int i = 0; i < this._responses.length; ++i) {
                        Message msg = this._responses[i];
                        Map adviceField = (Map)msg.get((Object)"advice");
                        if (adviceField != null) {
                            BayeuxClient.this._advice = new Advice(adviceField);
                        }
                        if ("/meta/connect".equals(msg.get((Object)"channel"))) {
                            ArrayQueue arrayQueue;
                            Boolean successful = (Boolean)msg.get((Object)"successful");
                            if (successful != null && successful.booleanValue()) {
                                BayeuxClient.this.metaConnect(true, msg);
                                if (!BayeuxClient.this.isRunning()) {
                                }
                                arrayQueue = BayeuxClient.this._outQ;
                                synchronized (arrayQueue) {
                                    if (BayeuxClient.this._disconnecting) {
                                        continue;
                                    }
                                    if (!BayeuxClient.this.isInitialized()) {
                                        BayeuxClient.this.setInitialized(true);
                                        if (BayeuxClient.this._outQ.size() > 0) {
                                            BayeuxClient.this._push = new Publish();
                                            BayeuxClient.this.send((HttpExchange)BayeuxClient.this._push);
                                        }
                                    }
                                }
                                BayeuxClient.this._pull = new Connect();
                                BayeuxClient.this.send(BayeuxClient.this._pull, false);
                            } else {
                                BayeuxClient.this.setInitialized(false);
                                BayeuxClient.this.metaConnect(false, msg);
                                arrayQueue = BayeuxClient.this._outQ;
                                synchronized (arrayQueue) {
                                    if (!BayeuxClient.this.isRunning() || BayeuxClient.this._disconnecting) {
                                    }
                                }
                                if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectNone()) {
                                    BayeuxClient.this.deliver(null, msg);
                                    arrayQueue = BayeuxClient.this._outQ;
                                    synchronized (arrayQueue) {
                                        BayeuxClient.this._disconnecting = true;
                                        try {
                                            BayeuxClient.this.stop();
                                        }
                                        catch (Exception x) {
                                            Log.ignore((Throwable)x);
                                        }
                                    }
                                }
                                if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectHandshake()) {
                                    if (Log.isDebugEnabled()) {
                                        Log.debug((String)"connect received success=false, advice is to rehandshake");
                                    }
                                    BayeuxClient.this._pull = new Handshake();
                                    BayeuxClient.this.send(BayeuxClient.this._pull, true);
                                } else {
                                    if (Log.isDebugEnabled()) {
                                        Log.debug((String)"Assuming retry=reconnect");
                                    }
                                    this.resend(true);
                                }
                            }
                        }
                        if (!BayeuxClient.this.isRunning()) continue;
                        BayeuxClient.this.deliver(null, msg);
                    }
                }
                finally {
                    BayeuxClient.this.endBatch();
                }
            } else {
                MessageImpl error = BayeuxClient.this._msgPool.newMessage();
                error.put((Object)"successful", (Object)Boolean.FALSE);
                error.put((Object)"status", (Object)this.getResponseStatus());
                error.put((Object)"content", (Object)this.getResponseContent());
                BayeuxClient.this.metaConnect(false, (Message)error);
                this.resend(true);
            }
            this.recycle();
        }

        protected void onExpire() {
            BayeuxClient.this.setInitialized(false);
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)"expired");
            BayeuxClient.this.metaConnect(false, (Message)error);
            this.resend(true);
        }

        protected void onConnectionFailed(Throwable ex) {
            BayeuxClient.this.setInitialized(false);
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            BayeuxClient.this.metaConnect(false, (Message)error);
            this.resend(true);
        }

        protected void onException(Throwable ex) {
            BayeuxClient.this.setInitialized(false);
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            BayeuxClient.this.metaConnect(false, (Message)error);
            this.resend(true);
        }
    }

    protected class Handshake
    extends Exchange {
        public static final String __HANDSHAKE = "[{\"channel\":\"/meta/handshake\",\"version\":\"0.9\",\"minimumVersion\":\"0.9\"}]";

        Handshake() {
            super("handshake");
            this.setMessage(__HANDSHAKE);
        }

        protected void onResponseComplete() throws IOException {
            super.onResponseComplete();
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            if (BayeuxClient.this._disconnecting) {
                MessageImpl error = BayeuxClient.this._msgPool.newMessage();
                error.put((Object)"successful", (Object)Boolean.FALSE);
                error.put((Object)"failure", (Object)"expired");
                BayeuxClient.this.metaHandshake(false, false, (Message)error);
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
                return;
            }
            if (this.getResponseStatus() == 200 && this._responses != null && this._responses.length > 0) {
                MessageImpl response = (MessageImpl)this._responses[0];
                boolean successful = response.isSuccessful();
                Map adviceField = (Map)response.get((Object)"advice");
                if (adviceField != null) {
                    BayeuxClient.this._advice = new Advice(adviceField);
                }
                if (successful) {
                    if (Log.isDebugEnabled()) {
                        Log.debug((String)"Successful handshake, sending connect");
                    }
                    BayeuxClient.this._clientId = (String)response.get((Object)"clientId");
                    BayeuxClient.this.metaHandshake(true, true, (Message)response);
                    BayeuxClient.this._pull = new Connect();
                    BayeuxClient.this.send(BayeuxClient.this._pull, false);
                } else {
                    BayeuxClient.this.metaHandshake(false, false, (Message)response);
                    if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectNone()) {
                        throw new IOException("Handshake failed with advice reconnect=none :" + this._responses[0]);
                    }
                    if (BayeuxClient.this._advice != null && BayeuxClient.this._advice.isReconnectHandshake()) {
                        BayeuxClient.this._pull = new Handshake();
                        if (!BayeuxClient.this.send(BayeuxClient.this._pull, true)) {
                            throw new IOException("Handshake, retries exhausted");
                        }
                    } else {
                        BayeuxClient.this._pull = new Connect();
                        if (!BayeuxClient.this.send(BayeuxClient.this._pull, true)) {
                            throw new IOException("Connect after handshake, retries exhausted");
                        }
                    }
                }
            } else {
                MessageImpl error = BayeuxClient.this._msgPool.newMessage();
                error.put((Object)"successful", (Object)Boolean.FALSE);
                error.put((Object)"status", (Object)this.getResponseStatus());
                error.put((Object)"content", (Object)this.getResponseContent());
                BayeuxClient.this.metaHandshake(false, false, (Message)error);
                this.resend(true);
            }
            this.recycle();
        }

        protected void onExpire() {
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)"expired");
            error.put((Object)"uri", (Object)this.getURI());
            BayeuxClient.this.metaHandshake(false, false, (Message)error);
            this.resend(true);
        }

        protected void onConnectionFailed(Throwable ex) {
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)ex.toString());
            error.put((Object)"exception", (Object)ex);
            error.put((Object)"uri", (Object)this.getURI());
            ex.printStackTrace();
            BayeuxClient.this.metaHandshake(false, false, (Message)error);
            this.resend(true);
        }

        protected void onException(Throwable ex) {
            MessageImpl error = BayeuxClient.this._msgPool.newMessage();
            error.put((Object)"successful", (Object)Boolean.FALSE);
            error.put((Object)"failure", (Object)this.getURI());
            error.put((Object)"exception", (Object)ex);
            error.put((Object)"uri", (Object)this.getURI());
            BayeuxClient.this.metaHandshake(false, false, (Message)error);
            this.resend(true);
        }
    }

    protected class Exchange
    extends CachedExchange {
        Message[] _responses;
        int _backoff;
        String _json;
        private int _bufferSize;
        Utf8StringBuffer _responseContent;

        Exchange(String info) {
            super(false);
            this._backoff = BayeuxClient.this._backoffInterval;
            this._bufferSize = 1024;
            this.setMethod("POST");
            this.setScheme(BayeuxClient.this._scheme);
            this.setAddress(BayeuxClient.this._cometdAddress);
            this.setURI(BayeuxClient.this._path + "/" + info);
            this.setRequestContentType("application/json;charset=UTF-8");
        }

        public String getResponseContent() throws UnsupportedEncodingException {
            if (this._responseContent != null) {
                return this._responseContent.toString();
            }
            return null;
        }

        protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            if (this._responseContent != null) {
                this._responseContent.reset();
            }
            super.onResponseStatus(version, status, reason);
        }

        protected void onResponseContent(Buffer content) throws IOException {
            super.onResponseContent(content);
            if (this._responseContent == null) {
                this._responseContent = new Utf8StringBuffer(this._bufferSize);
            }
            if (content.array() != null) {
                this._responseContent.append(content.array(), content.getIndex(), content.length());
            } else {
                this._responseContent.append(content.asArray(), 0, content.length());
            }
        }

        public int getBackoff() {
            return this._backoff;
        }

        public void incBackoff() {
            this._backoff = Math.min(this._backoff + BayeuxClient.this._backoffIncrement, BayeuxClient.this._backoffMaxInterval);
        }

        protected void setMessage(String message) {
            message = BayeuxClient.this.extendOut(message);
            this.setJson(message);
        }

        protected void setJson(String json) {
            try {
                this._json = json;
                this.setRequestContent((Buffer)new ByteArrayBuffer(this._json, "utf-8"));
            }
            catch (Exception e) {
                Log.ignore((Throwable)e);
                this.setRequestContent((Buffer)new ByteArrayBuffer(this._json));
            }
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            super.onResponseHeader(name, value);
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            int header = HttpHeaders.CACHE.getOrdinal(name);
            if (header == 12) {
                this._bufferSize = BufferUtil.toInt((Buffer)value);
            } else if (header == 53) {
                String cname = null;
                String cvalue = null;
                QuotedStringTokenizer tok = new QuotedStringTokenizer(value.toString(), "=;", false, false);
                tok.setSingle(false);
                if (tok.hasMoreElements()) {
                    cname = tok.nextToken();
                }
                if (tok.hasMoreElements()) {
                    cvalue = tok.nextToken();
                }
                Cookie cookie = new Cookie(cname, cvalue);
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if ("Version".equalsIgnoreCase(token)) {
                        cookie.setVersion(Integer.parseInt(tok.nextToken()));
                        continue;
                    }
                    if ("Comment".equalsIgnoreCase(token)) {
                        cookie.setComment(tok.nextToken());
                        continue;
                    }
                    if ("Path".equalsIgnoreCase(token)) {
                        cookie.setPath(tok.nextToken());
                        continue;
                    }
                    if ("Domain".equalsIgnoreCase(token)) {
                        cookie.setDomain(tok.nextToken());
                        continue;
                    }
                    if ("Expires".equalsIgnoreCase(token)) {
                        try {
                            Date date = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss 'GMT'").parse(tok.nextToken());
                            Long maxAge = TimeUnit.MILLISECONDS.toSeconds(date.getTime() - System.currentTimeMillis());
                            cookie.setMaxAge(maxAge > 0L ? maxAge.intValue() : 0);
                        }
                        catch (ParseException ignored) {}
                        continue;
                    }
                    if ("Max-Age".equalsIgnoreCase(token)) {
                        try {
                            int maxAge = Integer.parseInt(tok.nextToken());
                            cookie.setMaxAge(maxAge);
                        }
                        catch (NumberFormatException ignored) {}
                        continue;
                    }
                    if (!"Secure".equalsIgnoreCase(token)) continue;
                    cookie.setSecure(true);
                }
                BayeuxClient.this.setCookie(cookie);
            }
        }

        protected void onResponseComplete() throws IOException {
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            super.onResponseComplete();
            if (this.getResponseStatus() == 200) {
                String content = this.getResponseContent();
                if (content == null || content.length() == 0) {
                    throw new IllegalStateException("No content in response for " + this.getURI());
                }
                this._responses = BayeuxClient.this._msgPool.parse(content);
                if (this._responses != null) {
                    for (int i = 0; i < this._responses.length; ++i) {
                        BayeuxClient.this.extendIn(this._responses[i]);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void resend(boolean backoff) {
            boolean disconnecting;
            if (!BayeuxClient.this.isRunning()) {
                return;
            }
            ArrayQueue arrayQueue = BayeuxClient.this._outQ;
            synchronized (arrayQueue) {
                disconnecting = BayeuxClient.this._disconnecting;
            }
            if (disconnecting) {
                try {
                    BayeuxClient.this.stop();
                }
                catch (Exception e) {
                    Log.ignore((Throwable)e);
                }
                return;
            }
            this.setJson(this._json);
            if (!BayeuxClient.this.send(this, backoff)) {
                Log.warn((String)"Retries exhausted");
            }
        }

        protected void recycle() {
            if (this._responses != null) {
                for (Message msg : this._responses) {
                    if (!(msg instanceof MessageImpl)) continue;
                    ((MessageImpl)msg).decRef();
                }
            }
            this._responses = null;
        }
    }
}

