/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.client.BayeuxClient;
import org.cometd.oort.Oort;
import org.cometd.server.MessageImpl;
import org.eclipse.jetty.util.log.Log;

public class OortComet
extends BayeuxClient {
    protected Oort _oort;
    protected String _cometUrl;
    protected String _cometSecret;
    protected boolean _connected;
    protected boolean _handshook;

    OortComet(Oort oort, String cometUrl) {
        super(oort._httpClient, cometUrl, oort._timer);
        this._cometUrl = cometUrl;
        this._oort = oort;
        this.addListener((ClientListener)new OortCometListener());
    }

    public boolean isConnected() {
        return this._connected;
    }

    public boolean isHandshook() {
        return this._handshook;
    }

    protected String extendOut(String message) {
        if (message == "[{\"channel\":\"/meta/handshake\",\"version\":\"0.9\",\"minimumVersion\":\"0.9\"}]") {
            try {
                Message[] msg = this._msgPool.parse(message);
                HashMap<String, String> oort = new HashMap<String, String>();
                oort.put("oort", this._oort.getURL());
                oort.put("oortSecret", this._oort.getSecret());
                oort.put("comet", this._cometUrl);
                Map ext = msg[0].getExt(true);
                ext.put("oort", oort);
                super.extendOut(msg[0]);
                message = this._msgPool.getJSON().toJSON((Object)msg);
                for (Message m : msg) {
                    if (!(m instanceof MessageImpl)) continue;
                    ((MessageImpl)m).decRef();
                }
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            message = super.extendOut(message);
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)(this._oort.getURL() + " ==> " + message));
        }
        return message;
    }

    protected void metaConnect(boolean success, Message message) {
        this._connected = success;
        super.metaConnect(success, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void metaHandshake(boolean success, boolean reestablish, Message message) {
        Oort oort = this._oort;
        synchronized (oort) {
            this._handshook = success;
            super.metaHandshake(success, reestablish, message);
            if (success) {
                Map oort2;
                Map ext = (Map)message.get((Object)"ext");
                if (ext != null && (oort2 = (Map)ext.get("oort")) != null) {
                    this._cometSecret = (String)oort2.get("cometSecret");
                    this.startBatch();
                    this.subscribe("/oort/cloud");
                    for (String channel : this._oort._channels) {
                        this.subscribe(channel);
                    }
                    this.publish("/oort/cloud", this._oort.getKnownComets(), this._cometSecret);
                    this.endBatch();
                }
                if (Log.isDebugEnabled()) {
                    Log.debug((String)(this._oort.getURL() + " <== " + ext));
                }
            }
        }
    }

    protected void metaPublishFail(Throwable e, Message[] messages) {
        super.metaPublishFail(e, messages);
    }

    protected class OortCometListener
    implements MessageListener {
        protected OortCometListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void deliver(Client fromClient, Client toClient, Message msg) {
            String channelId = msg.getChannel();
            if (msg.getData() != null) {
                if (channelId.startsWith("/oort/")) {
                    Object data;
                    if (channelId.equals("/oort/cloud")) {
                        data = (Object[])msg.getData();
                        HashSet<String> comets = new HashSet<String>();
                        for (Object o : data) {
                            comets.add(o.toString());
                        }
                        OortComet.this._oort.observedComets(comets);
                    }
                    data = OortComet.this._oort;
                    synchronized (data) {
                        for (MessageListener messageListener : OortComet.this._oort._oortMessageListeners) {
                            messageListener.deliver(fromClient, toClient, msg);
                        }
                    }
                } else {
                    Channel channel = OortComet.this._oort._bayeux.getChannel(msg.getChannel(), false);
                    if (channel != null) {
                        channel.publish(OortComet.this._oort._oortClient, msg.getData(), msg.getId());
                    }
                }
            }
        }
    }
}

