/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.Channel;
import org.cometd.Client;
import org.cometd.ClientListener;
import org.cometd.Message;
import org.cometd.MessageListener;
import org.cometd.oort.Oort;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.ajax.JSON;
import org.eclipse.jetty.util.component.AbstractLifeCycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seti
extends AbstractLifeCycle {
    public static final String SETI_ATTRIBUTE = "org.cometd.oort.Seti";
    public static final String SETI_SHARD = "seti.shard";
    final String _setiId;
    final String _setiChannelId;
    final String _shardId;
    final Oort _oort;
    final Client _client;
    final ShardLocation _allShardLocation;
    final Channel _setiIdChannel;
    final Channel _setiAllChannel;
    final Channel _setiShardChannel;
    final ConcurrentMap<String, Location> _uid2Location = new ConcurrentHashMap<String, Location>();

    public Seti(Oort oort, String shardId) {
        this._oort = oort;
        this._client = this._oort.getBayeux().newClient("seti");
        this._setiId = this._oort.getURL().replace("://", "_").replace("/", "_").replace(":", "_");
        this._shardId = shardId;
        this._setiChannelId = "/seti/" + this._setiId;
        this._setiIdChannel = this._oort.getBayeux().getChannel(this._setiChannelId, true);
        this._setiIdChannel.setPersistent(true);
        this._oort.observeChannel(this._setiIdChannel.getId());
        this._setiIdChannel.subscribe(this._client);
        this._setiAllChannel = this._oort.getBayeux().getChannel("/seti/ALL", true);
        this._setiAllChannel.setPersistent(true);
        this._oort.observeChannel(this._setiAllChannel.getId());
        this._setiAllChannel.subscribe(this._client);
        this._setiShardChannel = this._oort.getBayeux().getChannel("/seti/" + shardId, true);
        this._setiShardChannel.setPersistent(true);
        this._oort.observeChannel(this._setiShardChannel.getId());
        this._setiShardChannel.subscribe(this._client);
        this._allShardLocation = new ShardLocation(this._setiAllChannel);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this._client.addListener((ClientListener)new MessageListener(){

            public void deliver(Client from, Client to, Message msg) {
                Seti.this.receive(from, to, msg);
            }
        });
    }

    protected void doStop() throws Exception {
        this._client.disconnect();
    }

    public void associate(String userId, Client client) {
        this._uid2Location.put(userId, new LocalLocation(client));
        this.userId2Shard(userId).associate(userId);
    }

    public void disassociate(String userId) {
        this._uid2Location.remove(userId);
        this.userId2Shard(userId).disassociate(userId);
    }

    public void sendMessage(String toUser, String toChannel, Object message) {
        Location location = (Location)this._uid2Location.get(toUser);
        if (location == null) {
            location = this.userId2Shard(toUser);
        }
        location.sendMessage(toUser, toChannel, message);
    }

    public void sendMessage(Collection<String> toUsers, String toChannel, Object message) {
        ShardLocation shard;
        MultiMap shard2users = new MultiMap();
        for (String userId : toUsers) {
            shard = this.userId2Shard(userId);
            shard2users.add((Object)shard, (Object)userId);
        }
        for (Map.Entry entry : shard2users.entrySet()) {
            shard = (ShardLocation)entry.getKey();
            Object lazyUsers = entry.getValue();
            if (LazyList.size(lazyUsers) == 1) {
                shard.sendMessage((String)lazyUsers, toChannel, message);
                continue;
            }
            shard.sendMessage((List)lazyUsers, toChannel, message);
        }
    }

    protected ShardLocation userId2Shard(String userId) {
        return this._allShardLocation;
    }

    protected void receive(Client from, Client to, Message msg) {
        if (!(msg.getData() instanceof Map)) {
            return;
        }
        Map data = (Map)msg.getData();
        String toUid = (String)data.get("to");
        String fromUid = (String)data.get("from");
        Object message = data.get("message");
        String on = (String)data.get("on");
        if (fromUid != null) {
            if (on != null) {
                this._uid2Location.put(fromUid, new SetiLocation("/seti/" + on));
            } else {
                String off = (String)data.get("off");
                if (off != null) {
                    this._uid2Location.remove(fromUid, new SetiLocation("/seti/" + off));
                }
            }
        }
        if (message != null && toUid != null) {
            String toChannel = (String)data.get("channel");
            Location location = (Location)this._uid2Location.get(toUid);
            if (location == null && this._setiChannelId.equals(msg.getChannel())) {
                location = this.userId2Shard(toUid);
            }
            if (location != null) {
                location.receive(toUid, toChannel, message);
            }
        }
    }

    class SetiPresence
    implements JSON.Convertible {
        String _user;
        boolean _on;

        SetiPresence(String user, boolean on) {
            this._user = user;
            this._on = on;
        }

        public void fromJSON(Map object) {
            throw new UnsupportedOperationException();
        }

        public void toJSON(JSON.Output out) {
            out.add("from", (Object)this._user);
            out.add(this._on ? "on" : "off", (Object)Seti.this._setiId);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SetiMessage
    implements JSON.Convertible {
        String _toUser;
        Collection<String> _toUsers;
        String _toChannel;
        Object _message;

        SetiMessage(String toUser, String toChannel, Object message) {
            this._toUser = toUser;
            this._toChannel = toChannel;
            this._message = message;
        }

        SetiMessage(Collection<String> toUsers, String toChannel, Object message) {
            this._toUsers = toUsers;
            this._toChannel = toChannel;
            this._message = message;
        }

        public void fromJSON(Map object) {
            throw new UnsupportedOperationException();
        }

        public void toJSON(JSON.Output out) {
            if (this._toUser != null) {
                out.add("to", (Object)this._toUser);
            } else if (this._toUsers != null) {
                out.add("to", this._toUsers);
            }
            out.add("channel", (Object)this._toChannel);
            out.add("from", (Object)Seti.this._setiId);
            out.add("message", this._message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ShardLocation
    implements Location {
        Channel _channel;

        ShardLocation(String shardId) {
            this._channel = Seti.this._oort._bayeux.getChannel("/seti/" + shardId, true);
        }

        ShardLocation(Channel channel) {
            this._channel = channel;
        }

        public void sendMessage(Collection<String> toUsers, String toChannel, Object message) {
            this._channel.publish(Seti.this._client, (Object)new SetiMessage(toUsers, toChannel, message), null);
        }

        @Override
        public void sendMessage(String toUser, String toChannel, Object message) {
            this._channel.publish(Seti.this._client, (Object)new SetiMessage(toUser, toChannel, message), null);
        }

        @Override
        public void receive(String toUser, String toChannel, Object message) {
        }

        public void associate(String user) {
            this._channel.publish(Seti.this._client, (Object)new SetiPresence(user, true), null);
        }

        public void disassociate(String user) {
            this._channel.publish(Seti.this._client, (Object)new SetiPresence(user, false), null);
        }
    }

    class SetiLocation
    implements Location {
        Channel _channel;

        SetiLocation(String channelId) {
            this._channel = Seti.this._oort._bayeux.getChannel(channelId, true);
        }

        SetiLocation(Channel channel) {
            this._channel = channel;
        }

        public void sendMessage(String toUser, String toChannel, Object message) {
            this._channel.publish(Seti.this._client, (Object)new SetiMessage(toUser, toChannel, message), null);
        }

        public void receive(String toUser, String toChannel, Object message) {
        }

        public boolean equals(Object o) {
            return o instanceof SetiLocation && ((SetiLocation)o)._channel.equals(this._channel);
        }

        public int hashCode() {
            return this._channel.hashCode();
        }
    }

    class LocalLocation
    implements Location {
        Client _client;

        LocalLocation(Client client) {
            this._client = client;
        }

        public void sendMessage(String toUser, String toChannel, Object message) {
            this._client.deliver(Seti.this._client, toChannel, message, null);
        }

        public void receive(String toUser, String toChannel, Object message) {
            this._client.deliver(Seti.this._client, toChannel, message, null);
        }
    }

    private static interface Location {
        public void sendMessage(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);
    }
}

