/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.client.BayeuxClient;
import org.cometd.client.transport.ClientTransport;
import org.cometd.client.transport.LongPollingTransport;
import org.cometd.oort.Oort;
import org.eclipse.jetty.client.HttpClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OortComet
extends BayeuxClient {
    private final ConcurrentMap<String, ClientSessionChannel.MessageListener> _subscriptions = new ConcurrentHashMap<String, ClientSessionChannel.MessageListener>();
    private final Oort _oort;
    private final String _cometURL;
    private volatile String _cometSecret;

    public OortComet(Oort oort, String cometUrl) {
        super(cometUrl, (ClientTransport)LongPollingTransport.create(null, (HttpClient)oort.getHttpClient()), new ClientTransport[0]);
        this._oort = oort;
        this._cometURL = cometUrl;
        this.setDebugEnabled(oort.isClientDebugEnabled());
        this.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                if (message.isSuccessful()) {
                    Map ext = message.getExt();
                    if (ext == null) {
                        return;
                    }
                    Map oortExtension = (Map)ext.get("org.cometd.oort");
                    if (oortExtension == null) {
                        return;
                    }
                    OortComet.this._cometSecret = (String)oortExtension.get("oortSecret");
                    OortComet.this._oort.getLogger().info("Connected to comet {} with {}", new Object[]{OortComet.this._cometURL, message.getClientId()});
                    OortComet.this.batch(new Runnable(){

                        public void run() {
                            OortComet.this.getChannel("/oort/cloud").subscribe(new ClientSessionChannel.MessageListener(){

                                public void onMessage(ClientSessionChannel channel, Message message) {
                                    if (message.isSuccessful()) {
                                        OortComet.this._oort.joinComets(OortComet.this._cometURL, message);
                                    }
                                }
                            });
                            OortComet.this._subscriptions.clear();
                            OortComet.this.subscribe(OortComet.this._oort.getObservedChannels());
                            OortComet.this.getChannel("/oort/cloud").publish((Object)OortComet.this._oort.getKnownComets().toArray(), OortComet.this._cometSecret);
                        }
                    });
                } else {
                    OortComet.this._oort.getLogger().warn("Failed to connect to comet {}, message {}", new Object[]{OortComet.this._cometURL, message});
                }
            }
        });
    }

    protected void subscribe(Set<String> observedChannels) {
        for (String channel : observedChannels) {
            ClientSessionChannel.MessageListener listener;
            ClientSessionChannel.MessageListener existing;
            if (this._subscriptions.containsKey(channel) || (existing = this._subscriptions.putIfAbsent(channel, listener = new ClientSessionChannel.MessageListener(){

                public void onMessage(ClientSessionChannel channel, Message message) {
                    OortComet.this._oort.getLogger().debug("Republishing message {} from {}", new Object[]{message, OortComet.this._cometURL});
                    OortComet.this._oort.getOortSession().getChannel(message.getChannel()).publish(message.getData(), message.getId());
                }
            })) != null) continue;
            this._oort.getLogger().debug("Subscribing to {} on {}", new Object[]{channel, this._cometURL});
            this.getChannel(channel).subscribe(listener);
        }
    }

    protected void unsubscribe(String channel) {
        ClientSessionChannel.MessageListener listener = (ClientSessionChannel.MessageListener)this._subscriptions.remove(channel);
        if (listener != null) {
            this._oort.getLogger().debug("Unsubscribing from {} on {}", new Object[]{channel, this._cometURL});
            this.getChannel(channel).unsubscribe(listener);
        }
    }

    public void onFailure(Throwable x, Message[] messages) {
        this._oort.getLogger().debug("Failure, messages: " + Arrays.asList(messages), x);
    }

    public String toString() {
        return this._cometURL + "@" + this.getId();
    }
}

