/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.Authorizer;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.server.authorizer.GrantAuthorizer;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Seti
extends AbstractLifeCycle {
    public static final String SETI_ATTRIBUTE = Seti.class.getName();
    private static final String SETI_ALL_CHANNEL = "/seti/all";
    private final ConcurrentMap<String, Location> _uid2Location = new ConcurrentHashMap<String, Location>();
    private final Logger _logger;
    private final Oort _oort;
    private final String _setiId;
    private final LocalSession _session;

    public Seti(Oort oort) {
        this._logger = Log.getLogger((String)("Seti-" + oort.getURL()));
        this._oort = oort;
        this._setiId = oort.getURL().replace("://", "_").replace(":", "_").replace("/", "_");
        this._session = oort.getBayeuxServer().newLocalSession("seti");
    }

    protected Logger getLogger() {
        return this._logger;
    }

    public Oort getOort() {
        return this._oort;
    }

    public String getId() {
        return this._setiId;
    }

    protected void doStart() throws Exception {
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        bayeux.createIfAbsent("/seti/**", new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.addAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
            }
        }});
        String channel = "/seti/" + this._setiId;
        bayeux.createIfAbsent(channel, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
            }
        }});
        this._oort.observeChannel(channel);
        this._session.handshake();
        this._session.getChannel(channel).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveDirect(message);
            }
        });
        bayeux.createIfAbsent(SETI_ALL_CHANNEL, new ConfigurableServerChannel.Initializer[]{new ConfigurableServerChannel.Initializer(){

            public void configureChannel(ConfigurableServerChannel channel) {
                channel.setPersistent(true);
            }
        }});
        this._oort.observeChannel(SETI_ALL_CHANNEL);
        this._session.getChannel(SETI_ALL_CHANNEL).subscribe(new ClientSessionChannel.MessageListener(){

            public void onMessage(ClientSessionChannel channel, Message message) {
                Seti.this.receiveBroadcast(message);
            }
        });
    }

    protected void doStop() throws Exception {
        this._session.disconnect();
        BayeuxServer bayeux = this._oort.getBayeuxServer();
        this._oort.deobserveChannel(SETI_ALL_CHANNEL);
        bayeux.getChannel(SETI_ALL_CHANNEL).setPersistent(false);
        String channel = "/seti/" + this._setiId;
        this._oort.deobserveChannel(channel);
        bayeux.getChannel(channel).setPersistent(false);
        bayeux.getChannel("/seti/**").removeAuthorizer((Authorizer)GrantAuthorizer.GRANT_ALL);
    }

    public void associate(String userId, ServerSession session) {
        if (session == null) {
            throw new NullPointerException();
        }
        this._uid2Location.put(userId, new LocalLocation(session));
        this._logger.debug("Associated session {} to user {}", new Object[]{session, userId});
        this._oort.getBayeuxServer().getChannel(SETI_ALL_CHANNEL).publish((Session)this._session, (Object)new SetiPresence(userId, true), null);
    }

    public void disassociate(String userId) {
        Location location = (Location)this._uid2Location.remove(userId);
        this._logger.debug("Disassociated session {} from user {}", new Object[]{location, userId});
        this._oort.getBayeuxServer().getChannel(SETI_ALL_CHANNEL).publish((Session)this._session, (Object)new SetiPresence(userId, false), null);
    }

    public void sendMessage(String toUser, String toChannel, Object data) {
        this.sendMessage(Collections.singleton(toUser), toChannel, data);
    }

    public void sendMessage(Collection<String> toUsers, String toChannel, Object data) {
        for (String toUser : toUsers) {
            Location location = (Location)this._uid2Location.get(toUser);
            if (location == null) {
                location = new SetiLocation(SETI_ALL_CHANNEL);
            }
            location.send(toUser, toChannel, data);
        }
    }

    protected void receiveDirect(Message message) {
        this._logger.debug("Received direct message {}", new Object[]{message});
        this.receiveMessage(message);
    }

    protected void receiveBroadcast(Message message) {
        Map data = message.getDataAsMap();
        Boolean presence = (Boolean)data.get("presence");
        if (presence != null) {
            this.receivePresence(message);
        } else {
            this.receiveMessage(message);
        }
    }

    protected void receivePresence(Message message) {
        Map data = message.getDataAsMap();
        String setiId = (String)data.get("setiId");
        if (this._setiId.equals(setiId)) {
            return;
        }
        this._logger.debug("Received presence message {}", new Object[]{message});
        String userId = (String)data.get("uid");
        boolean presence = (Boolean)data.get("presence");
        if (presence) {
            this._uid2Location.put(userId, new SetiLocation("/seti/" + setiId));
        } else {
            this._uid2Location.remove(userId);
        }
    }

    protected void receiveMessage(Message message) {
        Map messageData = message.getDataAsMap();
        String userId = (String)messageData.get("uid");
        Location location = (Location)this._uid2Location.get(userId);
        this._logger.debug("Received message {} for location {}", new Object[]{message, location});
        if (location != null) {
            String channel = (String)messageData.get("channel");
            Object data = messageData.get("data");
            location.receive(userId, channel, data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiPresence
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "uid";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String PRESENCE_FIELD = "presence";

        private SetiPresence(String userId, boolean on) {
            this.put(USER_ID_FIELD, userId);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(PRESENCE_FIELD, on);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetiMessage
    extends HashMap<String, Object> {
        private static final String USER_ID_FIELD = "uid";
        private static final String CHANNEL_FIELD = "channel";
        private static final String SETI_ID_FIELD = "setiId";
        private static final String DATA_FIELD = "data";

        private SetiMessage(String toUser, String toChannel, Object data) {
            this.put(USER_ID_FIELD, toUser);
            this.put(CHANNEL_FIELD, toChannel);
            this.put(SETI_ID_FIELD, Seti.this._setiId);
            this.put(DATA_FIELD, data);
        }
    }

    protected class SetiLocation
    implements Location {
        private final String _channel;

        protected SetiLocation(String channelId) {
            this._channel = channelId;
        }

        public void send(String toUser, String toChannel, Object data) {
            Seti.this._session.getChannel(this._channel).publish((Object)new SetiMessage(toUser, toChannel, data));
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._channel + "]";
        }
    }

    protected class LocalLocation
    implements Location {
        private final ServerSession _session;

        protected LocalLocation(ServerSession session) {
            this._session = session;
        }

        public void send(String toUser, String toChannel, Object data) {
            this._session.deliver((Session)Seti.this._session.getServerSession(), toChannel, data, null);
        }

        public void receive(String toUser, String toChannel, Object data) {
            this.send(toUser, toChannel, data);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._session + "]";
        }
    }

    protected static interface Location {
        public void send(String var1, String var2, Object var3);

        public void receive(String var1, String var2, Object var3);
    }
}

