/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletResponse;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;

public abstract class OortConfigServlet
implements Servlet {
    public static final String OORT_URL_PARAM = "oort.url";
    public static final String OORT_SECRET_PARAM = "oort.secret";
    public static final String OORT_CHANNELS_PARAM = "oort.channels";
    public static final String OORT_CLIENT_DEBUG_PARAM = "clientDebug";
    public static final String OORT_ENABLE_ACK_EXTENSION_PARAM = "enableAckExtension";
    private ServletConfig _config;

    public ServletConfig getServletConfig() {
        return this._config;
    }

    public String getServletInfo() {
        return OortConfigServlet.class.toString();
    }

    public void init(ServletConfig config) throws ServletException {
        this._config = config;
        BayeuxServer bayeux = (BayeuxServer)config.getServletContext().getAttribute("org.cometd.bayeux");
        if (bayeux == null) {
            throw new UnavailableException("Missing org.cometd.bayeux attribute");
        }
        String url = this.provideOortURL();
        if (url == null) {
            throw new UnavailableException("Missing oort.url init parameter");
        }
        try {
            Oort oort = this.newOort(bayeux, url);
            boolean clientDebug = Boolean.parseBoolean(this._config.getInitParameter(OORT_CLIENT_DEBUG_PARAM));
            oort.setClientDebugEnabled(clientDebug);
            String secret = this._config.getInitParameter(OORT_SECRET_PARAM);
            if (secret != null) {
                oort.setSecret(secret);
            }
            boolean enableAckExtension = Boolean.parseBoolean(this._config.getInitParameter(OORT_ENABLE_ACK_EXTENSION_PARAM));
            oort.setAckExtensionEnabled(enableAckExtension);
            oort.start();
            this._config.getServletContext().setAttribute(Oort.OORT_ATTRIBUTE, (Object)oort);
            this.configureCloud(config, oort);
            String channels = this._config.getInitParameter(OORT_CHANNELS_PARAM);
            if (channels != null) {
                String[] patterns;
                for (String channel : patterns = channels.split(",")) {
                    if ((channel = channel.trim()).length() <= 0) continue;
                    oort.observeChannel(channel);
                }
            }
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    protected String provideOortURL() {
        return this._config.getInitParameter(OORT_URL_PARAM);
    }

    protected abstract void configureCloud(ServletConfig var1, Oort var2) throws Exception;

    protected Oort newOort(BayeuxServer bayeux, String url) {
        return new Oort(bayeux, url);
    }

    public void destroy() {
        try {
            Oort oort = (Oort)((Object)this._config.getServletContext().getAttribute(Oort.OORT_ATTRIBUTE));
            if (oort != null) {
                oort.stop();
            }
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
        finally {
            this._config.getServletContext().removeAttribute(Oort.OORT_ATTRIBUTE);
        }
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        HttpServletResponse response = (HttpServletResponse)res;
        response.sendError(503);
    }
}

