/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.cometd.bayeux.MarkedReference;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.oort.Oort;
import org.cometd.oort.OortObject;

public abstract class OortMap<K, V>
extends OortObject<ConcurrentMap<K, V>> {
    private static final String TYPE_FIELD_ENTRY_VALUE = "oort.map.entry";
    private static final String ACTION_FIELD_PUT_VALUE = "oort.map.put";
    private static final String ACTION_FIELD_PUT_ABSENT_VALUE = "oort.map.put.absent";
    private static final String ACTION_FIELD_REMOVE_VALUE = "oort.map.remove";
    private static final String KEY_FIELD = "oort.map.key";
    private static final String VALUE_FIELD = "oort.map.value";
    private final List<EntryListener<K, V>> listeners = new CopyOnWriteArrayList<EntryListener<K, V>>();

    protected OortMap(Oort oort, String name, OortObject.Factory<ConcurrentMap<K, V>> factory) {
        super(oort, name, factory);
    }

    public void addEntryListener(EntryListener<K, V> listener) {
        this.listeners.add(listener);
    }

    public void removeEntryListener(EntryListener<K, V> listener) {
        this.listeners.remove(listener);
    }

    public V putAndShare(K key, V value) {
        HashMap<String, Object> entry = new HashMap<String, Object>(2);
        entry.put(KEY_FIELD, key);
        entry.put(VALUE_FIELD, value);
        OortObject.Data data = new OortObject.Data(6);
        data.put("oort.info.version", this.nextVersion());
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_PUT_VALUE);
        this.logger.debug("Sharing map put {}", data);
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data);
        return (V)data.getResult();
    }

    public V putIfAbsentAndShare(K key, V value) {
        HashMap<String, Object> entry = new HashMap<String, Object>(2);
        entry.put(KEY_FIELD, key);
        entry.put(VALUE_FIELD, value);
        OortObject.Data data = new OortObject.Data(6);
        data.put("oort.info.version", this.nextVersion());
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_PUT_ABSENT_VALUE);
        this.logger.debug("Sharing map putIfAbsent {}", data);
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data);
        return (V)data.getResult();
    }

    public V removeAndShare(K key) {
        HashMap<String, K> entry = new HashMap<String, K>(1);
        entry.put(KEY_FIELD, key);
        OortObject.Data data = new OortObject.Data(6);
        data.put("oort.info.version", this.nextVersion());
        data.put("oort.info.url", this.getOort().getURL());
        data.put("oort.info.name", this.getName());
        data.put("oort.info.object", entry);
        data.put("oort.info.type", TYPE_FIELD_ENTRY_VALUE);
        data.put("oort.info.action", ACTION_FIELD_REMOVE_VALUE);
        this.logger.debug("Sharing map remove {}", data);
        BayeuxServer bayeuxServer = this.getOort().getBayeuxServer();
        bayeuxServer.getChannel(this.getChannelName()).publish((Session)this.getLocalSession(), data);
        return (V)data.getResult();
    }

    public V get(K key) {
        return ((ConcurrentMap)this.getInfo(this.getOort().getURL()).getObject()).get(key);
    }

    public V find(K key) {
        for (OortObject.Info info : this) {
            Object result = ((ConcurrentMap)info.getObject()).get(key);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public OortObject.Info<ConcurrentMap<K, V>> findInfo(K key) {
        for (OortObject.Info<ConcurrentMap<K, V>> info : this) {
            if (((ConcurrentMap)info.getObject()).get(key) == null) continue;
            return info;
        }
        return null;
    }

    @Override
    protected void onObject(Map<String, Object> data) {
        if (TYPE_FIELD_ENTRY_VALUE.equals(data.get("oort.info.type"))) {
            String action = (String)data.get("oort.info.action");
            final boolean remove = ACTION_FIELD_REMOVE_VALUE.equals(action);
            final boolean putAbsent = ACTION_FIELD_PUT_ABSENT_VALUE.equals(action);
            if (!(remove || putAbsent || ACTION_FIELD_PUT_VALUE.equals(action))) {
                throw new IllegalArgumentException(action);
            }
            String oortURL = (String)data.get("oort.info.url");
            OortObject.Info<ConcurrentMap<K, V>> info = this.getInfo(oortURL);
            if (info != null) {
                Map object = (Map)data.get("oort.info.object");
                final Object key = object.get(KEY_FIELD);
                final Object value = object.get(VALUE_FIELD);
                OortObject.Info newInfo = new OortObject.Info(this.getOort().getURL(), data);
                final ConcurrentMap map = (ConcurrentMap)info.getObject();
                newInfo.put("oort.info.object", map);
                final AtomicReference resultRef = new AtomicReference();
                MarkedReference old = this.setInfo(newInfo, new Runnable(){

                    @Override
                    public void run() {
                        if (remove) {
                            resultRef.set(map.remove(key));
                        } else if (putAbsent) {
                            resultRef.set(map.putIfAbsent(key, value));
                        } else {
                            resultRef.set(map.put(key, value));
                        }
                    }
                });
                Object result = resultRef.get();
                Entry entry = new Entry(key, result, value);
                this.logger.debug("{} {} map {} of {}", new Object[]{old.isMarked() ? "Performed" : "Skipped", newInfo.isLocal() ? "local" : "remote", remove ? "remove" : "put", entry});
                if (old.isMarked()) {
                    if (remove) {
                        this.notifyEntryRemoved(info, entry);
                    }
                    if (!putAbsent || result == null) {
                        this.notifyEntryPut(info, entry);
                    }
                }
                if (data instanceof OortObject.Data) {
                    ((OortObject.Data)data).setResult(result);
                }
            } else {
                this.logger.debug("No info for {}", (Object)oortURL);
            }
        } else {
            super.onObject(data);
        }
    }

    private void notifyEntryPut(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> entry) {
        for (EntryListener<K, V> listener : this.listeners) {
            try {
                listener.onPut(info, entry);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    private void notifyEntryRemoved(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> elements) {
        for (EntryListener<K, V> listener : this.listeners) {
            try {
                listener.onRemoved(info, elements);
            }
            catch (Throwable x) {
                this.logger.info("Exception while invoking listener " + listener, x);
            }
        }
    }

    public static class DeltaListener<K, V>
    implements OortObject.Listener<ConcurrentMap<K, V>> {
        private final OortMap<K, V> oortMap;

        public DeltaListener(OortMap<K, V> oortMap) {
            this.oortMap = oortMap;
        }

        @Override
        public void onUpdated(OortObject.Info<ConcurrentMap<K, V>> oldInfo, OortObject.Info<ConcurrentMap<K, V>> newInfo) {
            Map oldMap = oldInfo == null ? Collections.emptyMap() : (Map)oldInfo.getObject();
            HashMap newMap = new HashMap(newInfo.getObject());
            for (Map.Entry oldEntry : oldMap.entrySet()) {
                Object key = oldEntry.getKey();
                Object newValue = newMap.remove(key);
                Entry entry = new Entry(key, oldEntry.getValue(), newValue);
                if (newValue == null) {
                    ((OortMap)this.oortMap).notifyEntryRemoved(newInfo, entry);
                    continue;
                }
                ((OortMap)this.oortMap).notifyEntryPut(newInfo, entry);
            }
            for (Map.Entry newEntry : newMap.entrySet()) {
                Entry entry = new Entry(newEntry.getKey(), null, newEntry.getValue());
                ((OortMap)this.oortMap).notifyEntryPut(newInfo, entry);
            }
        }

        @Override
        public void onRemoved(OortObject.Info<ConcurrentMap<K, V>> info) {
            for (Map.Entry oldEntry : info.getObject().entrySet()) {
                Entry entry = new Entry(oldEntry.getKey(), oldEntry.getValue(), null);
                ((OortMap)this.oortMap).notifyEntryRemoved(info, entry);
            }
        }
    }

    public static class Entry<K, V> {
        private final K key;
        private final V oldValue;
        private final V newValue;

        protected Entry(K key, V oldValue, V newValue) {
            this.key = key;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        public K getKey() {
            return this.key;
        }

        public V getOldValue() {
            return this.oldValue;
        }

        public V getNewValue() {
            return this.newValue;
        }

        public String toString() {
            return String.format("(%s=%s->%s)", this.getKey(), this.getOldValue(), this.getNewValue());
        }
    }

    public static interface EntryListener<K, V>
    extends EventListener {
        public void onPut(OortObject.Info<ConcurrentMap<K, V>> var1, Entry<K, V> var2);

        public void onRemoved(OortObject.Info<ConcurrentMap<K, V>> var1, Entry<K, V> var2);

        public static class Adapter<K, V>
        implements EntryListener<K, V> {
            @Override
            public void onPut(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> entry) {
            }

            @Override
            public void onRemoved(OortObject.Info<ConcurrentMap<K, V>> info, Entry<K, V> entry) {
            }
        }
    }
}

