/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.cometd.bayeux.ChannelId;
import org.cometd.bayeux.Message;
import org.cometd.bayeux.client.ClientSession;
import org.cometd.bayeux.client.ClientSessionChannel;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OortMembership
extends AbstractLifeCycle
implements Dumpable {
    private final Map<String, OortComet> pendingComets = new HashMap<String, OortComet>();
    private final Map<String, ClientCometInfo> clientComets = new HashMap<String, ClientCometInfo>();
    private final Map<String, ServerCometInfo> serverComets = new HashMap<String, ServerCometInfo>();
    private final BayeuxServer.Extension oortExtension = new OortExtension();
    private final ConfigurableServerChannel.ServerChannelListener joinListener = new JoinListener();
    private final Object lock = this;
    private final Oort oort;
    private final Logger logger;

    OortMembership(Oort oort) {
        this.oort = oort;
        this.logger = LoggerFactory.getLogger((String)(((Object)((Object)this)).getClass().getName() + "." + Oort.replacePunctuation(oort.getURL(), '_')));
    }

    protected void doStart() throws Exception {
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        bayeuxServer.addExtension(this.oortExtension);
        ServerChannel oortServiceChannel = (ServerChannel)bayeuxServer.createChannelIfAbsent("/service/oort", new ConfigurableServerChannel.Initializer[0]).getReference();
        oortServiceChannel.addListener(this.joinListener);
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.disconnect();
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        ServerChannel channel = bayeuxServer.getChannel("/service/oort");
        if (channel != null) {
            channel.removeListener(this.joinListener);
        }
        bayeuxServer.removeExtension(this.oortExtension);
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect() {
        ArrayList<OortComet> comets;
        Iterator iterator = this.lock;
        synchronized (iterator) {
            comets = new ArrayList<OortComet>(this.pendingComets.values());
            this.pendingComets.clear();
            for (ClientCometInfo cometInfo : this.clientComets.values()) {
                comets.add(cometInfo.oortComet);
            }
            this.clientComets.clear();
            this.serverComets.clear();
        }
        for (OortComet comet : comets) {
            comet.disconnect();
        }
    }

    OortComet observeComet(String cometURL) {
        return this.observeComet(cometURL, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OortComet deobserveComet(String cometURL) {
        if (this.oort.getURL().equals(cometURL)) {
            return null;
        }
        ArrayList<OortComet> comets = new ArrayList<OortComet>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            OortComet comet = this.pendingComets.remove(cometURL);
            if (comet != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Disconnecting pending comet {} with {}", (Object)cometURL, (Object)comet);
                }
                comets.add(comet);
            }
            Iterator<ClientCometInfo> cometInfos = this.clientComets.values().iterator();
            while (cometInfos.hasNext()) {
                ClientCometInfo cometInfo = cometInfos.next();
                if (!cometInfo.matchesURL(cometURL)) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Disconnecting comet {}", (Object)cometInfo);
                }
                comet = cometInfo.oortComet;
                comets.add(comet);
                cometInfos.remove();
            }
        }
        for (OortComet comet : comets) {
            comet.disconnect();
        }
        return comets.isEmpty() ? null : (OortComet)((Object)comets.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<String> getKnownComets() {
        HashSet<String> result = new HashSet<String>();
        Object object = this.lock;
        synchronized (object) {
            for (ClientCometInfo cometInfo : this.clientComets.values()) {
                result.add(cometInfo.oortURL);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OortComet getComet(String cometURL) {
        Object object = this.lock;
        synchronized (object) {
            for (ClientCometInfo cometInfo : this.clientComets.values()) {
                if (!cometInfo.matchesURL(cometURL)) continue;
                return cometInfo.oortComet;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OortComet findComet(String cometURL) {
        Object object = this.lock;
        synchronized (object) {
            OortComet result = this.pendingComets.get(cometURL);
            if (result == null) {
                result = this.getComet(cometURL);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OortComet observeComet(String cometURL, String oortAliasURL) {
        OortComet oortComet;
        try {
            URI uri = new URI(cometURL);
            if (uri.getScheme() == null) {
                throw new IllegalArgumentException("Missing protocol in comet URL " + cometURL);
            }
            if (uri.getHost() == null) {
                throw new IllegalArgumentException("Missing host in comet URL " + cometURL);
            }
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
        if (this.oort.getURL().equals(cometURL)) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Observing comet {}", (Object)cometURL);
        }
        Object object = this.lock;
        synchronized (object) {
            oortComet = this.oort.getComet(cometURL);
            if (oortComet != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Comet {} is already connected with {}", (Object)cometURL, (Object)oortComet);
                }
                return oortComet;
            }
            oortComet = this.pendingComets.get(cometURL);
            if (oortComet != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Comet {} is already connecting with {}", (Object)cometURL, (Object)oortComet);
                }
                return oortComet;
            }
            oortComet = this.createOortComet(cometURL);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Connecting to comet {} with {}", (Object)cometURL, (Object)oortComet);
        }
        Map<String, Object> fields = this.oort.newOortHandshakeFields(cometURL, oortAliasURL);
        this.oort.connectComet(oortComet, fields);
        return oortComet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OortComet createOortComet(String cometURL) {
        Object object = this.lock;
        synchronized (object) {
            OortComet oortComet = this.oort.newOortComet(cometURL);
            this.oort.configureOortComet(oortComet);
            oortComet.getChannel("/meta/handshake").addListener((ClientSessionChannel.ClientSessionChannelListener)new HandshakeListener(cometURL, oortComet));
            this.pendingComets.put(cometURL, oortComet);
            return oortComet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void observeChannels(Set<String> channels) {
        ArrayList<OortComet> oortComets = new ArrayList<OortComet>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            for (ClientCometInfo cometInfo : this.clientComets.values()) {
                oortComets.add(cometInfo.oortComet);
            }
        }
        for (OortComet oortComet : oortComets) {
            oortComet.subscribe(channels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deobserveChannel(String channelName) {
        ArrayList<OortComet> oortComets = new ArrayList<OortComet>();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            for (ClientCometInfo cometInfo : this.clientComets.values()) {
                oortComets.add(cometInfo.oortComet);
            }
        }
        for (OortComet oortComet : oortComets) {
            oortComet.unsubscribe(channelName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean containsServerSession(ServerSession session) {
        Object object = this.lock;
        synchronized (object) {
            for (ServerCometInfo cometInfo : this.serverComets.values()) {
                if (!cometInfo.session.getId().equals(session.getId())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCometConnected(String oortURL) {
        Object object = this.lock;
        synchronized (object) {
            for (ServerCometInfo serverCometInfo : this.serverComets.values()) {
                if (!serverCometInfo.oortURL.equals(oortURL)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<String> knownOortIds() {
        ArrayList<String> result;
        Object object = this.lock;
        synchronized (object) {
            result = new ArrayList<String>(this.clientComets.keySet());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(Appendable out, String indent) throws IOException {
        ArrayList<ServerCometInfo> serverComets;
        ArrayList<ClientCometInfo> clientComets;
        ArrayList<OortComet> pendingComets;
        Object object = this.lock;
        synchronized (object) {
            pendingComets = new ArrayList<OortComet>(this.pendingComets.values());
            clientComets = new ArrayList<ClientCometInfo>(this.clientComets.values());
            serverComets = new ArrayList<ServerCometInfo>(this.serverComets.values());
        }
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{new DumpableCollection("pending", pendingComets), new DumpableCollection("clientComets", clientComets), new DumpableCollection("serverComets", serverComets)});
    }

    public String toString() {
        return String.format("%s@%x[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.oort.getURL());
    }

    private class JoinCallback
    implements ClientSession.MessageListener,
    Runnable {
        private final OortComet oortComet;

        private JoinCallback(OortComet oortComet) {
            this.oortComet = oortComet;
        }

        public void onMessage(Message message) {
            if (message.isSuccessful()) {
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Join message successful {}", (Object)message);
                }
            } else {
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Join message failure, retrying {}", (Object)message);
                }
                OortMembership.this.oort.getScheduler().schedule(this, 1L, TimeUnit.SECONDS);
            }
        }

        @Override
        public void run() {
            this.oortComet.open(this);
        }
    }

    private class JoinListener
    implements ServerChannel.MessageListener {
        private JoinListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
            if (OortMembership.this.logger.isDebugEnabled()) {
                OortMembership.this.logger.debug("Received join message {}", (Object)message);
            }
            Map data = message.getDataAsMap();
            String remoteOortId = (String)data.get("oortId");
            String remoteOortURL = (String)data.get("oortURL");
            if (remoteOortURL != null && remoteOortId != null) {
                boolean notify = false;
                HashSet<String> staleComets = null;
                Iterator iterator = OortMembership.this.lock;
                synchronized (iterator) {
                    ClientCometInfo clientCometInfo = (ClientCometInfo)OortMembership.this.clientComets.get(remoteOortId);
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Current client {}", (Object)clientCometInfo);
                    }
                    Iterator iterator2 = OortMembership.this.serverComets.values().iterator();
                    while (iterator2.hasNext()) {
                        ServerCometInfo serverCometInfo = (ServerCometInfo)iterator2.next();
                        if (!remoteOortURL.equals(serverCometInfo.oortURL)) continue;
                        String oortId = serverCometInfo.oortId;
                        if (remoteOortId.equals(oortId)) {
                            boolean handshakeReceived = serverCometInfo.state == RemoteState.HANDSHAKE_RECEIVED;
                            boolean bl = notify = clientCometInfo != null && handshakeReceived;
                            if (OortMembership.this.logger.isDebugEnabled()) {
                                OortMembership.this.logger.debug("Current server {}", (Object)serverCometInfo);
                            }
                            if (handshakeReceived) {
                                serverCometInfo.state = RemoteState.JOIN_RECEIVED;
                            }
                            if (!notify) continue;
                            serverCometInfo.state = RemoteState.JOINED;
                            continue;
                        }
                        if (OortMembership.this.logger.isDebugEnabled()) {
                            OortMembership.this.logger.debug("Stale server {}", (Object)serverCometInfo);
                        }
                        iterator2.remove();
                        if (staleComets == null) {
                            staleComets = new HashSet<String>(4);
                        }
                        staleComets.add(oortId);
                    }
                }
                if (staleComets != null) {
                    for (String oortId : staleComets) {
                        OortMembership.this.oort.notifyCometLeft(oortId, remoteOortURL);
                    }
                }
                if (notify) {
                    OortMembership.this.oort.notifyCometJoined(remoteOortId, remoteOortURL);
                } else if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Skipping remote join event: {}|{}", (Object)remoteOortId, (Object)remoteOortURL);
                }
            }
            return true;
        }
    }

    private class OortCometLoopListener
    implements ServerSession.MessageListener {
        private OortCometLoopListener() {
        }

        public boolean onMessage(ServerSession session, ServerSession sender, ServerMessage message) {
            if (ChannelId.isBroadcast((String)message.getChannel()) && sender != null && (sender.getId().equals(session.getId()) || OortMembership.this.oort.isOort(sender))) {
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Blocked {} from {} to {}", new Object[]{message, sender, session});
                }
                return false;
            }
            if (OortMembership.this.logger.isDebugEnabled()) {
                OortMembership.this.logger.debug("Allowed {} from {} to {}", new Object[]{message, sender, session});
            }
            return true;
        }
    }

    private class OortCometDisconnectListener
    implements ServerSession.RemovedListener {
        private OortCometDisconnectListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removed(ServerSession session, ServerMessage message, boolean timeout) {
            ServerCometInfo serverCometInfo = null;
            Object object = OortMembership.this.lock;
            synchronized (object) {
                Iterator serverCometInfos = OortMembership.this.serverComets.values().iterator();
                while (serverCometInfos.hasNext()) {
                    ServerCometInfo info = (ServerCometInfo)serverCometInfos.next();
                    if (!info.session.getId().equals(session.getId())) continue;
                    serverCometInfos.remove();
                    serverCometInfo = info;
                    break;
                }
            }
            if (serverCometInfo != null) {
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Disconnected from server {}", (Object)serverCometInfo);
                }
                String remoteOortId = serverCometInfo.oortId;
                String remoteOortURL = serverCometInfo.oortURL;
                if (!timeout) {
                    OortComet oortComet;
                    Object object2 = OortMembership.this.lock;
                    synchronized (object2) {
                        ClientCometInfo clientCometInfo;
                        oortComet = (OortComet)((Object)OortMembership.this.pendingComets.remove(remoteOortURL));
                        if (oortComet == null && (clientCometInfo = (ClientCometInfo)OortMembership.this.clientComets.remove(remoteOortId)) != null) {
                            oortComet = clientCometInfo.oortComet;
                        }
                    }
                    if (oortComet != null) {
                        if (OortMembership.this.logger.isDebugEnabled()) {
                            OortMembership.this.logger.debug("Disconnecting from comet {} with {}", (Object)remoteOortURL, (Object)oortComet);
                        }
                        oortComet.disconnect();
                    }
                }
                if (OortMembership.this.isRunning()) {
                    OortMembership.this.oort.notifyCometLeft(remoteOortId, remoteOortURL);
                }
            }
        }
    }

    private class OortExtension
    implements BayeuxServer.Extension {
        private OortExtension() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sendMeta(ServerSession session, ServerMessage.Mutable reply) {
            if (!"/meta/handshake".equals(reply.getChannel())) {
                return true;
            }
            if (session == null || session.isLocalSession()) {
                return true;
            }
            Map messageExt = reply.getAssociated().getExt();
            if (messageExt == null) {
                return true;
            }
            Object messageOortExtObject = messageExt.get("org.cometd.oort");
            if (!(messageOortExtObject instanceof Map)) {
                return true;
            }
            Map replyExt = reply.getExt(true);
            HashMap<String, String> replyOortExt = new HashMap<String, String>(2);
            replyExt.put("org.cometd.oort", replyOortExt);
            replyOortExt.put("oortURL", OortMembership.this.oort.getURL());
            replyOortExt.put("oortId", OortMembership.this.oort.getId());
            if (!reply.isSuccessful()) {
                return true;
            }
            Map messageOortExt = (Map)messageOortExtObject;
            String remoteOortURL = (String)messageOortExt.get("oortURL");
            String cometURL = (String)messageOortExt.get("cometURL");
            String remoteOortId = (String)messageOortExt.get("oortId");
            session.setAttribute("org.cometd.oort.cometURL", (Object)remoteOortURL);
            if (OortMembership.this.oort.getId().equals(remoteOortId)) {
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Detected self connect from {} to {}, disconnecting", (Object)remoteOortURL, (Object)cometURL);
                }
                this.disconnect(session, reply);
            } else {
                String cometAliasURL;
                ServerCometInfo existingServerCometInfo;
                ClientCometInfo clientCometInfo;
                boolean sendJoin = false;
                ServerCometInfo serverCometInfo = new ServerCometInfo(remoteOortId, remoteOortURL, session);
                Object object = OortMembership.this.lock;
                synchronized (object) {
                    clientCometInfo = (ClientCometInfo)OortMembership.this.clientComets.get(remoteOortId);
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Current client {}", (Object)clientCometInfo);
                    }
                    if ((existingServerCometInfo = OortMembership.this.serverComets.put(remoteOortId, serverCometInfo)) != null) {
                        serverCometInfo.state = existingServerCometInfo.state;
                    } else {
                        serverCometInfo.state = RemoteState.HANDSHAKE_RECEIVED;
                    }
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Registered server {}", (Object)serverCometInfo);
                    }
                    if (clientCometInfo != null) {
                        boolean bl = sendJoin = clientCometInfo.state == LocalState.HANDSHAKE_SENT;
                        if (sendJoin) {
                            clientCometInfo.state = LocalState.JOIN_SENT;
                        }
                    }
                }
                if (existingServerCometInfo != null) {
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Server already known, disconnecting {}", (Object)existingServerCometInfo);
                    }
                    existingServerCometInfo.session.disconnect();
                }
                session.addListener((ServerSession.ServerSessionListener)new OortCometDisconnectListener());
                session.addListener((ServerSession.ServerSessionListener)new OortCometLoopListener());
                if (clientCometInfo != null) {
                    if (sendJoin) {
                        OortComet oortComet = clientCometInfo.oortComet;
                        oortComet.open(new JoinCallback(oortComet));
                    } else if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Client already joined {}", (Object)clientCometInfo);
                    }
                }
                if ((cometAliasURL = (String)messageOortExt.get("oortAliasURL")) != null && OortMembership.this.oort.findComet(cometAliasURL) != null) {
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Comet {} exists with alias {}, avoiding to establish connection", (Object)remoteOortURL, (Object)cometAliasURL);
                    }
                } else {
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Comet {} is unknown, establishing connection", (Object)remoteOortURL);
                    }
                    OortMembership.this.observeComet(remoteOortURL, cometURL);
                }
            }
            return true;
        }

        private void disconnect(ServerSession session, ServerMessage.Mutable message) {
            OortMembership.this.oort.getBayeuxServer().removeSession(session);
            message.setSuccessful(false);
            Map advice = message.getAdvice(true);
            advice.put("reconnect", "none");
        }
    }

    private class HandshakeListener
    implements ClientSessionChannel.MessageListener {
        private final String cometURL;
        private final OortComet oortComet;

        private HandshakeListener(String cometURL, OortComet oortComet) {
            this.cometURL = cometURL;
            this.oortComet = oortComet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(ClientSessionChannel channel, Message message) {
            ServerCometInfo serverCometInfo;
            Map ext;
            if (OortMembership.this.logger.isDebugEnabled()) {
                OortMembership.this.logger.debug("Received handshake reply message {}", (Object)message);
            }
            if ((ext = message.getExt()) == null) {
                return;
            }
            Object oortExtObject = ext.get("org.cometd.oort");
            if (!(oortExtObject instanceof Map)) {
                return;
            }
            Map oortExt = (Map)oortExtObject;
            String oortId = (String)oortExt.get("oortId");
            String oortURL = (String)oortExt.get("oortURL");
            ArrayList<ClientCometInfo> staleClientCometInfos = new ArrayList<ClientCometInfo>();
            boolean notify = false;
            Iterator iterator = OortMembership.this.lock;
            synchronized (iterator) {
                ClientCometInfo clientCometInfo;
                Iterator iterator2 = OortMembership.this.clientComets.values().iterator();
                while (iterator2.hasNext()) {
                    clientCometInfo = (ClientCometInfo)iterator2.next();
                    if (!clientCometInfo.matchesURL(this.cometURL) && !clientCometInfo.matchesURL(oortURL)) continue;
                    iterator2.remove();
                    staleClientCometInfos.add(clientCometInfo);
                    if (!OortMembership.this.logger.isDebugEnabled()) continue;
                    OortMembership.this.logger.debug("Unregistered client comet {}", (Object)clientCometInfo);
                }
                clientCometInfo = new ClientCometInfo(oortId, oortURL, this.oortComet);
                serverCometInfo = (ServerCometInfo)OortMembership.this.serverComets.get(oortId);
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Current server {}", (Object)serverCometInfo);
                }
                if (message.isSuccessful()) {
                    OortMembership.this.pendingComets.remove(this.cometURL);
                    OortMembership.this.clientComets.put(oortId, clientCometInfo);
                    if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Registered client comet {}", (Object)clientCometInfo);
                    }
                    if (!this.cometURL.equals(oortURL)) {
                        clientCometInfo.addAliasURL(this.cometURL);
                        if (OortMembership.this.logger.isDebugEnabled()) {
                            OortMembership.this.logger.debug("Added comet alias {}", (Object)clientCometInfo);
                        }
                    }
                    if (serverCometInfo != null) {
                        clientCometInfo.state = LocalState.JOIN_SENT;
                        boolean bl = notify = serverCometInfo.state == RemoteState.JOIN_RECEIVED;
                        if (notify) {
                            serverCometInfo.state = RemoteState.JOINED;
                        }
                    }
                }
            }
            for (ClientCometInfo info : staleClientCometInfos) {
                OortComet comet = info.oortComet;
                if (comet == this.oortComet) continue;
                if (OortMembership.this.logger.isDebugEnabled()) {
                    OortMembership.this.logger.debug("Disconnecting stale client comet {}", (Object)info);
                }
                comet.disconnect();
            }
            if (message.isSuccessful()) {
                if (serverCometInfo != null) {
                    this.oortComet.open(new JoinCallback(this.oortComet));
                    if (notify) {
                        OortMembership.this.oort.notifyCometJoined(oortId, oortURL);
                    } else if (OortMembership.this.logger.isDebugEnabled()) {
                        OortMembership.this.logger.debug("Skipping local join event: {}|{}", (Object)oortId, (Object)oortURL);
                    }
                }
            } else if (OortMembership.this.logger.isDebugEnabled()) {
                OortMembership.this.logger.debug("Handshake failed to comet {}, message {}", (Object)this.cometURL, (Object)message);
            }
        }
    }

    private static class ClientCometInfo
    extends CometInfo {
        private final OortComet oortComet;
        private Set<String> aliases;
        private LocalState state = LocalState.HANDSHAKE_SENT;

        private ClientCometInfo(String oortId, String oortURL, OortComet oortComet) {
            super(oortId, oortURL);
            this.oortComet = oortComet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addAliasURL(String url) {
            ClientCometInfo clientCometInfo = this;
            synchronized (clientCometInfo) {
                if (this.aliases == null) {
                    this.aliases = new HashSet<String>();
                }
                this.aliases.add(url);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean matchesURL(String url) {
            if (this.oortURL.equals(url)) {
                return true;
            }
            ClientCometInfo clientCometInfo = this;
            synchronized (clientCometInfo) {
                return this.aliases != null && this.aliases.contains(url);
            }
        }

        @Override
        public String toString() {
            return String.format("%s[%s,%s,aliases=%s]", new Object[]{super.toString(), this.state, this.oortComet, Objects.toString(this.aliases, "[]")});
        }
    }

    private static class ServerCometInfo
    extends CometInfo {
        private final ServerSession session;
        private RemoteState state = RemoteState.DISCONNECTED;

        private ServerCometInfo(String oortId, String oortURL, ServerSession session) {
            super(oortId, oortURL);
            this.session = session;
        }

        @Override
        public String toString() {
            return String.format("%s[%s,%s]", new Object[]{super.toString(), this.state, this.session});
        }
    }

    private static abstract class CometInfo {
        protected final String oortId;
        protected final String oortURL;

        protected CometInfo(String oortId, String oortURL) {
            this.oortId = oortId;
            this.oortURL = oortURL;
        }

        public String toString() {
            return String.format("%s@%x[%s|%s]", this.getClass().getSimpleName(), this.hashCode(), this.oortId, this.oortURL);
        }
    }

    private static enum RemoteState {
        DISCONNECTED,
        HANDSHAKE_RECEIVED,
        JOIN_RECEIVED,
        JOINED;

    }

    private static enum LocalState {
        HANDSHAKE_SENT,
        JOIN_SENT;

    }
}

