/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.oort;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.Session;
import org.cometd.bayeux.server.BayeuxServer;
import org.cometd.bayeux.server.ConfigurableServerChannel;
import org.cometd.bayeux.server.LocalSession;
import org.cometd.bayeux.server.ServerChannel;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerSession;
import org.cometd.oort.Oort;
import org.cometd.oort.OortComet;
import org.cometd.server.BayeuxServerImpl;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OortService<R, C>
extends AbstractLifeCycle
implements ServerChannel.MessageListener {
    private static final String CONTEXT_FIELD = "oort.service.context";
    private static final String DATA_FIELD = "oort.service.data";
    private static final String ID_FIELD = "oort.service.id";
    private static final String OORT_URL_FIELD = "oort.service.url";
    private static final String PARAMETER_FIELD = "oort.service.parameter";
    private static final String RESULT_FIELD = "oort.service.result";
    private static final String TIMEOUT_FIELD = "oort.service.timeout";
    private final AtomicLong contextIds = new AtomicLong();
    private final ConcurrentMap<Long, Map<String, Object>> callbacks = new ConcurrentHashMap<Long, Map<String, Object>>();
    private final Oort oort;
    private final String name;
    private final String forwardChannelName;
    private final String broadcastChannelName;
    private final String resultChannelName;
    private final LocalSession session;
    private final Logger logger;
    private volatile long timeout = 5000L;

    protected OortService(Oort oort, String name) {
        this.oort = oort;
        this.name = name;
        this.forwardChannelName = "/service/oort/service/" + name;
        this.broadcastChannelName = "/oort/service/" + name;
        this.resultChannelName = this.forwardChannelName + "/result";
        this.session = oort.getBayeuxServer().newLocalSession(name);
        this.logger = LoggerFactory.getLogger((String)Oort.loggerName(((Object)((Object)this)).getClass(), oort.getURL(), name));
    }

    public Oort getOort() {
        return this.oort;
    }

    public String getName() {
        return this.name;
    }

    public LocalSession getLocalSession() {
        return this.session;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    protected void doStart() throws Exception {
        this.session.handshake();
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        ((ServerChannel)bayeuxServer.createChannelIfAbsent(this.forwardChannelName, new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)this);
        ((ServerChannel)bayeuxServer.createChannelIfAbsent(this.broadcastChannelName, new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)this);
        ((ServerChannel)bayeuxServer.createChannelIfAbsent(this.resultChannelName, new ConfigurableServerChannel.Initializer[0]).getReference()).addListener((ConfigurableServerChannel.ServerChannelListener)this);
        this.oort.observeChannel(this.broadcastChannelName);
        this.oort.addExactSubscriptions(this.broadcastChannelName);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Started {}", (Object)this);
        }
    }

    protected void doStop() throws Exception {
        this.oort.removeExactSubscriptions(this.broadcastChannelName);
        this.oort.deobserveChannel(this.broadcastChannelName);
        BayeuxServer bayeuxServer = this.oort.getBayeuxServer();
        ServerChannel channel = bayeuxServer.getChannel(this.resultChannelName);
        if (channel != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this);
        }
        if ((channel = bayeuxServer.getChannel(this.broadcastChannelName)) != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this);
        }
        if ((channel = bayeuxServer.getChannel(this.forwardChannelName)) != null) {
            channel.removeListener((ConfigurableServerChannel.ServerChannelListener)this);
        }
        this.session.disconnect();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Stopped {}", (Object)this);
        }
    }

    protected boolean forward(String targetOortURL, Object parameter, C context) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(4);
        long contextId = this.contextIds.incrementAndGet();
        ctx.put(ID_FIELD, contextId);
        ctx.put(CONTEXT_FIELD, context);
        this.callbacks.put(contextId, ctx);
        HashMap<String, Object> data = new HashMap<String, Object>(3);
        data.put(ID_FIELD, contextId);
        data.put(PARAMETER_FIELD, parameter);
        String localOortURL = this.getOort().getURL();
        data.put(OORT_URL_FIELD, localOortURL);
        if (targetOortURL == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Broadcasting action: {}", data);
            }
            this.startTimeout(ctx);
            this.oort.getBayeuxServer().getChannel(this.broadcastChannelName).publish((Session)this.getLocalSession(), data, Promise.noop());
            return true;
        }
        if (localOortURL.equals(targetOortURL)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Forwarding action locally ({}): {}", (Object)localOortURL, data);
            }
            this.startTimeout(ctx);
            this.onForwardMessage(data, false);
            return true;
        }
        OortComet comet = this.getOort().getComet(targetOortURL);
        if (comet != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Forwarding action from {} to {}: {}", new Object[]{localOortURL, targetOortURL, data});
            }
            this.startTimeout(ctx);
            comet.getChannel(this.forwardChannelName).publish(data);
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Could not forward action from {} to {}: {}", new Object[]{localOortURL, targetOortURL, data});
        }
        return false;
    }

    public boolean onMessage(ServerSession from, ServerChannel channel, ServerMessage.Mutable message) {
        if (this.forwardChannelName.equals(message.getChannel())) {
            this.onForwardMessage(message.getDataAsMap(), false);
        } else if (this.broadcastChannelName.equals(message.getChannel())) {
            this.onForwardMessage(message.getDataAsMap(), true);
        } else if (this.resultChannelName.equals(message.getChannel())) {
            this.onResultMessage(message.getDataAsMap());
        }
        return true;
    }

    protected void onForwardMessage(Map<String, Object> data, boolean broadcast) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Received {} action {}", (Object)(broadcast ? "broadcast" : "forwarded"), data);
        }
        HashMap<String, Object> resultData = new HashMap<String, Object>(3);
        resultData.put(ID_FIELD, data.get(ID_FIELD));
        resultData.put(OORT_URL_FIELD, this.getOort().getURL());
        String oortURL = (String)data.get(OORT_URL_FIELD);
        try {
            Result<R> result = this.onForward(new Request(this.oort.getURL(), data.get(PARAMETER_FIELD), oortURL));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Forwarded action result {}", result);
            }
            if (result.succeeded()) {
                resultData.put(RESULT_FIELD, true);
                resultData.put(DATA_FIELD, result.data);
            } else if (result.failed()) {
                resultData.put(RESULT_FIELD, false);
                resultData.put(DATA_FIELD, result.data);
            } else {
                if (broadcast) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Ignoring broadcast action result {}", result);
                    }
                    return;
                }
                resultData.put(RESULT_FIELD, false);
                resultData.put(DATA_FIELD, result.data);
            }
        }
        catch (Throwable x) {
            if (broadcast) {
                return;
            }
            String failure = x.getMessage();
            if (failure == null || failure.length() == 0) {
                failure = x.getClass().getName();
            }
            resultData.put(RESULT_FIELD, false);
            resultData.put(DATA_FIELD, failure);
        }
        if (this.getOort().getURL().equals(oortURL)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Returning forwarded action result {} to local {}", resultData, (Object)oortURL);
            }
            this.onResultMessage(resultData);
        } else {
            OortComet comet = this.getOort().getComet(oortURL);
            if (comet != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Returning forwarded action result {} to remote {}", resultData, (Object)oortURL);
                }
                comet.getChannel(this.resultChannelName).publish(resultData);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("Could not return forwarded action result {} to remote {}", resultData, (Object)oortURL);
            }
        }
    }

    protected void onResultMessage(Map<String, Object> data) {
        long actionId = ((Number)data.get(ID_FIELD)).longValue();
        Map ctx = (Map)this.callbacks.remove(actionId);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Action result {} with context {}", data, (Object)ctx);
        }
        if (ctx != null) {
            this.cancelTimeout(ctx);
            Object context = ctx.get(CONTEXT_FIELD);
            boolean success = (Boolean)data.get(RESULT_FIELD);
            if (success) {
                Object result = data.get(DATA_FIELD);
                this.onForwardSucceeded(result, context);
            } else {
                Object failure = data.get(DATA_FIELD);
                this.onForwardFailed(failure, context);
            }
        }
    }

    private void startTimeout(Map<String, Object> ctx) {
        long contextId = ((Number)ctx.get(ID_FIELD)).longValue();
        TimeoutTask timeoutTask = new TimeoutTask(contextId);
        ctx.put(TIMEOUT_FIELD, ((BayeuxServerImpl)this.oort.getBayeuxServer()).schedule((Runnable)timeoutTask, this.getTimeout()));
    }

    private void cancelTimeout(Map<String, Object> ctx) {
        Scheduler.Task timeoutTask = (Scheduler.Task)ctx.get(TIMEOUT_FIELD);
        if (timeoutTask != null) {
            timeoutTask.cancel();
        }
    }

    protected abstract Result<R> onForward(Request var1);

    protected abstract void onForwardSucceeded(R var1, C var2);

    protected abstract void onForwardFailed(Object var1, C var2);

    public String toString() {
        return String.format("%s[%s]@%s", ((Object)((Object)this)).getClass().getSimpleName(), this.getName(), this.getOort().getURL());
    }

    private class TimeoutTask
    implements Runnable {
        private final long contextId;

        private TimeoutTask(long contextId) {
            this.contextId = contextId;
        }

        @Override
        public void run() {
            HashMap<String, Object> data = new HashMap<String, Object>(3);
            data.put(OortService.ID_FIELD, this.contextId);
            data.put(OortService.RESULT_FIELD, false);
            data.put(OortService.DATA_FIELD, new TimeoutException());
            OortService.this.onResultMessage(data);
        }
    }

    public static class ServerContext {
        private final ServerSession session;
        private final ServerMessage message;

        public ServerContext(ServerSession session, ServerMessage message) {
            this.session = session;
            this.message = message;
        }

        public ServerSession getServerSession() {
            return this.session;
        }

        public ServerMessage getServerMessage() {
            return this.message;
        }
    }

    public static class Result<U> {
        private final Boolean result;
        private final Object data;

        private Result(Boolean result, Object data) {
            this.result = result;
            this.data = data;
        }

        public static <S> Result<S> success(S result) {
            return new Result(true, result);
        }

        public static <S> Result<S> failure(Object failure) {
            return new Result(false, failure);
        }

        public static <S> Result<S> ignore(Object data) {
            return new Result(null, data);
        }

        private boolean succeeded() {
            return this.result != null && this.result != false;
        }

        private boolean failed() {
            return this.result != null && this.result == false;
        }

        public String toString() {
            return String.format("%s[%s] %s", this.getClass().getSimpleName(), this.result == null ? "ignored" : (this.result != false ? "success" : "failure"), this.data);
        }
    }

    public static class Request {
        private final String localOortURL;
        private final Object data;
        private final String oortURL;

        private Request(String localOortURL, Object data, String oortURL) {
            this.localOortURL = localOortURL;
            this.data = data;
            this.oortURL = oortURL;
        }

        public Object getData() {
            return this.data;
        }

        public Map<String, Object> getDataAsMap() {
            return (Map)this.getData();
        }

        public String getOortURL() {
            return this.oortURL;
        }

        public boolean isLocal() {
            return this.localOortURL.equals(this.getOortURL());
        }
    }
}

