/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.pull.util;

import org.apache.xerces.xni.XNIException;
import org.cyberneko.pull.XMLEvent;
import org.cyberneko.pull.event.CDATAEvent;
import org.cyberneko.pull.event.CharactersEvent;
import org.cyberneko.pull.event.CommentEvent;
import org.cyberneko.pull.event.DoctypeDeclEvent;
import org.cyberneko.pull.event.DocumentEvent;
import org.cyberneko.pull.event.ElementEvent;
import org.cyberneko.pull.event.GeneralEntityEvent;

public class DefaultHandler {
    public void handleEvent(XMLEvent xMLEvent) throws XNIException {
        switch (xMLEvent.type) {
            case 7: {
                CDATAEvent cDATAEvent = (CDATAEvent)xMLEvent;
                if (cDATAEvent.start) {
                    this.handleStartCDATA(cDATAEvent);
                    break;
                }
                this.handleEndCDATA(cDATAEvent);
                break;
            }
            case 2: {
                CharactersEvent charactersEvent = (CharactersEvent)xMLEvent;
                if (charactersEvent.ignorable) {
                    this.handleIgnorableWhitespace(charactersEvent);
                    break;
                }
                this.handleCharacters(charactersEvent);
                break;
            }
            case 5: {
                CommentEvent commentEvent = (CommentEvent)xMLEvent;
                this.handleComment(commentEvent);
                break;
            }
            case 9: {
                DoctypeDeclEvent doctypeDeclEvent = (DoctypeDeclEvent)xMLEvent;
                this.handleDoctypeDecl(doctypeDeclEvent);
                break;
            }
            case 0: {
                DocumentEvent documentEvent = (DocumentEvent)xMLEvent;
                if (documentEvent.start) {
                    this.handleStartDocument(documentEvent);
                    break;
                }
                this.handleEndDocument(documentEvent);
                break;
            }
            case 1: {
                ElementEvent elementEvent = (ElementEvent)xMLEvent;
                if (elementEvent.start) {
                    this.handleStartElement(elementEvent);
                    break;
                }
                this.handleEndElement(elementEvent);
                break;
            }
            case 4: {
                GeneralEntityEvent generalEntityEvent = (GeneralEntityEvent)xMLEvent;
                if (generalEntityEvent.start) {
                    this.handleStartGeneralEntity(generalEntityEvent);
                    break;
                }
                this.handleEndGeneralEntity(generalEntityEvent);
                break;
            }
            default: {
                this.handleUnknownEvent(xMLEvent);
            }
        }
    }

    public void handleStartCDATA(CDATAEvent cDATAEvent) throws XNIException {
    }

    public void handleEndCDATA(CDATAEvent cDATAEvent) throws XNIException {
    }

    public void handleIgnorableWhitespace(CharactersEvent charactersEvent) throws XNIException {
    }

    public void handleCharacters(CharactersEvent charactersEvent) throws XNIException {
    }

    public void handleComment(CommentEvent commentEvent) throws XNIException {
    }

    public void handleDoctypeDecl(DoctypeDeclEvent doctypeDeclEvent) throws XNIException {
    }

    public void handleStartDocument(DocumentEvent documentEvent) throws XNIException {
    }

    public void handleEndDocument(DocumentEvent documentEvent) throws XNIException {
    }

    public void handleStartElement(ElementEvent elementEvent) throws XNIException {
    }

    public void handleEndElement(ElementEvent elementEvent) throws XNIException {
    }

    public void handleStartGeneralEntity(GeneralEntityEvent generalEntityEvent) throws XNIException {
    }

    public void handleEndGeneralEntity(GeneralEntityEvent generalEntityEvent) throws XNIException {
    }

    public void handleUnknownEvent(XMLEvent xMLEvent) throws XNIException {
        throw new XNIException("unknown event type (" + xMLEvent.type + ')');
    }
}

