/*
 * Decompiled with CFR 0.152.
 */
package org.cyberneko.pull.util;

import java.lang.reflect.Method;
import java.util.Enumeration;
import org.apache.xerces.util.AugmentationsImpl;
import org.apache.xerces.util.XMLAttributesImpl;
import org.apache.xerces.util.XMLStringBuffer;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.cyberneko.pull.XMLEvent;
import org.cyberneko.pull.event.CDATAEvent;
import org.cyberneko.pull.event.CharactersEvent;
import org.cyberneko.pull.event.CommentEvent;
import org.cyberneko.pull.event.DoctypeDeclEvent;
import org.cyberneko.pull.event.DocumentEvent;
import org.cyberneko.pull.event.ElementEvent;
import org.cyberneko.pull.event.GeneralEntityEvent;
import org.cyberneko.pull.event.PrefixMappingEvent;
import org.cyberneko.pull.event.ProcessingInstructionEvent;
import org.cyberneko.pull.event.TextDeclEvent;
import org.cyberneko.pull.util.EventQueue;

public class EventCollector
extends EventQueue
implements XMLComponent,
XMLDocumentHandler {
    protected static final String REUSE_BUFFERS = "http://apache.org/xml/features/scanner/reuse-buffers";
    protected static final String[] RECOGNIZED_FEATURES = new String[]{"http://apache.org/xml/features/scanner/reuse-buffers"};
    protected static final Boolean[] FEATURE_DEFAULTS = new Boolean[]{null};
    protected XMLEvent[] fEventCache = new XMLEvent[10];
    protected XMLEvent fLastEvent;
    protected boolean fReuseBuffers = true;
    protected XMLDocumentSource fDocumentSource;
    protected NamespaceContext fNamespaceContext;
    private final QName fQName = new QName();

    public XMLEvent dequeue() {
        if (this.fLastEvent != null) {
            this.dropEvent(this.fLastEvent);
        }
        this.fLastEvent = super.dequeue();
        return this.fLastEvent;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XMLConfigurationException {
        this.clear();
        this.fLastEvent = null;
        try {
            this.fReuseBuffers = xMLComponentManager.getFeature(REUSE_BUFFERS);
        }
        catch (Exception exception) {
            this.fReuseBuffers = true;
        }
    }

    public String[] getRecognizedFeatures() {
        return RECOGNIZED_FEATURES;
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return null;
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
    }

    public Boolean getFeatureDefault(String string) {
        int n = 0;
        while (n < RECOGNIZED_FEATURES.length) {
            if (RECOGNIZED_FEATURES[n].equals(string)) {
                return FEATURE_DEFAULTS[n];
            }
            ++n;
        }
        return null;
    }

    public Object getPropertyDefault(String string) {
        return null;
    }

    public void startDocument(XMLLocator xMLLocator, String string, NamespaceContext namespaceContext, Augmentations augmentations) throws XNIException {
        this.fNamespaceContext = namespaceContext;
        DocumentEvent documentEvent = (DocumentEvent)this.getEvent((short)0);
        documentEvent.start = true;
        documentEvent.locator = xMLLocator;
        documentEvent.encoding = string;
        documentEvent.augs = this.augs(augmentations);
        this.enqueue(documentEvent);
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        this.startDocument(xMLLocator, string, null, augmentations);
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        TextDeclEvent textDeclEvent = (TextDeclEvent)this.getEvent((short)8);
        textDeclEvent.xmldecl = true;
        textDeclEvent.version = string;
        textDeclEvent.encoding = string2;
        textDeclEvent.standalone = string3;
        textDeclEvent.augs = this.augs(augmentations);
        this.enqueue(textDeclEvent);
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        DoctypeDeclEvent doctypeDeclEvent = new DoctypeDeclEvent();
        doctypeDeclEvent.root = string;
        doctypeDeclEvent.pubid = string2;
        doctypeDeclEvent.sysid = string3;
        doctypeDeclEvent.augs = this.augs(augmentations);
        this.enqueue(doctypeDeclEvent);
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        CommentEvent commentEvent = (CommentEvent)this.getEvent((short)5);
        commentEvent.text = this.string(xMLString, false);
        commentEvent.augs = this.augs(augmentations);
        this.enqueue(commentEvent);
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        ProcessingInstructionEvent processingInstructionEvent = (ProcessingInstructionEvent)this.getEvent((short)6);
        processingInstructionEvent.target = string;
        processingInstructionEvent.data = this.string(xMLString, false);
        processingInstructionEvent.augs = this.augs(augmentations);
        this.enqueue(processingInstructionEvent);
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        PrefixMappingEvent prefixMappingEvent = (PrefixMappingEvent)this.getEvent((short)3);
        prefixMappingEvent.start = true;
        prefixMappingEvent.prefix = string;
        prefixMappingEvent.uri = string2;
        prefixMappingEvent.augs = this.augs(augmentations);
        this.enqueue(prefixMappingEvent);
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes, augmentations, false);
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        this.handleStartElement(qName, xMLAttributes, augmentations, true);
        this.handleEndElement(qName, augmentations, true);
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        GeneralEntityEvent generalEntityEvent = (GeneralEntityEvent)this.getEvent((short)4);
        generalEntityEvent.start = true;
        generalEntityEvent.name = string;
        try {
            Method method = generalEntityEvent.getClass().getMethod("getNamespace", null);
            generalEntityEvent.namespace = (String)method.invoke((Object)xMLResourceIdentifier, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (xMLResourceIdentifier != null) {
            generalEntityEvent.publicId = xMLResourceIdentifier.getPublicId();
            generalEntityEvent.baseSystemId = xMLResourceIdentifier.getBaseSystemId();
            generalEntityEvent.literalSystemId = xMLResourceIdentifier.getLiteralSystemId();
            generalEntityEvent.expandedSystemId = xMLResourceIdentifier.getExpandedSystemId();
        }
        generalEntityEvent.encoding = string2;
        generalEntityEvent.augs = this.augs(augmentations);
        this.enqueue(generalEntityEvent);
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        TextDeclEvent textDeclEvent = (TextDeclEvent)this.getEvent((short)8);
        textDeclEvent.xmldecl = false;
        textDeclEvent.version = string;
        textDeclEvent.encoding = string2;
        textDeclEvent.augs = this.augs(augmentations);
        this.enqueue(textDeclEvent);
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        GeneralEntityEvent generalEntityEvent = (GeneralEntityEvent)this.getEvent((short)4);
        generalEntityEvent.start = false;
        generalEntityEvent.name = string;
        generalEntityEvent.publicId = null;
        generalEntityEvent.baseSystemId = null;
        generalEntityEvent.literalSystemId = null;
        generalEntityEvent.expandedSystemId = null;
        generalEntityEvent.encoding = null;
        generalEntityEvent.augs = this.augs(augmentations);
        this.enqueue(generalEntityEvent);
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        CharactersEvent charactersEvent = (CharactersEvent)this.getEvent((short)2);
        charactersEvent.ignorable = false;
        charactersEvent.text = this.string(xMLString, true);
        charactersEvent.augs = this.augs(augmentations);
        this.enqueue(charactersEvent);
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        CharactersEvent charactersEvent = (CharactersEvent)this.getEvent((short)2);
        charactersEvent.ignorable = true;
        charactersEvent.text = this.string(xMLString, true);
        charactersEvent.augs = this.augs(augmentations);
        this.enqueue(charactersEvent);
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        this.handleEndElement(qName, augmentations, false);
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        PrefixMappingEvent prefixMappingEvent = (PrefixMappingEvent)this.getEvent((short)3);
        prefixMappingEvent.start = false;
        prefixMappingEvent.prefix = string;
        prefixMappingEvent.uri = null;
        prefixMappingEvent.augs = this.augs(augmentations);
        this.enqueue(prefixMappingEvent);
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        CDATAEvent cDATAEvent = (CDATAEvent)this.getEvent((short)7);
        cDATAEvent.start = true;
        cDATAEvent.augs = this.augs(augmentations);
        this.enqueue(cDATAEvent);
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        CDATAEvent cDATAEvent = (CDATAEvent)this.getEvent((short)7);
        cDATAEvent.start = false;
        cDATAEvent.augs = this.augs(augmentations);
        this.enqueue(cDATAEvent);
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        DocumentEvent documentEvent = (DocumentEvent)this.getEvent((short)0);
        documentEvent.start = false;
        documentEvent.locator = null;
        documentEvent.encoding = null;
        documentEvent.augs = this.augs(augmentations);
        this.enqueue(documentEvent);
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, boolean bl) {
        if (this.fNamespaceContext != null) {
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            int n2 = 0;
            while (n2 < n) {
                String string = this.fNamespaceContext.getDeclaredPrefixAt(n2);
                String string2 = this.fNamespaceContext.getURI(string);
                this.startPrefixMapping(string, string2, null);
                ++n2;
            }
        }
        ElementEvent elementEvent = (ElementEvent)this.getEvent((short)1);
        elementEvent.start = true;
        if (elementEvent.element == null) {
            elementEvent.element = new QName();
        }
        elementEvent.element.setValues(qName);
        if (elementEvent.attributes == null) {
            elementEvent.attributes = new XMLAttributesImpl();
        }
        this.attrs(xMLAttributes, elementEvent.attributes);
        elementEvent.empty = bl;
        elementEvent.augs = this.augs(augmentations);
        this.enqueue(elementEvent);
    }

    protected void handleEndElement(QName qName, Augmentations augmentations, boolean bl) {
        ElementEvent elementEvent = (ElementEvent)this.getEvent((short)1);
        elementEvent.start = false;
        if (elementEvent.element == null) {
            elementEvent.element = new QName();
        }
        elementEvent.element.setValues(qName);
        elementEvent.attributes = null;
        elementEvent.empty = bl;
        elementEvent.augs = this.augs(augmentations);
        this.enqueue(elementEvent);
        if (this.fNamespaceContext != null) {
            int n = this.fNamespaceContext.getDeclaredPrefixCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                String string = this.fNamespaceContext.getDeclaredPrefixAt(n2);
                this.endPrefixMapping(string, null);
                --n2;
            }
        }
    }

    protected Augmentations augs(Augmentations augmentations) {
        AugmentationsImpl augmentationsImpl = null;
        if (augmentations != null) {
            augmentationsImpl = new AugmentationsImpl();
            Enumeration enumeration = augmentations.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                augmentationsImpl.putItem(string, augmentations.getItem(string));
            }
        }
        return augmentationsImpl;
    }

    protected void attrs(XMLAttributes xMLAttributes, XMLAttributes xMLAttributes2) {
        int n = xMLAttributes != null ? xMLAttributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            xMLAttributes.getName(n2, this.fQName);
            String string = xMLAttributes.getType(n2);
            String string2 = xMLAttributes.getValue(n2);
            String string3 = xMLAttributes.getNonNormalizedValue(n2);
            boolean bl = xMLAttributes.isSpecified(n2);
            xMLAttributes2.addAttribute(this.fQName, string, string2);
            xMLAttributes2.setNonNormalizedValue(n2, string3);
            xMLAttributes2.setSpecified(n2, bl);
            ++n2;
        }
    }

    protected XMLString string(XMLString xMLString, boolean bl) {
        return this.fReuseBuffers ? new XMLStringBuffer(xMLString) : xMLString;
    }

    protected XMLEvent getEvent(short s) {
        XMLEvent xMLEvent = this.fEventCache[s];
        if (xMLEvent != null) {
            this.fEventCache[s] = xMLEvent.next;
            xMLEvent.next = null;
            return xMLEvent;
        }
        switch (s) {
            case 1: {
                return new ElementEvent();
            }
            case 2: {
                return new CharactersEvent();
            }
            case 3: {
                return new PrefixMappingEvent();
            }
            case 4: {
                return new GeneralEntityEvent();
            }
            case 0: {
                return new DocumentEvent();
            }
            case 5: {
                return new CommentEvent();
            }
            case 6: {
                return new ProcessingInstructionEvent();
            }
            case 7: {
                return new CDATAEvent();
            }
            case 8: {
                return new TextDeclEvent();
            }
            case 9: {
                return new DoctypeDeclEvent();
            }
        }
        throw new RuntimeException("should not happen! getEvent(" + s + ')');
    }

    protected void dropEvent(XMLEvent xMLEvent) {
        xMLEvent.next = this.fEventCache[xMLEvent.type];
        this.fEventCache[xMLEvent.type] = xMLEvent;
        if (xMLEvent.type == 1) {
            ElementEvent elementEvent = (ElementEvent)xMLEvent;
            if (elementEvent.attributes != null) {
                elementEvent.attributes.removeAllAttributes();
            }
        }
    }
}

