/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FileUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.cyclonedx.BomGeneratorFactory;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.exception.GeneratorException;
import org.cyclonedx.generators.xml.BomXmlGenerator;
import org.cyclonedx.maven.ModelConverter;
import org.cyclonedx.maven.ProjectDependenciesConverter;
import org.cyclonedx.model.Bom;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Property;
import org.cyclonedx.parsers.JsonParser;
import org.cyclonedx.parsers.Parser;
import org.cyclonedx.parsers.XmlParser;
import org.eclipse.aether.RepositorySystem;

public abstract class BaseCycloneDxMojo
extends AbstractMojo {
    @Parameter(property="session", readonly=true, required=true)
    private MavenSession session;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="projectType", defaultValue="library", required=false)
    private String projectType;
    @Parameter(property="schemaVersion", defaultValue="1.4", required=false)
    private String schemaVersion;
    @Parameter(property="outputFormat", defaultValue="all", required=false)
    private String outputFormat;
    @Parameter(property="outputName", defaultValue="bom", required=false)
    private String outputName;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}", required=false)
    private File outputDirectory;
    @Parameter(property="includeBomSerialNumber", defaultValue="true", required=false)
    private boolean includeBomSerialNumber;
    @Parameter(property="includeCompileScope", defaultValue="true", required=false)
    private boolean includeCompileScope;
    @Parameter(property="includeProvidedScope", defaultValue="true", required=false)
    private boolean includeProvidedScope;
    @Parameter(property="includeRuntimeScope", defaultValue="true", required=false)
    private boolean includeRuntimeScope;
    @Parameter(property="includeTestScope", defaultValue="false", required=false)
    private boolean includeTestScope;
    @Parameter(property="includeSystemScope", defaultValue="true", required=false)
    private boolean includeSystemScope;
    @Parameter(property="includeLicenseText", defaultValue="false", required=false)
    private boolean includeLicenseText;
    @Parameter(property="excludeTypes", required=false)
    private String[] excludeTypes;
    @Parameter(property="detectUnusedForOptionalScope", defaultValue="false")
    protected boolean detectUnusedForOptionalScope;
    @org.apache.maven.plugins.annotations.Component(hint="default")
    private RepositorySystem aetherRepositorySystem;
    @Parameter(property="cyclonedx.skip", defaultValue="false", required=false)
    private boolean skip = false;
    @Parameter(property="cyclonedx.skipAttach", defaultValue="false", required=false)
    private boolean skipAttach = false;
    @Parameter(property="cyclonedx.verbose", defaultValue="false", required=false)
    private boolean verbose = false;
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    private String outputTimestamp;
    @org.apache.maven.plugins.annotations.Component
    private MavenProjectHelper mavenProjectHelper;
    @org.apache.maven.plugins.annotations.Component
    private ModelConverter modelConverter;
    @org.apache.maven.plugins.annotations.Component
    private ProjectDependenciesConverter projectDependenciesConverter;
    protected static final String MESSAGE_RESOLVING_DEPS = "CycloneDX: Resolving Dependencies";
    protected static final String MESSAGE_RESOLVING_AGGREGATED_DEPS = "CycloneDX: Resolving Aggregated Dependencies";
    protected static final String MESSAGE_CREATING_BOM = "CycloneDX: Creating BOM version %s with %d component(s)";
    static final String MESSAGE_CALCULATING_HASHES = "CycloneDX: Calculating Hashes";
    protected static final String MESSAGE_WRITING_BOM = "CycloneDX: Writing and validating BOM (%s): %s";
    protected static final String MESSAGE_ATTACHING_BOM = "           attaching as %s-%s-cyclonedx.%s";
    protected static final String MESSAGE_VALIDATION_FAILURE = "The BOM does not conform to the CycloneDX BOM standard as defined by the XSD";

    protected MavenProject getProject() {
        return this.project;
    }

    protected String generatePackageUrl(Artifact artifact) {
        return this.modelConverter.generatePackageUrl(artifact);
    }

    protected Component convert(Artifact artifact) {
        return this.modelConverter.convert(artifact, this.schemaVersion(), this.includeLicenseText);
    }

    protected abstract String extractComponentsAndDependencies(Set<String> var1, Map<String, Component> var2, Map<String, Dependency> var3) throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        boolean shouldSkip = Boolean.parseBoolean(System.getProperty("cyclonedx.skip", Boolean.toString(this.skip)));
        if (shouldSkip) {
            this.getLog().info((CharSequence)"Skipping CycloneDX");
            return;
        }
        this.logParameters();
        LinkedHashSet<String> topLevelComponents = new LinkedHashSet<String>();
        LinkedHashMap<String, Component> componentMap = new LinkedHashMap<String, Component>();
        LinkedHashMap<String, Dependency> dependencyMap = new LinkedHashMap<String, Dependency>();
        String analysis = this.extractComponentsAndDependencies(topLevelComponents, componentMap, dependencyMap);
        if (analysis != null) {
            Metadata metadata = this.modelConverter.convert(this.project, this.projectType, this.schemaVersion(), this.includeLicenseText);
            if (this.schemaVersion().getVersion() >= 1.3) {
                metadata.addProperty(this.newProperty("maven.goal", analysis));
                ArrayList<String> scopes = new ArrayList<String>();
                if (this.includeCompileScope) {
                    scopes.add("compile");
                }
                if (this.includeProvidedScope) {
                    scopes.add("provided");
                }
                if (this.includeRuntimeScope) {
                    scopes.add("runtime");
                }
                if (this.includeSystemScope) {
                    scopes.add("system");
                }
                if (this.includeTestScope) {
                    scopes.add("test");
                }
                metadata.addProperty(this.newProperty("maven.scopes", String.join((CharSequence)",", scopes)));
                if (this.detectUnusedForOptionalScope) {
                    metadata.addProperty(this.newProperty("maven.optional.unused", Boolean.toString(this.detectUnusedForOptionalScope)));
                }
            }
            Component rootComponent = metadata.getComponent();
            componentMap.remove(rootComponent.getPurl());
            this.projectDependenciesConverter.cleanupBomDependencies(metadata, componentMap, dependencyMap);
            this.generateBom(analysis, metadata, new ArrayList<Component>(componentMap.values()), new ArrayList<Dependency>(dependencyMap.values()));
        }
    }

    private Property newProperty(String name, String value) {
        Property property = new Property();
        property.setName(name);
        property.setValue(value);
        return property;
    }

    private void generateBom(String analysis, Metadata metadata, List<Component> components, List<Dependency> dependencies) throws MojoExecutionException {
        try {
            this.getLog().info((CharSequence)String.format(MESSAGE_CREATING_BOM, this.schemaVersion, components.size()));
            Bom bom = new Bom();
            bom.setComponents(components);
            if (this.outputTimestamp != null) {
                this.includeBomSerialNumber = false;
                metadata.setTimestamp(null);
                if (this.schemaVersion().getVersion() >= 1.3) {
                    metadata.addProperty(this.newProperty("maven.reproducible", "enabled"));
                }
            }
            if (this.schemaVersion().getVersion() >= 1.1 && this.includeBomSerialNumber) {
                bom.setSerialNumber("urn:uuid:" + UUID.randomUUID());
            }
            if (this.schemaVersion().getVersion() >= 1.2) {
                bom.setMetadata(metadata);
                bom.setDependencies(dependencies);
            }
            if ("all".equalsIgnoreCase(this.outputFormat) || "xml".equalsIgnoreCase(this.outputFormat) || "json".equalsIgnoreCase(this.outputFormat)) {
                this.saveBom(bom);
            } else {
                this.getLog().error((CharSequence)"Unsupported output format. Valid options are XML and JSON");
            }
        }
        catch (IOException | ParserConfigurationException | GeneratorException e) {
            throw new MojoExecutionException("An error occurred executing " + ((Object)((Object)this)).getClass().getName() + ": " + e.getMessage(), (Exception)e);
        }
    }

    private void saveBom(Bom bom) throws ParserConfigurationException, IOException, GeneratorException, MojoExecutionException {
        String bomString;
        BomXmlGenerator bomGenerator;
        if ("all".equalsIgnoreCase(this.outputFormat) || "xml".equalsIgnoreCase(this.outputFormat)) {
            bomGenerator = BomGeneratorFactory.createXml((CycloneDxSchema.Version)this.schemaVersion(), (Bom)bom);
            bomGenerator.generate();
            bomString = bomGenerator.toXmlString();
            this.saveBomToFile(bomString, "xml", (Parser)new XmlParser());
        }
        if ("all".equalsIgnoreCase(this.outputFormat) || "json".equalsIgnoreCase(this.outputFormat)) {
            bomGenerator = BomGeneratorFactory.createJson((CycloneDxSchema.Version)this.schemaVersion(), (Bom)bom);
            bomString = bomGenerator.toJsonString();
            this.saveBomToFile(bomString, "json", (Parser)new JsonParser());
        }
    }

    private void saveBomToFile(String bomString, String extension, Parser bomParser) throws IOException, MojoExecutionException {
        File bomFile = new File(this.outputDirectory, this.outputName + "." + extension);
        this.getLog().info((CharSequence)String.format(MESSAGE_WRITING_BOM, extension.toUpperCase(), bomFile.getAbsolutePath()));
        FileUtils.write((File)bomFile, (CharSequence)bomString, (Charset)StandardCharsets.UTF_8, (boolean)false);
        if (!bomParser.isValid(bomFile, this.schemaVersion())) {
            throw new MojoExecutionException(MESSAGE_VALIDATION_FAILURE);
        }
        if (!this.skipAttach) {
            this.getLog().info((CharSequence)String.format(MESSAGE_ATTACHING_BOM, this.project.getArtifactId(), this.project.getVersion(), extension));
            this.mavenProjectHelper.attachArtifact(this.project, extension, "cyclonedx", bomFile);
        }
    }

    protected ProjectDependenciesConverter.BomDependencies extractBOMDependencies(MavenProject mavenProject) throws MojoExecutionException {
        ProjectDependenciesConverter.MavenDependencyScopes include = new ProjectDependenciesConverter.MavenDependencyScopes(this.includeCompileScope, this.includeProvidedScope, this.includeRuntimeScope, this.includeTestScope, this.includeSystemScope);
        return this.projectDependenciesConverter.extractBOMDependencies(mavenProject, include, this.excludeTypes);
    }

    protected CycloneDxSchema.Version schemaVersion() {
        if ("1.0".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_10;
        }
        if ("1.1".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_11;
        }
        if ("1.2".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_12;
        }
        if ("1.3".equals(this.schemaVersion)) {
            return CycloneDxSchema.Version.VERSION_13;
        }
        return CycloneDxSchema.Version.VERSION_14;
    }

    protected void logAdditionalParameters() {
    }

    protected void logParameters() {
        if (this.verbose && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)"CycloneDX: Parameters");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
            this.getLog().info((CharSequence)("schemaVersion          : " + this.schemaVersion().getVersionString()));
            this.getLog().info((CharSequence)("includeBomSerialNumber : " + this.includeBomSerialNumber));
            this.getLog().info((CharSequence)("includeCompileScope    : " + this.includeCompileScope));
            this.getLog().info((CharSequence)("includeProvidedScope   : " + this.includeProvidedScope));
            this.getLog().info((CharSequence)("includeRuntimeScope    : " + this.includeRuntimeScope));
            this.getLog().info((CharSequence)("includeTestScope       : " + this.includeTestScope));
            this.getLog().info((CharSequence)("includeSystemScope     : " + this.includeSystemScope));
            this.getLog().info((CharSequence)("includeLicenseText     : " + this.includeLicenseText));
            this.getLog().info((CharSequence)("outputFormat           : " + this.outputFormat));
            this.getLog().info((CharSequence)("outputName             : " + this.outputName));
            this.logAdditionalParameters();
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    protected void populateComponents(Set<String> topLevelComponents, Map<String, Component> components, Map<String, Artifact> artifacts, ProjectDependencyAnalysis dependencyAnalysis) {
        for (Map.Entry<String, Artifact> entry : artifacts.entrySet()) {
            String purl = entry.getKey();
            Artifact artifact = entry.getValue();
            Component.Scope artifactScope = this.getComponentScope(artifact, dependencyAnalysis);
            Component component = components.get(purl);
            if (component == null) {
                Component newComponent = this.convert(artifact);
                newComponent.setScope(artifactScope);
                components.put(purl, newComponent);
                continue;
            }
            if (topLevelComponents.contains(purl)) continue;
            component.setScope(this.mergeScopes(component.getScope(), artifactScope));
        }
    }

    private Component.Scope getComponentScope(Artifact artifact, ProjectDependencyAnalysis projectDependencyAnalysis) {
        if (this.detectUnusedForOptionalScope) {
            return this.inferComponentScope(artifact, projectDependencyAnalysis);
        }
        return artifact.isOptional() ? Component.Scope.OPTIONAL : Component.Scope.REQUIRED;
    }

    private Component.Scope inferComponentScope(Artifact artifact, ProjectDependencyAnalysis projectDependencyAnalysis) {
        if (projectDependencyAnalysis == null) {
            return null;
        }
        Set usedDeclaredArtifacts = projectDependencyAnalysis.getUsedDeclaredArtifacts();
        Set usedUndeclaredArtifacts = projectDependencyAnalysis.getUsedUndeclaredArtifacts();
        Set unusedDeclaredArtifacts = projectDependencyAnalysis.getUnusedDeclaredArtifacts();
        Set testArtifactsWithNonTestScope = projectDependencyAnalysis.getTestArtifactsWithNonTestScope();
        if (usedDeclaredArtifacts.contains(artifact) || usedUndeclaredArtifacts.contains(artifact)) {
            return Component.Scope.REQUIRED;
        }
        if (unusedDeclaredArtifacts.contains(artifact) || testArtifactsWithNonTestScope.contains(artifact)) {
            return Component.Scope.OPTIONAL;
        }
        return null;
    }

    private Component.Scope mergeScopes(Component.Scope existing, Component.Scope project) {
        if (Component.Scope.REQUIRED == existing || Component.Scope.REQUIRED == project) {
            return Component.Scope.REQUIRED;
        }
        if (null == existing) {
            return project;
        }
        return existing;
    }
}

