/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.boot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import jline.Completor;
import jline.ConsoleReader;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Parser;
import org.apache.commons.lang.StringUtils;
import org.cyclopsgroup.jcli.jccli.JakartaCommonsCliParser;
import org.cyclopsgroup.jmxterm.boot.CliMainOptions;
import org.cyclopsgroup.jmxterm.cc.CommandCenter;
import org.cyclopsgroup.jmxterm.cc.ConsoleCompletor;
import org.cyclopsgroup.jmxterm.io.CommandInput;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.FileCommandInput;
import org.cyclopsgroup.jmxterm.io.FileCommandOutput;
import org.cyclopsgroup.jmxterm.io.InputStreamCommandInput;
import org.cyclopsgroup.jmxterm.io.JlineCommandInput;
import org.cyclopsgroup.jmxterm.io.PrintStreamCommandOutput;
import org.cyclopsgroup.jmxterm.io.VerboseLevel;
import org.cyclopsgroup.jmxterm.utils.SyntaxUtils;

public class CliMain {
    private static final PrintWriter STDOUT_WRITER = new PrintWriter(System.out, true);
    private static final String COMMAND_PROMPT = "$> ";

    public static final void main(String[] args) throws Exception {
        System.exit(new CliMain().execute(args));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int execute(String[] args) throws Exception {
        CommandOutput output;
        CliMainOptions options = new CliMainOptions();
        JakartaCommonsCliParser parser = new JakartaCommonsCliParser((Parser)new GnuParser());
        parser.parse(args, (Object)options);
        if (options.isHelp()) {
            parser.printUsage(CliMainOptions.class, STDOUT_WRITER);
            return 0;
        }
        VerboseLevel verboseLevel = options.getVerboseLevel() != null ? VerboseLevel.valueOf(options.getVerboseLevel().toUpperCase()) : null;
        if (StringUtils.equals((String)options.getOutput(), (String)"stdout")) {
            output = new PrintStreamCommandOutput(System.out, System.err);
        } else {
            File outputFile = new File(options.getOutput());
            output = new FileCommandOutput(outputFile);
        }
        try {
            int n;
            CommandInput input;
            if (options.getInput().equals("stdin")) {
                if (options.isNonInteractive()) {
                    input = new InputStreamCommandInput(System.in);
                } else {
                    ConsoleReader consoleReader = new ConsoleReader(System.in, (Writer)new PrintWriter(System.err, true));
                    input = new JlineCommandInput(consoleReader, COMMAND_PROMPT);
                }
            } else {
                File inputFile = new File(options.getInput());
                if (!inputFile.isFile()) {
                    throw new FileNotFoundException("File " + inputFile + " is not a valid file");
                }
                input = new FileCommandInput(new File(options.getInput()));
            }
            try {
                String line;
                CommandCenter commandCenter = new CommandCenter(output, input);
                if (input instanceof JlineCommandInput) {
                    ((JlineCommandInput)input).getConsole().addCompletor((Completor)new ConsoleCompletor(commandCenter));
                }
                if (options.getUrl() != null) {
                    HashMap<String, Object> env;
                    if (options.getUser() != null) {
                        env = new HashMap<String, Object>(1);
                        String password = options.getPassword();
                        if (password == null) {
                            password = input.readMaskedString("Authentication password: ");
                        }
                        String[] credentials = new String[]{options.getUser(), password};
                        env.put("jmx.remote.credentials", credentials);
                    } else {
                        env = null;
                    }
                    commandCenter.connect(SyntaxUtils.getUrl(options.getUrl()), env);
                }
                if (verboseLevel != null) {
                    commandCenter.setVerboseLevel(verboseLevel);
                }
                if (verboseLevel != VerboseLevel.SILENT) {
                    output.printMessage("Welcome to JMX terminal. Type \"help\" for available commands.");
                }
                int exitCode = 0;
                int lineNumber = 0;
                while ((line = input.readLine()) != null) {
                    ++lineNumber;
                    if (!commandCenter.execute(line) && options.isExitOnFailure()) {
                        exitCode = -lineNumber;
                        break;
                    }
                    if (!commandCenter.isClosed()) continue;
                }
                commandCenter.close();
                n = exitCode;
            }
            catch (Throwable throwable) {
                input.close();
                throw throwable;
            }
            input.close();
            return n;
        }
        finally {
            output.close();
        }
    }
}

