/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.boot;

import java.io.File;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;

@Cli(name="jmxterm", description="Main executable of JMX terminal CLI tool", note="Without any option, this command opens an interactive command line based console. With a given input file, commands in file will be executed and process ends after file is processed")
public class CliMainOptions {
    public static final String STDERR = "stderr";
    public static final String STDIN = "stdin";
    public static final String STDOUT = "stdout";
    private boolean exitOnFailure;
    private boolean help;
    private String input = "stdin";
    private boolean nonInteractive;
    private String output = "stdout";
    private String password;
    private String url;
    private String user;
    private String verboseLevel;

    public final String getInput() {
        return this.input;
    }

    public final String getOutput() {
        return this.output;
    }

    public final String getPassword() {
        return this.password;
    }

    public final String getUrl() {
        return this.url;
    }

    public final String getUser() {
        return this.user;
    }

    public final String getVerboseLevel() {
        return this.verboseLevel;
    }

    public final boolean isExitOnFailure() {
        return this.exitOnFailure;
    }

    public final boolean isHelp() {
        return this.help;
    }

    public final boolean isNonInteractive() {
        return this.nonInteractive;
    }

    @Option(name="e", longName="exitonfailure", description="With this flag, terminal exits for any Exception")
    public final void setExitOnFailure(boolean exitOnFailure) {
        this.exitOnFailure = exitOnFailure;
    }

    @Option(name="h", longName="help", description="Show usage of this command line")
    public final void setHelp(boolean help) {
        this.help = help;
    }

    @Option(name="i", longName="input", description="Input script file. There can only be one input file. \"stdin\" is the default value which means console input")
    public final void setInput(String file) {
        Validate.notNull((Object)file, (String)"Input file can't be NULL");
        Validate.isTrue((boolean)new File(file).isFile(), (String)("File " + file + " doesn't exist"));
        this.input = file;
    }

    @Option(name="n", longName="noninteract", description="Non interactive mode. Use this mode if input doesn't come from human or jmxterm is embedded")
    public final void setNonInteractive(boolean nonInteractive) {
        this.nonInteractive = nonInteractive;
    }

    @Option(name="o", longName="output", description="Output file, stdout or stderr. Default value is stdout")
    public final void setOutput(String outputFile) {
        Validate.notNull((Object)outputFile, (String)"Output file can't be NULL");
        this.output = outputFile;
    }

    @Option(name="p", longName="password", description="Password for user/password authentication")
    public final void setPassword(String password) {
        Validate.notNull((Object)password, (String)"Password can't be NULL");
        this.password = password;
    }

    @Option(name="l", longName="url", description="Location of MBean service. It can be <host>:<port> or full service URL.")
    public final void setUrl(String url) {
        Validate.notNull((Object)url, (String)"URL can't be NULL");
        this.url = url;
    }

    @Option(name="u", longName="user", description="User name for user/password authentication")
    public final void setUser(String user) {
        Validate.notNull((Object)user, (String)"User can't be NULL");
        this.user = user;
    }

    @Option(name="v", longName="verbose", description="Verbose level, could be silent|brief|verbose. Default value is brief")
    public final void setVerboseLevel(String verboseLevel) {
        this.verboseLevel = verboseLevel;
    }
}

