/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.JMException;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Parser;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.EscapedStringTokenizer;
import org.cyclopsgroup.jcli.StringTokenizer;
import org.cyclopsgroup.jcli.annotation.CliParser;
import org.cyclopsgroup.jcli.jccli.JakartaCommonsCliParser;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.CommandFactory;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cc.ConnectionAwareSession;
import org.cyclopsgroup.jmxterm.cc.HelpCommand;
import org.cyclopsgroup.jmxterm.cc.PredefinedCommandFactory;
import org.cyclopsgroup.jmxterm.io.CommandInput;
import org.cyclopsgroup.jmxterm.io.CommandOutput;
import org.cyclopsgroup.jmxterm.io.RuntimeIOException;
import org.cyclopsgroup.jmxterm.io.VerboseLevel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCenter {
    private static final String COMMAND_DELIMITER = "&&";
    final StringTokenizer argTokenizer = new EscapedStringTokenizer();
    private final CliParser cliParser = new JakartaCommonsCliParser((Parser)new GnuParser());
    final CommandFactory commandFactory;
    private final Lock lock = new ReentrantLock();
    final Session session;

    public CommandCenter(CommandOutput output, CommandInput input) throws IOException, ClassNotFoundException {
        this(output, input, new PredefinedCommandFactory());
    }

    public CommandCenter(CommandOutput output, CommandInput input, CommandFactory commandFactory) throws IOException {
        Validate.notNull((Object)output, (String)"Output can't be NULL");
        Validate.notNull((Object)commandFactory, (String)"Command factory can't be NULL");
        this.session = new ConnectionAwareSession(output, input);
        this.commandFactory = commandFactory;
    }

    public void close() {
        this.session.close();
    }

    public void connect(JMXServiceURL url, Map<String, Object> env) throws IOException {
        Validate.notNull((Object)url, (String)"URL can't be NULL");
        this.session.connect(url, env);
    }

    private void doExecute(String command) throws JMException {
        if ((command = StringUtils.trimToNull((String)command)) == null) {
            return;
        }
        if (command.startsWith("#")) {
            return;
        }
        int commandEnds = command.indexOf(35);
        if (commandEnds != -1) {
            command = command.substring(0, commandEnds);
        }
        if (command.indexOf(COMMAND_DELIMITER) != -1) {
            String[] commands;
            for (String c : commands = StringUtils.split((String)command, (String)COMMAND_DELIMITER)) {
                this.execute(c);
            }
            return;
        }
        String[] args = this.argTokenizer.parse(command).toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        String commandName = args[0];
        String[] commandArgs = new String[args.length - 1];
        System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
        try {
            this.doExecute(commandName, commandArgs, command);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Runtime IO exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExecute(String commandName, String[] commandArgs, String originalCommand) throws JMException, IOException {
        Command cmd = this.commandFactory.createCommand(commandName);
        if (cmd instanceof HelpCommand) {
            ((HelpCommand)cmd).setCommandCenter(this);
        }
        try {
            this.cliParser.parse(commandArgs, (Object)cmd);
            if (cmd.isHelp()) {
                this.printUsage(cmd.getClass());
                return;
            }
        }
        catch (IntrospectionException e) {
            throw new RuntimeException("Couldn't parse or print usage", e);
        }
        cmd.setSession(this.session);
        this.lock.lock();
        try {
            cmd.execute();
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean execute(String command) {
        try {
            this.doExecute(command);
            return true;
        }
        catch (JMException e) {
            this.session.output.printError(e);
            return false;
        }
        catch (RuntimeException e) {
            this.session.output.printError(e);
            return false;
        }
    }

    public Set<String> getCommandNames() {
        return this.commandFactory.getCommandTypes().keySet();
    }

    public Class<? extends Command> getCommandType(String name) {
        return this.commandFactory.getCommandTypes().get(name);
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    void printUsage(Class<? extends Command> commandType) throws IntrospectionException {
        this.cliParser.printUsage(commandType, new PrintWriter(System.out, true));
    }

    public void setVerboseLevel(VerboseLevel verboseLevel) {
        this.session.setVerboseLevel(verboseLevel);
    }
}

