/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.beans.IntrospectionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jline.Completor;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.cyclopsgroup.jcli.jline.CliCompletor;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.cc.CommandCenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleCompletor
implements Completor {
    private static final Log LOG = LogFactory.getLog(ConsoleCompletor.class);
    private final CommandCenter commandCenter;
    private final List<String> commandNames;

    public ConsoleCompletor(CommandCenter commandCenter) {
        Validate.notNull((Object)commandCenter, (String)"Command center can't be NULL");
        this.commandCenter = commandCenter;
        ArrayList<String> commandNames = new ArrayList<String>(commandCenter.getCommandNames());
        Collections.sort(commandNames);
        this.commandNames = Collections.unmodifiableList(commandNames);
    }

    public int complete(String buffer, int position, List candidates) {
        try {
            if (StringUtils.isEmpty((String)buffer) || buffer.indexOf(32) == -1) {
                return this.completeCommandName(buffer, candidates);
            }
            int separatorPos = buffer.indexOf(32);
            String commandName = buffer.substring(0, separatorPos);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Command name is [" + commandName + "]"));
            }
            String commandArguments = buffer.substring(separatorPos + 1);
            commandArguments.replaceFirst("^\\s*", "");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Analyzing commmand arguments [" + commandArguments + "]"));
            }
            Command cmd = this.commandCenter.commandFactory.createCommand(commandName);
            cmd.setSession(this.commandCenter.session);
            CliCompletor commandCompletor = new CliCompletor((Object)cmd, this.commandCenter.argTokenizer);
            return commandCompletor.complete(commandArguments, position - separatorPos, candidates) + separatorPos + 1;
        }
        catch (IntrospectionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't complete input", (Throwable)e);
            }
            return position;
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't complete input", (Throwable)e);
            }
            return position;
        }
        catch (RuntimeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Couldn't complete input", (Throwable)e);
            }
            return position;
        }
    }

    private int completeCommandName(String buf, List<String> candidates) throws IOException {
        if (buf == null) {
            candidates.addAll(this.commandNames);
        } else if (buf.indexOf(32) == -1) {
            ArrayList<String> matchedNames = new ArrayList<String>();
            for (String commandName : this.commandNames) {
                if (!commandName.startsWith(buf)) continue;
                matchedNames.add(commandName);
            }
            candidates.addAll(matchedNames);
        } else {
            throw new IllegalStateException("Invalid state");
        }
        return 0;
    }
}

