/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cc;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jcli.annotation.Argument;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.spi.CliUtils;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.cc.CommandCenter;

@Cli(name="help", description="Display available commands or usage of a command", note="Run \"help [command1] [command2] ...\" to display usage or certain command(s). Help without argument shows list of available commands")
public class HelpCommand
extends Command {
    private String[] argNames = new String[0];
    private CommandCenter commandCenter = null;

    public void execute() {
        Validate.notNull((Object)this.commandCenter, (String)"Command center hasn't been set yet");
        if (this.argNames.length == 0) {
            ArrayList<String> commandNames = new ArrayList<String>(this.commandCenter.getCommandNames());
            Collections.sort(commandNames);
            this.getSession().output.printMessage("following commands are available to use:");
            for (String commandName : commandNames) {
                Class<? extends Command> commandType = this.commandCenter.getCommandType(commandName);
                try {
                    Cli cli = CliUtils.defineCli(commandType).getCli();
                    this.getSession().output.println(String.format("%-8s - %s", commandName, cli.description()));
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException("Command type " + commandType + " has some problem", e);
                }
            }
        } else {
            for (String argName : this.argNames) {
                Class<? extends Command> commandType = this.commandCenter.getCommandType(argName);
                if (commandType == null) {
                    throw new IllegalArgumentException("Command " + argName + " is not found");
                }
                try {
                    this.commandCenter.printUsage(commandType);
                }
                catch (IntrospectionException e) {
                    throw new RuntimeException("Command type " + commandType + " has some problem", e);
                }
            }
        }
    }

    @Argument
    public final void setArgNames(String[] argNames) {
        Validate.notNull((Object)argNames, (String)"argNames can't be NULL");
        this.argNames = argNames;
    }

    final void setCommandCenter(CommandCenter commandCenter) {
        Validate.notNull((Object)commandCenter, (String)"commandCenter can't be NULL");
        this.commandCenter = commandCenter;
    }
}

