/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.cmd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.cyclopsgroup.jcli.AutoCompletable;
import org.cyclopsgroup.jcli.annotation.Cli;
import org.cyclopsgroup.jcli.annotation.Option;
import org.cyclopsgroup.jmxterm.Command;
import org.cyclopsgroup.jmxterm.Session;
import org.cyclopsgroup.jmxterm.cmd.DomainCommand;
import org.cyclopsgroup.jmxterm.cmd.DomainsCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cli(name="beans", description="List available beans under a domain or all domains", note="Without -d option, current select domain is applied. If there's no domain specified, all beans are listed. Example:\n beans\n beans -d java.lang")
public class BeansCommand
extends Command
implements AutoCompletable {
    private String domain;

    public static List<String> getBeans(Session session, String domainName) throws MalformedObjectNameException, IOException {
        ObjectName queryName = null;
        if (domainName != null) {
            queryName = new ObjectName(domainName + ":*");
        }
        Set<ObjectName> names = session.getConnection().getServerConnection().queryNames(queryName, null);
        ArrayList<String> results = new ArrayList<String>(names.size());
        for (ObjectName name : names) {
            results.add(name.getCanonicalName());
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public List<String> doSuggestOption(String optionName) throws IOException {
        if (optionName.equals("d")) {
            return DomainsCommand.getCandidateDomains(this.getSession());
        }
        return null;
    }

    @Override
    public void execute() throws MalformedObjectNameException, IOException {
        Session session = this.getSession();
        String domainName = DomainCommand.getDomainName(this.domain, session);
        ArrayList<String> domains = new ArrayList<String>();
        if (domainName == null) {
            domains.addAll(DomainsCommand.getCandidateDomains(session));
        } else {
            domains.add(domainName);
        }
        for (String d : domains) {
            session.output.printMessage("domain = " + d + ":");
            for (String bean : BeansCommand.getBeans(session, d)) {
                session.output.println(bean);
            }
        }
    }

    @Option(name="d", longName="domain", description="Name of domain under which beans are listed")
    public final void setDomain(String domain) {
        this.domain = domain;
    }
}

