/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.io;

import java.io.PrintStream;
import org.apache.commons.lang.Validate;
import org.cyclopsgroup.jmxterm.io.CommandOutput;

public class PrintStreamCommandOutput
extends CommandOutput {
    private final PrintStream messageOutput;
    private final PrintStream resultOutput;

    public PrintStreamCommandOutput() {
        this(System.out);
    }

    public PrintStreamCommandOutput(PrintStream output) {
        this(output, System.err);
    }

    public PrintStreamCommandOutput(PrintStream resultOutput, PrintStream messageOutput) {
        Validate.notNull((Object)resultOutput, (String)"Result output can't be NULL");
        Validate.notNull((Object)messageOutput, (String)"Message output can't be NULL");
        this.resultOutput = resultOutput;
        this.messageOutput = messageOutput;
    }

    public void print(String output) {
        this.resultOutput.print(output);
    }

    public void printError(Throwable e) {
        e.printStackTrace(this.messageOutput);
    }

    public void printMessage(String message) {
        this.messageOutput.println(message);
    }
}

