/*
 * Decompiled with CFR 0.152.
 */
package org.cyclopsgroup.jmxterm.jdk6;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cyclopsgroup.jmxterm.JavaProcess;
import org.cyclopsgroup.jmxterm.JavaProcessManager;
import org.cyclopsgroup.jmxterm.jdk6.Jdk6JavaProcess;
import org.cyclopsgroup.jmxterm.jdk6.LocalVirtualMachine;
import org.cyclopsgroup.jmxterm.jdk6.StaticLocalVirtualMachine;
import org.cyclopsgroup.jmxterm.utils.WeakCastUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Jdk6JavaProcessManager
extends JavaProcessManager {
    private final StaticLocalVirtualMachine staticVm = WeakCastUtils.staticCast(Class.forName("sun.tools.jconsole.LocalVirtualMachine"), StaticLocalVirtualMachine.class);

    @Override
    public JavaProcess get(int pid) {
        Map<Integer, Object> lvms = this.staticVm.getAllVirtualMachines();
        Object vm = lvms.get(pid);
        if (vm == null) {
            return null;
        }
        try {
            return new Jdk6JavaProcess(WeakCastUtils.cast(vm, LocalVirtualMachine.class));
        }
        catch (SecurityException e) {
            throw new RuntimeException("Can't cast " + vm + " to LocalVirtualMachine", e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Can't cast " + vm + " to LocalVirtualMachine", e);
        }
    }

    @Override
    public List<JavaProcess> list() {
        Map<Integer, Object> lvms = this.staticVm.getAllVirtualMachines();
        ArrayList<JavaProcess> result = new ArrayList<JavaProcess>(lvms.size());
        for (Object lvm : lvms.values()) {
            try {
                LocalVirtualMachine vm = WeakCastUtils.cast(lvm, LocalVirtualMachine.class);
                result.add(new Jdk6JavaProcess(vm));
            }
            catch (SecurityException e) {
                throw new RuntimeException("Can't cast " + lvm + " to LocalVirtualMachine", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Can't cast " + lvm + " to LocalVirtualMachine", e);
            }
        }
        return result;
    }
}

