/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.misc;

import java.io.DataInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.datavec.api.conf.Configuration;
import org.datavec.api.records.reader.impl.LineRecordReader;
import org.datavec.api.split.InputSplit;
import org.datavec.api.writable.DoubleWritable;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVMLightRecordReader
extends LineRecordReader {
    private static Logger log = LoggerFactory.getLogger(SVMLightRecordReader.class);
    private int numAttributes = -1;
    public static final String NUM_ATTRIBUTES = SVMLightRecordReader.class.getName() + ".numattributes";

    @Override
    public List<Writable> next() {
        Text t = (Text)super.next().iterator().next();
        String val = new String(t.getBytes());
        ArrayList<Writable> ret = new ArrayList<Writable>();
        try {
            int i;
            int totalDiff;
            int index;
            String col;
            int max = 0;
            StringTokenizer tok = new StringTokenizer(val, " \t");
            tok.nextToken();
            while (tok.hasMoreTokens() && !(col = tok.nextToken()).startsWith("#")) {
                if (col.startsWith("qid:") || (index = Integer.parseInt(col.substring(0, col.indexOf(":")))) <= max) continue;
                max = index;
            }
            tok = new StringTokenizer(val, " \t");
            double classVal = Double.parseDouble(tok.nextToken());
            int numAttributesAdded = 0;
            while (tok.hasMoreTokens() && !(col = tok.nextToken()).startsWith("#")) {
                if (col.startsWith("qid:")) continue;
                index = Integer.parseInt(col.substring(0, col.indexOf(":"))) - 1;
                if (index > numAttributesAdded) {
                    totalDiff = Math.abs(numAttributesAdded - index);
                    for (i = numAttributesAdded; i < index; ++i) {
                        ret.add(new DoubleWritable(0.0));
                    }
                    numAttributesAdded += totalDiff;
                }
                double value = Double.parseDouble(col.substring(col.indexOf(":") + 1));
                ret.add(new DoubleWritable(value));
                ++numAttributesAdded;
            }
            if (this.numAttributes >= 1 && ret.size() < this.numAttributes) {
                totalDiff = Math.abs(ret.size() - this.numAttributes);
                for (i = 0; i < totalDiff; ++i) {
                    ret.add(new DoubleWritable(0.0));
                }
            }
            ret.add(new DoubleWritable(classVal));
        }
        catch (Exception e) {
            log.error("Error parsing line '" + val + "': ", (Throwable)e);
        }
        return ret;
    }

    @Override
    public void initialize(Configuration conf, InputSplit split) throws IOException, InterruptedException {
        super.initialize(conf, split);
        if (conf.get(NUM_ATTRIBUTES) != null) {
            this.numAttributes = conf.getInt(NUM_ATTRIBUTES, -1);
        }
    }

    @Override
    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf.get(NUM_ATTRIBUTES) != null) {
            this.numAttributes = conf.getInt(NUM_ATTRIBUTES, -1);
        }
    }

    @Override
    public List<Writable> record(URI uri, DataInputStream dataInputStream) throws IOException {
        throw new UnsupportedOperationException("Reading SVMLightRecordReader data from DataInputStream not yet implemented");
    }
}

