/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.datasets.iterator.impl;

import org.deeplearning4j.nn.graph.util.ComputationGraphUtil;
import org.nd4j.linalg.dataset.api.DataSet;
import org.nd4j.linalg.dataset.api.MultiDataSet;
import org.nd4j.linalg.dataset.api.MultiDataSetPreProcessor;
import org.nd4j.linalg.dataset.api.iterator.DataSetIterator;
import org.nd4j.linalg.dataset.api.iterator.MultiDataSetIterator;

public class MultiDataSetIteratorAdapter
implements MultiDataSetIterator {
    private DataSetIterator iter;
    private MultiDataSetPreProcessor preProcessor;

    public MultiDataSetIteratorAdapter(DataSetIterator iter) {
        this.iter = iter;
    }

    public MultiDataSet next(int i) {
        MultiDataSet mds = ComputationGraphUtil.toMultiDataSet((DataSet)this.iter.next(i));
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(mds);
        }
        return mds;
    }

    public void setPreProcessor(MultiDataSetPreProcessor multiDataSetPreProcessor) {
        this.preProcessor = multiDataSetPreProcessor;
    }

    public boolean resetSupported() {
        return this.iter.resetSupported();
    }

    public boolean asyncSupported() {
        return this.iter.asyncSupported();
    }

    public void reset() {
        this.iter.reset();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public MultiDataSet next() {
        MultiDataSet mds = ComputationGraphUtil.toMultiDataSet((DataSet)this.iter.next());
        if (this.preProcessor != null) {
            this.preProcessor.preProcess(mds);
        }
        return mds;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

