/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.eval;

import java.io.Serializable;
import java.util.List;
import org.deeplearning4j.berkeley.Pair;
import org.deeplearning4j.eval.EvaluationUtils;
import org.deeplearning4j.eval.IEvaluation;
import org.nd4j.linalg.api.ndarray.INDArray;

public abstract class BaseEvaluation<T extends BaseEvaluation>
implements IEvaluation<T> {
    @Override
    public void evalTimeSeries(INDArray labels, INDArray predicted) {
        this.evalTimeSeries(labels, predicted, null);
    }

    @Override
    public void evalTimeSeries(INDArray labels, INDArray predictions, INDArray labelsMask) {
        Pair<INDArray, INDArray> pair = EvaluationUtils.extractNonMaskedTimeSteps(labels, predictions, labelsMask);
        INDArray labels2d = pair.getFirst();
        INDArray predicted2d = pair.getSecond();
        this.eval(labels2d, predicted2d);
    }

    @Override
    public void eval(INDArray labels, INDArray networkPredictions, List<? extends Serializable> recordMetaData) {
        this.eval(labels, networkPredictions);
    }
}

