/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.conf.layers;

import java.util.Collection;
import java.util.Map;
import org.deeplearning4j.nn.api.Layer;
import org.deeplearning4j.nn.api.ParamInitializer;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.layers.BaseOutputLayer;
import org.deeplearning4j.nn.params.CenterLossParamInitializer;
import org.deeplearning4j.optimize.api.IterationListener;
import org.deeplearning4j.util.LayerValidation;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.LossFunctions;

public class CenterLossOutputLayer
extends BaseOutputLayer {
    protected double alpha;
    protected double lambda;
    protected boolean gradientCheck;

    protected CenterLossOutputLayer(Builder builder) {
        super(builder);
        this.alpha = builder.alpha;
        this.lambda = builder.lambda;
        this.gradientCheck = builder.gradientCheck;
    }

    @Override
    public Layer instantiate(NeuralNetConfiguration conf, Collection<IterationListener> iterationListeners, int layerIndex, INDArray layerParamsView, boolean initializeParams) {
        LayerValidation.assertNInNOutSet("CenterLossOutputLayer", this.getLayerName(), layerIndex, this.getNIn(), this.getNOut());
        org.deeplearning4j.nn.layers.training.CenterLossOutputLayer ret = new org.deeplearning4j.nn.layers.training.CenterLossOutputLayer(conf);
        ret.setListeners(iterationListeners);
        ret.setIndex(layerIndex);
        ret.setParamsViewArray(layerParamsView);
        Map<String, INDArray> paramTable = this.initializer().init(conf, layerParamsView, initializeParams);
        ret.setParamTable(paramTable);
        ret.setConf(conf);
        return ret;
    }

    @Override
    public ParamInitializer initializer() {
        return CenterLossParamInitializer.getInstance();
    }

    @Override
    public Updater getUpdaterByParam(String paramName) {
        switch (paramName) {
            case "cL": {
                return Updater.NONE;
            }
        }
        return this.updater;
    }

    @Override
    public double getLearningRateByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.learningRate;
            }
            case "b": {
                if (!Double.isNaN(this.biasLearningRate)) {
                    return this.biasLearningRate;
                }
                return this.learningRate;
            }
            case "cL": {
                return 0.0;
            }
        }
        throw new IllegalStateException("Unknown parameter: \"" + paramName + "\"");
    }

    @Override
    public double getL1ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l1;
            }
            case "b": {
                return this.l1Bias;
            }
            case "cL": {
                return 0.0;
            }
        }
        throw new IllegalStateException("Unknown parameter: \"" + paramName + "\"");
    }

    @Override
    public double getL2ByParam(String paramName) {
        switch (paramName) {
            case "W": {
                return this.l2;
            }
            case "b": {
                return this.l2Bias;
            }
            case "cL": {
                return 0.0;
            }
        }
        throw new IllegalStateException("Unknown parameter: \"" + paramName + "\"");
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public boolean getGradientCheck() {
        return this.gradientCheck;
    }

    public void setAlpha(double alpha) {
        this.alpha = alpha;
    }

    public void setLambda(double lambda) {
        this.lambda = lambda;
    }

    public void setGradientCheck(boolean gradientCheck) {
        this.gradientCheck = gradientCheck;
    }

    public CenterLossOutputLayer() {
    }

    @Override
    public String toString() {
        return "CenterLossOutputLayer(super=" + super.toString() + ", alpha=" + this.getAlpha() + ", lambda=" + this.getLambda() + ", gradientCheck=" + this.getGradientCheck() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CenterLossOutputLayer)) {
            return false;
        }
        CenterLossOutputLayer other = (CenterLossOutputLayer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getAlpha(), other.getAlpha()) != 0) {
            return false;
        }
        if (Double.compare(this.getLambda(), other.getLambda()) != 0) {
            return false;
        }
        return this.getGradientCheck() == other.getGradientCheck();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CenterLossOutputLayer;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        long $alpha = Double.doubleToLongBits(this.getAlpha());
        result = result * 59 + (int)($alpha >>> 32 ^ $alpha);
        long $lambda = Double.doubleToLongBits(this.getLambda());
        result = result * 59 + (int)($lambda >>> 32 ^ $lambda);
        result = result * 59 + (this.getGradientCheck() ? 79 : 97);
        return result;
    }

    public static class Builder
    extends BaseOutputLayer.Builder<Builder> {
        protected double alpha = 0.05;
        protected double lambda = 2.0E-4;
        protected boolean gradientCheck = false;

        public Builder(LossFunctions.LossFunction lossFunction) {
            super.lossFunction(lossFunction);
        }

        public Builder(ILossFunction lossFunction) {
            this.lossFn = lossFunction;
        }

        public Builder alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Builder lambda(double lambda) {
            this.lambda = lambda;
            return this;
        }

        public Builder gradientCheck(boolean isGradientCheck) {
            this.gradientCheck = isGradientCheck;
            return this;
        }

        @Override
        public CenterLossOutputLayer build() {
            return new CenterLossOutputLayer(this);
        }

        public Builder() {
        }
    }
}

