/*
 * Decompiled with CFR 0.152.
 */
package org.deeplearning4j.nn.transferlearning;

import java.util.Map;
import org.deeplearning4j.nn.api.OptimizationAlgorithm;
import org.deeplearning4j.nn.conf.BackpropType;
import org.deeplearning4j.nn.conf.ComputationGraphConfiguration;
import org.deeplearning4j.nn.conf.ConvolutionMode;
import org.deeplearning4j.nn.conf.GradientNormalization;
import org.deeplearning4j.nn.conf.LearningRatePolicy;
import org.deeplearning4j.nn.conf.MultiLayerConfiguration;
import org.deeplearning4j.nn.conf.NeuralNetConfiguration;
import org.deeplearning4j.nn.conf.Updater;
import org.deeplearning4j.nn.conf.distribution.Distribution;
import org.deeplearning4j.nn.conf.layers.ConvolutionLayer;
import org.deeplearning4j.nn.conf.layers.Layer;
import org.deeplearning4j.nn.conf.layers.LayerValidation;
import org.deeplearning4j.nn.conf.layers.SubsamplingLayer;
import org.deeplearning4j.nn.conf.stepfunctions.StepFunction;
import org.deeplearning4j.nn.weights.WeightInit;
import org.nd4j.linalg.activations.Activation;
import org.nd4j.linalg.activations.IActivation;

public class FineTuneConfiguration {
    protected IActivation activationFn;
    protected WeightInit weightInit;
    protected Double biasInit;
    protected Distribution dist;
    protected Double learningRate;
    protected Double biasLearningRate;
    protected Map<Integer, Double> learningRateSchedule;
    protected Double lrScoreBasedDecay;
    protected Double l1;
    protected Double l2;
    protected Double l1Bias;
    protected Double l2Bias;
    protected Double dropOut;
    protected Updater updater;
    protected Double momentum;
    protected Map<Integer, Double> momentumSchedule;
    protected Double epsilon;
    protected Double rho;
    protected Double rmsDecay;
    protected Double adamMeanDecay;
    protected Double adamVarDecay;
    protected Boolean miniBatch;
    protected Integer numIterations;
    protected Integer maxNumLineSearchIterations;
    protected Long seed;
    protected Boolean useRegularization;
    protected OptimizationAlgorithm optimizationAlgo;
    protected StepFunction stepFunction;
    protected Boolean useDropConnect;
    protected Boolean minimize;
    protected GradientNormalization gradientNormalization;
    protected Double gradientNormalizationThreshold;
    protected LearningRatePolicy learningRatePolicy;
    protected Double lrPolicyDecayRate;
    protected Double lrPolicySteps;
    protected Double lrPolicyPower;
    protected ConvolutionMode convolutionMode;
    protected Boolean pretrain;
    protected Boolean backprop;
    protected BackpropType backpropType;
    protected Integer tbpttFwdLength;
    protected Integer tbpttBackLength;

    public NeuralNetConfiguration appliedNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        this.applyToNeuralNetConfiguration(nnc);
        nnc = new NeuralNetConfiguration.Builder(nnc.clone()).build();
        return nnc;
    }

    public void applyToNeuralNetConfiguration(NeuralNetConfiguration nnc) {
        Layer l = nnc.getLayer();
        Updater originalUpdater = null;
        WeightInit origWeightInit = null;
        if (l != null) {
            originalUpdater = l.getUpdater();
            origWeightInit = l.getWeightInit();
            if (this.activationFn != null) {
                l.setActivationFn(this.activationFn);
            }
            if (this.weightInit != null) {
                l.setWeightInit(this.weightInit);
            }
            if (this.biasInit != null) {
                l.setBiasInit(this.biasInit);
            }
            if (this.dist != null) {
                l.setDist(this.dist);
            }
            if (this.learningRate != null) {
                l.setLearningRate(this.learningRate);
                l.setBiasLearningRate(this.learningRate);
            }
            if (this.biasLearningRate != null) {
                l.setBiasLearningRate(this.biasLearningRate);
            }
            if (this.learningRateSchedule != null) {
                l.setLearningRateSchedule(this.learningRateSchedule);
            }
            if (this.l1 != null) {
                l.setL1(this.l1);
            }
            if (this.l2 != null) {
                l.setL2(this.l2);
            }
            if (this.l1Bias != null) {
                l.setL1Bias(this.l1Bias);
            }
            if (this.l2Bias != null) {
                l.setL2Bias(this.l2Bias);
            }
            if (this.dropOut != null) {
                l.setDropOut(this.dropOut);
            }
            if (this.updater != null) {
                l.setUpdater(this.updater);
            }
            if (this.momentum != null) {
                l.setMomentum(this.momentum);
            }
            if (this.momentumSchedule != null) {
                l.setMomentum(this.momentum);
            }
            if (this.epsilon != null) {
                l.setEpsilon(this.epsilon);
            }
            if (this.rho != null) {
                l.setRho(this.rho);
            }
            if (this.rmsDecay != null) {
                l.setRmsDecay(this.rmsDecay);
            }
            if (this.adamMeanDecay != null) {
                l.setAdamMeanDecay(this.adamMeanDecay);
            }
            if (this.adamVarDecay != null) {
                l.setAdamVarDecay(this.adamVarDecay);
            }
        }
        if (this.miniBatch != null) {
            nnc.setMiniBatch(this.miniBatch);
        }
        if (this.numIterations != null) {
            nnc.setNumIterations(this.numIterations);
        }
        if (this.maxNumLineSearchIterations != null) {
            nnc.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            nnc.setSeed(this.seed);
        }
        if (this.useRegularization != null) {
            nnc.setUseRegularization(this.useRegularization);
        }
        if (this.optimizationAlgo != null) {
            nnc.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            nnc.setStepFunction(this.stepFunction);
        }
        if (this.useDropConnect != null) {
            nnc.setUseDropConnect(this.useDropConnect);
        }
        if (this.minimize != null) {
            nnc.setMinimize(this.minimize);
        }
        if (this.gradientNormalization != null) {
            l.setGradientNormalization(this.gradientNormalization);
        }
        if (this.gradientNormalizationThreshold != null) {
            l.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
        }
        if (this.learningRatePolicy != null) {
            nnc.setLearningRatePolicy(this.learningRatePolicy);
        }
        if (this.lrPolicySteps != null) {
            nnc.setLrPolicySteps(this.lrPolicySteps);
        }
        if (this.lrPolicyPower != null) {
            nnc.setLrPolicyPower(this.lrPolicyPower);
        }
        if (this.convolutionMode != null && l instanceof ConvolutionLayer) {
            ((ConvolutionLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (this.convolutionMode != null && l instanceof SubsamplingLayer) {
            ((SubsamplingLayer)l).setConvolutionMode(this.convolutionMode);
        }
        if (l != null && this.updater != null && originalUpdater != null && this.updater != originalUpdater) {
            switch (originalUpdater) {
                case ADAM: {
                    if (this.adamMeanDecay == null) {
                        l.setAdamMeanDecay(Double.NaN);
                    }
                    if (this.adamVarDecay != null) break;
                    l.setAdamVarDecay(Double.NaN);
                    break;
                }
                case ADADELTA: {
                    if (this.rho == null) {
                        l.setRho(Double.NaN);
                    }
                    if (this.epsilon != null) break;
                    l.setEpsilon(Double.NaN);
                    break;
                }
                case NESTEROVS: {
                    if (this.momentum == null) {
                        l.setMomentum(Double.NaN);
                    }
                    if (this.momentumSchedule == null) {
                        l.setMomentumSchedule(null);
                    }
                    if (this.epsilon != null) break;
                    l.setEpsilon(Double.NaN);
                    break;
                }
                case ADAGRAD: {
                    if (this.epsilon != null) break;
                    l.setEpsilon(Double.NaN);
                    break;
                }
                case RMSPROP: {
                    if (this.rmsDecay == null) {
                        l.setRmsDecay(Double.NaN);
                    }
                    if (this.epsilon != null) break;
                    l.setEpsilon(Double.NaN);
                }
            }
        }
        if (l != null && origWeightInit == WeightInit.DISTRIBUTION && this.weightInit != null && this.weightInit != WeightInit.DISTRIBUTION) {
            l.setDist(null);
        }
        if (l != null) {
            LayerValidation.updaterValidation(l.getLayerName(), l, this.momentum, this.momentumSchedule, this.adamMeanDecay, this.adamVarDecay, this.rho, this.rmsDecay, this.epsilon);
            boolean useDropCon = this.useDropConnect == null ? nnc.isUseDropConnect() : this.useDropConnect.booleanValue();
            LayerValidation.generalValidation(l.getLayerName(), l, nnc.isUseRegularization(), useDropCon, this.dropOut, this.l2, this.l2Bias, this.l1, this.l1Bias, this.dist);
        }
        if (nnc.variables(false) != null) {
            for (String s : nnc.variables(false)) {
                nnc.setLayerParamLR(s);
            }
        }
    }

    public void applyToMultiLayerConfiguration(MultiLayerConfiguration conf) {
        if (this.pretrain != null) {
            conf.setPretrain(this.pretrain);
        }
        if (this.backprop != null) {
            conf.setBackprop(this.backprop);
        }
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public void applyToComputationGraphConfiguration(ComputationGraphConfiguration conf) {
        if (this.pretrain != null) {
            conf.setPretrain(this.pretrain);
        }
        if (this.backprop != null) {
            conf.setBackprop(this.backprop);
        }
        if (this.backpropType != null) {
            conf.setBackpropType(this.backpropType);
        }
        if (this.tbpttFwdLength != null) {
            conf.setTbpttFwdLength(this.tbpttFwdLength);
        }
        if (this.tbpttBackLength != null) {
            conf.setTbpttBackLength(this.tbpttBackLength);
        }
    }

    public NeuralNetConfiguration.Builder appliedNeuralNetConfigurationBuilder() {
        NeuralNetConfiguration.Builder confBuilder = new NeuralNetConfiguration.Builder();
        if (this.activationFn != null) {
            confBuilder.setActivationFn(this.activationFn);
        }
        if (this.weightInit != null) {
            confBuilder.setWeightInit(this.weightInit);
        }
        if (this.biasInit != null) {
            confBuilder.setBiasInit(this.biasInit);
        }
        if (this.dist != null) {
            confBuilder.setDist(this.dist);
        }
        if (this.learningRate != null) {
            confBuilder.setLearningRate(this.learningRate);
            confBuilder.setBiasLearningRate(this.learningRate);
        }
        if (this.biasLearningRate != null) {
            confBuilder.setBiasLearningRate(this.biasLearningRate);
        }
        if (this.learningRateSchedule != null) {
            confBuilder.setLearningRateSchedule(this.learningRateSchedule);
        }
        if (this.l1 != null) {
            confBuilder.setL1(this.l1);
        }
        if (this.l2 != null) {
            confBuilder.setL2(this.l2);
        }
        if (this.l1Bias != null) {
            confBuilder.setL1Bias(this.l1Bias);
        }
        if (this.l2Bias != null) {
            confBuilder.setL2Bias(this.l2Bias);
        }
        if (this.dropOut != null) {
            confBuilder.setDropOut(this.dropOut);
        }
        if (this.updater != null) {
            confBuilder.setUpdater(this.updater);
        }
        if (this.momentum != null) {
            confBuilder.setMomentum(this.momentum);
        }
        if (this.momentumSchedule != null) {
            confBuilder.setMomentum(this.momentum);
        }
        if (this.epsilon != null) {
            confBuilder.setEpsilon(this.epsilon);
        }
        if (this.rho != null) {
            confBuilder.setRho(this.rho);
        }
        if (this.rmsDecay != null) {
            confBuilder.setRmsDecay(this.rmsDecay);
        }
        if (this.adamMeanDecay != null) {
            confBuilder.setAdamMeanDecay(this.adamMeanDecay);
        }
        if (this.adamVarDecay != null) {
            confBuilder.setAdamVarDecay(this.adamVarDecay);
        }
        if (this.miniBatch != null) {
            confBuilder.setMiniBatch(this.miniBatch);
        }
        if (this.numIterations != null) {
            confBuilder.setNumIterations(this.numIterations);
        }
        if (this.maxNumLineSearchIterations != null) {
            confBuilder.setMaxNumLineSearchIterations(this.maxNumLineSearchIterations);
        }
        if (this.seed != null) {
            confBuilder.setSeed(this.seed);
        }
        if (this.useRegularization != null) {
            confBuilder.setUseRegularization(this.useRegularization);
        }
        if (this.optimizationAlgo != null) {
            confBuilder.setOptimizationAlgo(this.optimizationAlgo);
        }
        if (this.stepFunction != null) {
            confBuilder.setStepFunction(this.stepFunction);
        }
        if (this.useDropConnect != null) {
            confBuilder.setUseDropConnect(this.useDropConnect);
        }
        if (this.minimize != null) {
            confBuilder.setMinimize(this.minimize);
        }
        if (this.gradientNormalization != null) {
            confBuilder.setGradientNormalization(this.gradientNormalization);
        }
        if (this.gradientNormalizationThreshold != null) {
            confBuilder.setGradientNormalizationThreshold(this.gradientNormalizationThreshold);
        }
        if (this.learningRatePolicy != null) {
            confBuilder.setLearningRatePolicy(this.learningRatePolicy);
        }
        if (this.lrPolicySteps != null) {
            confBuilder.setLrPolicySteps(this.lrPolicySteps);
        }
        if (this.lrPolicyPower != null) {
            confBuilder.setLrPolicyPower(this.lrPolicyPower);
        }
        return confBuilder;
    }

    FineTuneConfiguration(IActivation activationFn, WeightInit weightInit, Double biasInit, Distribution dist, Double learningRate, Double biasLearningRate, Map<Integer, Double> learningRateSchedule, Double lrScoreBasedDecay, Double l1, Double l2, Double l1Bias, Double l2Bias, Double dropOut, Updater updater, Double momentum, Map<Integer, Double> momentumSchedule, Double epsilon, Double rho, Double rmsDecay, Double adamMeanDecay, Double adamVarDecay, Boolean miniBatch, Integer numIterations, Integer maxNumLineSearchIterations, Long seed, Boolean useRegularization, OptimizationAlgorithm optimizationAlgo, StepFunction stepFunction, Boolean useDropConnect, Boolean minimize, GradientNormalization gradientNormalization, Double gradientNormalizationThreshold, LearningRatePolicy learningRatePolicy, Double lrPolicyDecayRate, Double lrPolicySteps, Double lrPolicyPower, ConvolutionMode convolutionMode, Boolean pretrain, Boolean backprop, BackpropType backpropType, Integer tbpttFwdLength, Integer tbpttBackLength) {
        this.activationFn = activationFn;
        this.weightInit = weightInit;
        this.biasInit = biasInit;
        this.dist = dist;
        this.learningRate = learningRate;
        this.biasLearningRate = biasLearningRate;
        this.learningRateSchedule = learningRateSchedule;
        this.lrScoreBasedDecay = lrScoreBasedDecay;
        this.l1 = l1;
        this.l2 = l2;
        this.l1Bias = l1Bias;
        this.l2Bias = l2Bias;
        this.dropOut = dropOut;
        this.updater = updater;
        this.momentum = momentum;
        this.momentumSchedule = momentumSchedule;
        this.epsilon = epsilon;
        this.rho = rho;
        this.rmsDecay = rmsDecay;
        this.adamMeanDecay = adamMeanDecay;
        this.adamVarDecay = adamVarDecay;
        this.miniBatch = miniBatch;
        this.numIterations = numIterations;
        this.maxNumLineSearchIterations = maxNumLineSearchIterations;
        this.seed = seed;
        this.useRegularization = useRegularization;
        this.optimizationAlgo = optimizationAlgo;
        this.stepFunction = stepFunction;
        this.useDropConnect = useDropConnect;
        this.minimize = minimize;
        this.gradientNormalization = gradientNormalization;
        this.gradientNormalizationThreshold = gradientNormalizationThreshold;
        this.learningRatePolicy = learningRatePolicy;
        this.lrPolicyDecayRate = lrPolicyDecayRate;
        this.lrPolicySteps = lrPolicySteps;
        this.lrPolicyPower = lrPolicyPower;
        this.convolutionMode = convolutionMode;
        this.pretrain = pretrain;
        this.backprop = backprop;
        this.backpropType = backpropType;
        this.tbpttFwdLength = tbpttFwdLength;
        this.tbpttBackLength = tbpttBackLength;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private IActivation activationFn;
        private WeightInit weightInit;
        private Double biasInit;
        private Distribution dist;
        private Double learningRate;
        private Double biasLearningRate;
        private Map<Integer, Double> learningRateSchedule;
        private Double lrScoreBasedDecay;
        private Double l1;
        private Double l2;
        private Double l1Bias;
        private Double l2Bias;
        private Double dropOut;
        private Updater updater;
        private Double momentum;
        private Map<Integer, Double> momentumSchedule;
        private Double epsilon;
        private Double rho;
        private Double rmsDecay;
        private Double adamMeanDecay;
        private Double adamVarDecay;
        private Boolean miniBatch;
        private Integer numIterations;
        private Integer maxNumLineSearchIterations;
        private Long seed;
        private Boolean useRegularization;
        private OptimizationAlgorithm optimizationAlgo;
        private StepFunction stepFunction;
        private Boolean useDropConnect;
        private Boolean minimize;
        private GradientNormalization gradientNormalization;
        private Double gradientNormalizationThreshold;
        private LearningRatePolicy learningRatePolicy;
        private Double lrPolicyDecayRate;
        private Double lrPolicySteps;
        private Double lrPolicyPower;
        private ConvolutionMode convolutionMode;
        private Boolean pretrain;
        private Boolean backprop;
        private BackpropType backpropType;
        private Integer tbpttFwdLength;
        private Integer tbpttBackLength;

        public Builder seed(int seed) {
            this.seed = seed;
            return this;
        }

        public Builder seed(long seed) {
            this.seed = seed;
            return this;
        }

        public Builder regularization(boolean regularization) {
            this.useRegularization = regularization;
            return this;
        }

        public Builder iterations(int iterations) {
            this.numIterations = iterations;
            return this;
        }

        public Builder activation(Activation activation) {
            this.activationFn = activation.getActivationFunction();
            return this;
        }

        public Builder activationFn(IActivation activationFn) {
            this.activationFn = activationFn;
            return this;
        }

        public Builder weightInit(WeightInit weightInit) {
            this.weightInit = weightInit;
            return this;
        }

        public Builder biasInit(Double biasInit) {
            this.biasInit = biasInit;
            return this;
        }

        public Builder dist(Distribution dist) {
            this.dist = dist;
            return this;
        }

        public Builder learningRate(Double learningRate) {
            this.learningRate = learningRate;
            return this;
        }

        public Builder biasLearningRate(Double biasLearningRate) {
            this.biasLearningRate = biasLearningRate;
            return this;
        }

        public Builder learningRateSchedule(Map<Integer, Double> learningRateSchedule) {
            this.learningRateSchedule = learningRateSchedule;
            return this;
        }

        public Builder lrScoreBasedDecay(Double lrScoreBasedDecay) {
            this.lrScoreBasedDecay = lrScoreBasedDecay;
            return this;
        }

        public Builder l1(Double l1) {
            this.l1 = l1;
            return this;
        }

        public Builder l2(Double l2) {
            this.l2 = l2;
            return this;
        }

        public Builder l1Bias(Double l1Bias) {
            this.l1Bias = l1Bias;
            return this;
        }

        public Builder l2Bias(Double l2Bias) {
            this.l2Bias = l2Bias;
            return this;
        }

        public Builder dropOut(Double dropOut) {
            this.dropOut = dropOut;
            return this;
        }

        public Builder updater(Updater updater) {
            this.updater = updater;
            return this;
        }

        public Builder momentum(Double momentum) {
            this.momentum = momentum;
            return this;
        }

        public Builder momentumSchedule(Map<Integer, Double> momentumSchedule) {
            this.momentumSchedule = momentumSchedule;
            return this;
        }

        public Builder epsilon(Double epsilon) {
            this.epsilon = epsilon;
            return this;
        }

        public Builder rho(Double rho) {
            this.rho = rho;
            return this;
        }

        public Builder rmsDecay(Double rmsDecay) {
            this.rmsDecay = rmsDecay;
            return this;
        }

        public Builder adamMeanDecay(Double adamMeanDecay) {
            this.adamMeanDecay = adamMeanDecay;
            return this;
        }

        public Builder adamVarDecay(Double adamVarDecay) {
            this.adamVarDecay = adamVarDecay;
            return this;
        }

        public Builder miniBatch(Boolean miniBatch) {
            this.miniBatch = miniBatch;
            return this;
        }

        public Builder numIterations(Integer numIterations) {
            this.numIterations = numIterations;
            return this;
        }

        public Builder maxNumLineSearchIterations(Integer maxNumLineSearchIterations) {
            this.maxNumLineSearchIterations = maxNumLineSearchIterations;
            return this;
        }

        public Builder useRegularization(Boolean useRegularization) {
            this.useRegularization = useRegularization;
            return this;
        }

        public Builder optimizationAlgo(OptimizationAlgorithm optimizationAlgo) {
            this.optimizationAlgo = optimizationAlgo;
            return this;
        }

        public Builder stepFunction(StepFunction stepFunction) {
            this.stepFunction = stepFunction;
            return this;
        }

        public Builder useDropConnect(Boolean useDropConnect) {
            this.useDropConnect = useDropConnect;
            return this;
        }

        public Builder minimize(Boolean minimize) {
            this.minimize = minimize;
            return this;
        }

        public Builder gradientNormalization(GradientNormalization gradientNormalization) {
            this.gradientNormalization = gradientNormalization;
            return this;
        }

        public Builder gradientNormalizationThreshold(Double gradientNormalizationThreshold) {
            this.gradientNormalizationThreshold = gradientNormalizationThreshold;
            return this;
        }

        public Builder learningRatePolicy(LearningRatePolicy learningRatePolicy) {
            this.learningRatePolicy = learningRatePolicy;
            return this;
        }

        public Builder lrPolicyDecayRate(Double lrPolicyDecayRate) {
            this.lrPolicyDecayRate = lrPolicyDecayRate;
            return this;
        }

        public Builder lrPolicySteps(Double lrPolicySteps) {
            this.lrPolicySteps = lrPolicySteps;
            return this;
        }

        public Builder lrPolicyPower(Double lrPolicyPower) {
            this.lrPolicyPower = lrPolicyPower;
            return this;
        }

        public Builder convolutionMode(ConvolutionMode convolutionMode) {
            this.convolutionMode = convolutionMode;
            return this;
        }

        public Builder pretrain(Boolean pretrain) {
            this.pretrain = pretrain;
            return this;
        }

        public Builder backprop(Boolean backprop) {
            this.backprop = backprop;
            return this;
        }

        public Builder backpropType(BackpropType backpropType) {
            this.backpropType = backpropType;
            return this;
        }

        public Builder tbpttFwdLength(Integer tbpttFwdLength) {
            this.tbpttFwdLength = tbpttFwdLength;
            return this;
        }

        public Builder tbpttBackLength(Integer tbpttBackLength) {
            this.tbpttBackLength = tbpttBackLength;
            return this;
        }

        public FineTuneConfiguration build() {
            return new FineTuneConfiguration(this.activationFn, this.weightInit, this.biasInit, this.dist, this.learningRate, this.biasLearningRate, this.learningRateSchedule, this.lrScoreBasedDecay, this.l1, this.l2, this.l1Bias, this.l2Bias, this.dropOut, this.updater, this.momentum, this.momentumSchedule, this.epsilon, this.rho, this.rmsDecay, this.adamMeanDecay, this.adamVarDecay, this.miniBatch, this.numIterations, this.maxNumLineSearchIterations, this.seed, this.useRegularization, this.optimizationAlgo, this.stepFunction, this.useDropConnect, this.minimize, this.gradientNormalization, this.gradientNormalizationThreshold, this.learningRatePolicy, this.lrPolicyDecayRate, this.lrPolicySteps, this.lrPolicyPower, this.convolutionMode, this.pretrain, this.backprop, this.backpropType, this.tbpttFwdLength, this.tbpttBackLength);
        }

        public String toString() {
            return "FineTuneConfiguration.Builder(activationFn=" + this.activationFn + ", weightInit=" + (Object)((Object)this.weightInit) + ", biasInit=" + this.biasInit + ", dist=" + this.dist + ", learningRate=" + this.learningRate + ", biasLearningRate=" + this.biasLearningRate + ", learningRateSchedule=" + this.learningRateSchedule + ", lrScoreBasedDecay=" + this.lrScoreBasedDecay + ", l1=" + this.l1 + ", l2=" + this.l2 + ", l1Bias=" + this.l1Bias + ", l2Bias=" + this.l2Bias + ", dropOut=" + this.dropOut + ", updater=" + (Object)((Object)this.updater) + ", momentum=" + this.momentum + ", momentumSchedule=" + this.momentumSchedule + ", epsilon=" + this.epsilon + ", rho=" + this.rho + ", rmsDecay=" + this.rmsDecay + ", adamMeanDecay=" + this.adamMeanDecay + ", adamVarDecay=" + this.adamVarDecay + ", miniBatch=" + this.miniBatch + ", numIterations=" + this.numIterations + ", maxNumLineSearchIterations=" + this.maxNumLineSearchIterations + ", seed=" + this.seed + ", useRegularization=" + this.useRegularization + ", optimizationAlgo=" + (Object)((Object)this.optimizationAlgo) + ", stepFunction=" + this.stepFunction + ", useDropConnect=" + this.useDropConnect + ", minimize=" + this.minimize + ", gradientNormalization=" + (Object)((Object)this.gradientNormalization) + ", gradientNormalizationThreshold=" + this.gradientNormalizationThreshold + ", learningRatePolicy=" + (Object)((Object)this.learningRatePolicy) + ", lrPolicyDecayRate=" + this.lrPolicyDecayRate + ", lrPolicySteps=" + this.lrPolicySteps + ", lrPolicyPower=" + this.lrPolicyPower + ", convolutionMode=" + (Object)((Object)this.convolutionMode) + ", pretrain=" + this.pretrain + ", backprop=" + this.backprop + ", backpropType=" + (Object)((Object)this.backpropType) + ", tbpttFwdLength=" + this.tbpttFwdLength + ", tbpttBackLength=" + this.tbpttBackLength + ")";
        }
    }
}

