/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Iterator;
import java.util.Map;
import org.directwebremoting.dwrp.AbstractOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

public class ObjectOutboundVariable
extends AbstractOutboundVariable
implements OutboundVariable {
    private boolean isNamed;
    private Map ovs;
    private String scriptClassName;

    public ObjectOutboundVariable(OutboundContext outboundContext) {
        super(outboundContext);
    }

    public void init(Map aOvs, String aScriptClassName) {
        this.ovs = aOvs;
        this.scriptClassName = aScriptClassName;
        boolean bl = this.isNamed = this.scriptClassName != null && !this.scriptClassName.equals("");
        if (this.isNamed) {
            this.forceInline(false);
        }
        this.setChildren(this.ovs.values());
    }

    protected AbstractOutboundVariable.NotInlineDefinition getNotInlineDefinition() {
        String declareCode = !this.isNamed ? "var " + this.getVariableName() + "={};" : "var " + this.getVariableName() + "=new " + this.scriptClassName + "();";
        StringBuffer buildCode = new StringBuffer();
        Iterator it = this.ovs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            OutboundVariable nested = (OutboundVariable)entry.getValue();
            String nestedAssignCode = nested.getAssignCode();
            String varName = this.getVariableName();
            if (LocalUtil.isSimpleName(name)) {
                buildCode.append(varName);
                buildCode.append('.');
                buildCode.append(name);
                buildCode.append('=');
                buildCode.append(nestedAssignCode);
                buildCode.append(';');
                continue;
            }
            buildCode.append(varName);
            buildCode.append("['");
            buildCode.append(name);
            buildCode.append("']=");
            buildCode.append(nestedAssignCode);
            buildCode.append(';');
        }
        buildCode.append("\r\n");
        return new AbstractOutboundVariable.NotInlineDefinition(declareCode, buildCode.toString());
    }

    protected String getInlineDefinition() {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        boolean first = true;
        Iterator it = this.ovs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            OutboundVariable nested = (OutboundVariable)entry.getValue();
            String innerAssignCode = nested.getAssignCode();
            if (!first) {
                buffer.append(',');
            }
            if (LocalUtil.isSimpleName(name)) {
                buffer.append(name);
                buffer.append(':');
                buffer.append(innerAssignCode);
            } else {
                buffer.append('\'');
                buffer.append(name);
                buffer.append("':");
                buffer.append(innerAssignCode);
            }
            first = false;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public String toString() {
        return "Object:" + this.toStringDefinitionHint() + ":" + this.ovs;
    }
}

