/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.contrib;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Call;
import org.directwebremoting.extend.Calls;
import org.directwebremoting.extend.Replies;
import org.directwebremoting.extend.Reply;
import org.directwebremoting.impl.DefaultRemoter;

public class ParallelDefaultRemoter
extends DefaultRemoter {
    private static final Log log = LogFactory.getLog(ParallelDefaultRemoter.class);
    private int corePoolsize = 10;
    private int maximumPoolsize = 100;
    private long keepAliveTime = 5000L;
    private long timeout = 10000L;
    private final ThreadPoolExecutor executorService = (ThreadPoolExecutor)Executors.newCachedThreadPool();

    public ParallelDefaultRemoter() {
        this.executorService.setCorePoolSize(this.corePoolsize);
        this.executorService.setMaximumPoolSize(this.maximumPoolsize);
        this.executorService.setKeepAliveTime(this.keepAliveTime, TimeUnit.MILLISECONDS);
    }

    public void setParallelDefaultRemoterTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setParallelDefaultRemoterCorePoolsize(int corePoolsize) {
        this.corePoolsize = corePoolsize;
        this.executorService.setCorePoolSize(corePoolsize);
    }

    public void setParallelDefaultRemoterMaximumPoolsize(int maximumPoolsize) {
        this.maximumPoolsize = maximumPoolsize;
        this.executorService.setMaximumPoolSize(maximumPoolsize);
    }

    public void setParallelDefaultRemoterKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
        this.executorService.setKeepAliveTime(keepAliveTime, TimeUnit.MILLISECONDS);
    }

    public Replies execute(Calls calls) {
        int callNum;
        Replies replies = new Replies(calls.getBatchId());
        Future[] future = new Future[calls.getCallCount()];
        if (calls.getCallCount() == 1) {
            return super.execute(calls);
        }
        for (callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            Call call = calls.getCall(callNum);
            future[callNum] = this.executorService.submit(new CallCallable(call));
        }
        for (callNum = 0; callNum < calls.getCallCount(); ++callNum) {
            try {
                Reply reply = (Reply)future[callNum].get(this.timeout, TimeUnit.MILLISECONDS);
                replies.addReply(reply);
                continue;
            }
            catch (InterruptedException ex) {
                log.warn((Object)"Method execution failed: ", (Throwable)ex);
                replies.addReply(new Reply(calls.getCall(callNum).getCallId(), null, ex));
                continue;
            }
            catch (ExecutionException ex) {
                log.warn((Object)"Method execution failed: ", (Throwable)ex);
                replies.addReply(new Reply(calls.getCall(callNum).getCallId(), null, ex));
                continue;
            }
            catch (TimeoutException ex) {
                log.warn((Object)"Method execution failed: ", (Throwable)ex);
                replies.addReply(new Reply(calls.getCall(callNum).getCallId(), null, ex));
            }
        }
        return replies;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CallCallable
    implements Callable<Reply> {
        private final Call call;

        public CallCallable(Call call) {
            this.call = call;
        }

        @Override
        public Reply call() {
            return ParallelDefaultRemoter.this.execute(this.call);
        }
    }
}

