/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.dwrp.MapOutboundVariable;
import org.directwebremoting.dwrp.ObjectJsonOutboundVariable;
import org.directwebremoting.dwrp.ObjectNonJsonOutboundVariable;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.JsonModeMarshallException;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.Property;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicObjectConverter
extends BaseV20Converter
implements NamedConverter {
    protected String javascript = null;
    protected List<String> exclusions = null;
    protected List<String> inclusions = null;
    protected Class<?> instanceType = null;
    protected ConverterManager converterManager = null;
    private static final Log log = LogFactory.getLog(BasicObjectConverter.class);

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = data.getValue();
        if (value.trim().equals("null")) {
            return null;
        }
        if (!value.startsWith("{")) {
            throw new MarshallException(paramType, Messages.getString("BeanConverter.FormatError", "{"));
        }
        if (!value.endsWith("}")) {
            throw new MarshallException(paramType, Messages.getString("BeanConverter.FormatError", "{"));
        }
        value = value.substring(1, value.length() - 1);
        try {
            Object bean = this.instanceType != null ? this.instanceType.newInstance() : paramType.newInstance();
            if (this.instanceType != null) {
                inctx.addConverted(data, this.instanceType, bean);
            } else {
                inctx.addConverted(data, paramType, bean);
            }
            Map<String, Property> properties = this.getPropertyMapFromObject(bean, false, true);
            Map<String, String> tokens = BasicObjectConverter.extractInboundTokens(paramType, value);
            for (Map.Entry<String, String> entry : tokens.entrySet()) {
                String key = entry.getKey();
                String val = entry.getValue();
                Property property = properties.get(key);
                if (property == null) {
                    log.warn((Object)("Missing java bean property to match javascript property: " + key + ". For causes see debug level logs:"));
                    log.debug((Object)"- The javascript may be refer to a property that does not exist");
                    log.debug((Object)("- You may be missing the correct setter: set" + Character.toTitleCase(key.charAt(0)) + key.substring(1) + "()"));
                    log.debug((Object)"- The property may be excluded using include or exclude rules.");
                    StringBuffer all = new StringBuffer();
                    Iterator<String> pit = properties.keySet().iterator();
                    while (pit.hasNext()) {
                        all.append(pit.next());
                        if (!pit.hasNext()) continue;
                        all.append(',');
                    }
                    log.debug((Object)("Fields exist for (" + all + ")."));
                    continue;
                }
                Class<?> propType = property.getPropertyType();
                String[] split = ParseUtil.splitInbound(val);
                String splitValue = split[1];
                String splitType = split[0];
                InboundVariable nested = new InboundVariable(data.getLookup(), null, splitType, splitValue);
                nested.dereference();
                TypeHintContext incc = this.createTypeHintContext(inctx, property);
                Object output = this.converterManager.convertInbound(propType, nested, inctx, incc);
                property.setValue(bean, output);
            }
            return bean;
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(paramType, (Throwable)ex);
        }
    }

    protected abstract TypeHintContext createTypeHintContext(InboundContext var1, Property var2);

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) throws MarshallException {
        MapOutboundVariable ov;
        TreeMap<String, OutboundVariable> ovs = new TreeMap<String, OutboundVariable>();
        if (outctx.isJsonMode()) {
            if (this.javascript != null) {
                throw new JsonModeMarshallException(data.getClass(), "Can't used named Javascript objects in JSON mode");
            }
            ov = new ObjectJsonOutboundVariable();
        } else {
            ov = new ObjectNonJsonOutboundVariable(outctx, this.getJavascript());
        }
        outctx.put(data, ov);
        try {
            Map<String, Property> properties = this.getPropertyMapFromObject(data, true, false);
            for (Map.Entry<String, Property> entry : properties.entrySet()) {
                String name = entry.getKey();
                Property property = entry.getValue();
                Object value = property.getValue(data);
                OutboundVariable nested = this.getConverterManager().convertOutbound(value, outctx);
                ovs.put(name, nested);
            }
        }
        catch (MarshallException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MarshallException(data.getClass(), (Throwable)ex);
        }
        ov.setChildren(ovs);
        return ov;
    }

    public void setExclude(String excludes) {
        if (this.inclusions != null) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.OnlyIncludeOrExclude"));
        }
        this.exclusions = new ArrayList<String>();
        String toSplit = excludes.replace(",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn((Object)("Exclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name."));
            }
            this.exclusions.add(rule);
        }
    }

    public void setInclude(String includes) {
        if (this.exclusions != null) {
            throw new IllegalArgumentException(Messages.getString("BeanConverter.OnlyIncludeOrExclude"));
        }
        this.inclusions = new ArrayList<String>();
        String toSplit = includes.replace(",", " ");
        StringTokenizer st = new StringTokenizer(toSplit);
        while (st.hasMoreTokens()) {
            String rule = st.nextToken();
            if (rule.startsWith("get")) {
                log.warn((Object)("Inclusions are based on property names and not method names. '" + rule + "' starts with 'get' so it looks like a method name and not a property name."));
            }
            this.inclusions.add(rule);
        }
    }

    public void setImplementation(String name) throws ClassNotFoundException {
        this.setInstanceType(LocalUtil.classForName(name));
    }

    @Override
    public Class<?> getInstanceType() {
        return this.instanceType;
    }

    @Override
    public void setInstanceType(Class<?> instanceType) {
        this.instanceType = instanceType;
    }

    @Override
    public void setConverterManager(ConverterManager converterManager) {
        this.converterManager = converterManager;
    }

    public ConverterManager getConverterManager() {
        return this.converterManager;
    }

    protected boolean isAllowedByIncludeExcludeRules(String property) {
        if (this.exclusions != null) {
            for (String exclusion : this.exclusions) {
                if (!property.equals(exclusion)) continue;
                return false;
            }
        }
        if (this.inclusions != null) {
            for (String inclusion : this.inclusions) {
                if (!property.equals(inclusion)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected static Map<String, String> extractInboundTokens(Class<?> paramType, String value) throws MarshallException {
        HashMap<String, String> tokens = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(value, ",");
        int size = st.countTokens();
        for (int i = 0; i < size; ++i) {
            String token = st.nextToken();
            if (token.trim().length() == 0) continue;
            int colonpos = token.indexOf(":");
            if (colonpos == -1) {
                throw new MarshallException(paramType, Messages.getString("BeanConverter.MissingSeparator", ":", token));
            }
            String key = token.substring(0, colonpos).trim();
            String val = token.substring(colonpos + 1).trim();
            tokens.put(key, val);
        }
        return tokens;
    }

    @Override
    public String getJavascript() {
        return this.javascript;
    }

    @Override
    public void setJavascript(String javascript) {
        this.javascript = javascript;
    }
}

