/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.DownloadManager;
import org.directwebremoting.extend.FileGenerator;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.impl.DataUrlDownloadManager;
import org.directwebremoting.impl.FileTransferFileGenerator;
import org.directwebremoting.impl.ImageIOFileGenerator;
import org.directwebremoting.impl.InputStreamFileGenerator;
import org.directwebremoting.io.FileTransfer;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileConverter
extends BaseV20Converter
implements Converter {
    private boolean preferDataUrlSchema = false;

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        FormField formField = data.getFormField();
        if (paramType == FileTransfer.class) {
            return new FileTransfer(formField.getName(), formField.getMimeType(), formField.getInputStream());
        }
        if (paramType == InputStream.class) {
            return formField.getInputStream();
        }
        if (paramType == BufferedImage.class) {
            try {
                return ImageIO.read(formField.getInputStream());
            }
            catch (IOException ex) {
                throw new MarshallException(paramType, (Throwable)ex);
            }
        }
        throw new MarshallException(paramType, Messages.getString("MarshallException.FileFailure", paramType));
    }

    @Override
    public OutboundVariable convertOutbound(Object object, OutboundContext outboundContext) throws MarshallException {
        if (object == null) {
            return new NonNestedOutboundVariable("null");
        }
        try {
            Object in;
            FileGenerator generator;
            if (object instanceof BufferedImage) {
                BufferedImage image = (BufferedImage)object;
                generator = new ImageIOFileGenerator(image, "image/png", "image", "png");
            } else if (object instanceof InputStream) {
                in = (InputStream)object;
                generator = new InputStreamFileGenerator((InputStream)in, "download.dat", "binary/octet-stream");
            } else if (object instanceof FileTransfer) {
                in = (FileTransfer)object;
                generator = new FileTransferFileGenerator((FileTransfer)in);
            } else {
                throw new MarshallException(object.getClass());
            }
            DownloadManager downloadManager = this.preferDataUrlSchema && this.isDataUrlAvailable() ? new DataUrlDownloadManager() : WebContextFactory.get().getContainer().getBean(DownloadManager.class);
            String url = downloadManager.addFile(generator);
            return new NonNestedOutboundVariable(url);
        }
        catch (IOException ex) {
            throw new MarshallException(this.getClass(), (Throwable)ex);
        }
    }

    protected boolean isDataUrlAvailable() {
        HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
        return request.getHeader("user-agent").indexOf("MSIE") == -1;
    }

    public void setPreferDataUrlSchema(boolean preferDataUrlSchema) {
        this.preferDataUrlSchema = preferDataUrlSchema;
    }
}

