/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.convert;

import org.directwebremoting.convert.BaseV20Converter;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.JavascriptUtil;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrimitiveConverter
extends BaseV20Converter
implements Converter {
    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx) throws MarshallException {
        String value = data.getValue().trim();
        try {
            return LocalUtil.simpleConvert(value, paramType);
        }
        catch (NumberFormatException ex) {
            throw new MarshallException(paramType, Messages.getString("PrimitiveConverter.FormatError", value));
        }
        catch (IllegalArgumentException ex) {
            throw new MarshallException(paramType);
        }
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext outctx) {
        Class<?> paramType = data.getClass();
        if (data.equals(Boolean.TRUE)) {
            return new NonNestedOutboundVariable("true");
        }
        if (data.equals(Boolean.FALSE)) {
            return new NonNestedOutboundVariable("false");
        }
        if (paramType == Character.class) {
            return new NonNestedOutboundVariable('\"' + JavascriptUtil.escapeJavaScript(data.toString()) + '\"');
        }
        return new NonNestedOutboundVariable(data.toString());
    }
}

