/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.create;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.create.AbstractCreator;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewCreator
extends AbstractCreator
implements Creator {
    private static final Log log = LogFactory.getLog(NewCreator.class);
    private Class<?> clazz;

    public void setClass(String classname) {
        try {
            this.clazz = LocalUtil.classForName(classname);
            if (this.getJavascript() == null) {
                this.setJavascript(this.clazz.getSimpleName());
            }
        }
        catch (ExceptionInInitializerError ex) {
            log.warn((Object)"Class load error", (Throwable)ex);
            throw new IllegalArgumentException(Messages.getString("Creator.ClassLoadError", classname));
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(Messages.getString("Creator.ClassNotFound", classname));
        }
    }

    @Override
    public Class<?> getType() {
        return this.clazz;
    }

    @Override
    public Object getInstance() throws InstantiationException {
        try {
            return this.clazz.newInstance();
        }
        catch (IllegalAccessException ex) {
            throw new InstantiationException(Messages.getString("Creator.IllegalAccess"));
        }
    }

    public void setClassName(String className) {
        this.setClass(className);
    }

    public String getClassName() {
        return this.getType().getName();
    }
}

