/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import org.directwebremoting.dwrp.ArrayJsonOutboundVariable;
import org.directwebremoting.dwrp.CollectionOutboundVariable;
import org.directwebremoting.dwrp.NonJsonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public class ArrayNonJsonOutboundVariable
extends NonJsonNestedOutboundVariable
implements CollectionOutboundVariable {
    public ArrayNonJsonOutboundVariable(OutboundContext outboundContext) {
        super(outboundContext);
    }

    public void prepareAssignCode() {
        if (this.isOutline()) {
            this.setAssignCode(this.getVariableName());
        } else {
            this.prepareChildAssignCodes();
            this.setAssignCode(ArrayJsonOutboundVariable.createJsonString(this.children));
        }
    }

    public void prepareBuildDeclareCodes() {
        if (this.isOutline()) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            String variableName = this.getVariableName();
            for (OutboundVariable child : this.children) {
                if (child != null) {
                    buffer.append(variableName);
                    buffer.append('[');
                    buffer.append(i);
                    buffer.append("]=");
                    buffer.append(child.getAssignCode());
                    buffer.append(';');
                }
                ++i;
            }
            buffer.append("\r\n");
            this.setBaseDeclareCode("var " + variableName + "=[];");
            this.setBaseBuildCode(buffer.toString());
        } else {
            this.setBaseDeclareCode("");
            this.setBaseBuildCode("");
        }
    }

    public String toString() {
        return "ArrayNonJsonOutboundVariable:" + this.children;
    }
}

