/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.ErrorOutboundVariable;
import org.directwebremoting.extend.Converter;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.InboundVariable;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.extend.NamedConverter;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.extend.TypeHintContext;
import org.directwebremoting.util.LocalUtil;
import org.directwebremoting.util.Messages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConverterManager
implements ConverterManager {
    protected Map<TypeHintContext, Class<?>> extraTypeInfoMap = new HashMap();
    protected Map<String, Class<?>> converterTypes = new HashMap();
    protected Map<String, Converter> converters = new HashMap<String, Converter>();
    private static List<String> ignore = Arrays.asList("converter", "match");
    private static final Log log = LogFactory.getLog(DefaultConverterManager.class);

    @Override
    public void addConverterType(String id, String className) {
        if (!LocalUtil.isJavaIdentifier(id)) {
            log.error((Object)("Illegal identifier: '" + id + "'"));
            return;
        }
        Class<Converter> clazz = LocalUtil.classForName(id, className, Converter.class);
        if (clazz != null) {
            log.debug((Object)("- adding converter type: " + id + " = " + clazz.getName()));
            this.converterTypes.put(id, clazz);
        }
    }

    @Override
    public void addConverter(String match, String type, Map<String, String> params) throws IllegalArgumentException, InstantiationException, IllegalAccessException {
        Class<?> clazz = this.converterTypes.get(type);
        if (clazz == null) {
            log.info((Object)("Probably not an issue: " + match + " is not available so the " + type + " converter will not load. This is only an problem if you wanted to use it."));
            return;
        }
        Converter converter = (Converter)clazz.newInstance();
        LocalUtil.setParams(converter, params, ignore);
        this.addConverter(match, converter);
    }

    @Override
    public void addConverter(String match, Converter converter) throws IllegalArgumentException {
        Converter other = this.converters.get(match);
        if (other != null) {
            log.warn((Object)("Clash of converters for " + match + ". Using " + converter.getClass().getName() + " in place of " + other.getClass().getName()));
        }
        log.debug((Object)("- adding converter: " + converter.getClass().getSimpleName() + " for " + match));
        converter.setConverterManager(this);
        this.converters.put(match, converter);
    }

    @Override
    public Collection<String> getConverterMatchStrings() {
        return Collections.unmodifiableSet(this.converters.keySet());
    }

    @Override
    public Converter getConverterByMatchString(String match) {
        return this.converters.get(match);
    }

    @Override
    public boolean isConvertable(Class<?> paramType) {
        return this.getConverter(paramType) != null;
    }

    @Override
    public Object convertInbound(Class<?> paramType, InboundVariable data, InboundContext inctx, TypeHintContext incc) throws MarshallException {
        Object converted = inctx.getConverted(data, paramType);
        if (converted == null) {
            Converter converter = null;
            String type = data.getNamedObjectType();
            if (type != null) {
                converter = this.getNamedConverter(paramType, type);
            }
            if (converter == null) {
                converter = this.getConverter(paramType);
            }
            if (converter == null) {
                throw new MarshallException(paramType, Messages.getString("DefaultConverterManager.MissingConverter", paramType));
            }
            if (data.isNull()) {
                return null;
            }
            inctx.pushContext(incc);
            converted = converter.convertInbound(paramType, data, inctx);
            inctx.popContext();
        }
        return converted;
    }

    @Override
    public OutboundVariable convertOutbound(Object data, OutboundContext converted) throws MarshallException {
        if (data == null) {
            return new NonNestedOutboundVariable("null");
        }
        OutboundVariable ov = converted.get(data);
        if (ov != null) {
            return ov.getReferenceVariable();
        }
        Converter converter = this.getConverter(data);
        if (converter == null) {
            String message = Messages.getString("DefaultConverterManager.MissingConverter", data.getClass().getName());
            log.error((Object)message);
            return new ErrorOutboundVariable(message);
        }
        return converter.convertOutbound(data, converted);
    }

    @Override
    public void setExtraTypeInfo(TypeHintContext thc, Class<?> type) {
        this.extraTypeInfoMap.put(thc, type);
    }

    @Override
    public Class<?> getExtraTypeInfo(TypeHintContext thc) {
        return this.extraTypeInfoMap.get(thc);
    }

    @Override
    public void setConverters(Map<String, Converter> converters) {
        this.converters = converters;
    }

    private Converter getConverter(Object object) {
        if (object == null) {
            return this.getConverter(Void.TYPE);
        }
        return this.getConverter(object.getClass());
    }

    protected Converter getNamedConverter(Class<?> paramType, String javascriptClassName) throws MarshallException {
        for (Map.Entry<String, Converter> entry : this.converters.entrySet()) {
            NamedConverter boConv;
            String match = entry.getKey();
            Converter conv = entry.getValue();
            if (!(conv instanceof NamedConverter) || (boConv = (NamedConverter)conv).getJavascript() == null || !boConv.getJavascript().equals(javascriptClassName)) continue;
            try {
                Class<?> inboundClass = LocalUtil.classForName(match);
                if (!paramType.isAssignableFrom(inboundClass)) continue;
                boConv.setInstanceType(inboundClass);
                return boConv;
            }
            catch (ClassNotFoundException ex) {
                throw new MarshallException(paramType, (Throwable)ex);
            }
        }
        return null;
    }

    private Converter getConverter(Class<?> paramType) {
        block7: {
            Converter converter = this.getConverterAssignableFrom(paramType);
            if (converter != null) {
                return converter;
            }
            String lookup = paramType.getName();
            if (lookup.startsWith("$Proxy") && (converter = this.converters.get("$Proxy*")) != null) {
                return converter;
            }
            while (true) {
                if ((converter = this.converters.get(lookup + ".*")) != null) {
                    return converter;
                }
                converter = this.converters.get(lookup + '*');
                if (converter != null) {
                    return converter;
                }
                if (lookup.length() == 0) break block7;
                int lastdot = lookup.lastIndexOf(46);
                if (lastdot != -1) {
                    lookup = lookup.substring(0, lastdot);
                    continue;
                }
                int arrayMarkers = 0;
                while (lookup.charAt(arrayMarkers) == '[') {
                    ++arrayMarkers;
                }
                if (arrayMarkers == 0) break block7;
                converter = this.converters.get(lookup = lookup.substring(arrayMarkers - 1, arrayMarkers + 1));
                if (converter != null) break;
            }
            return converter;
        }
        return null;
    }

    private Converter getConverterAssignableFrom(Class<?> paramType) {
        if (paramType == null) {
            return null;
        }
        String lookup = paramType.getName();
        Converter converter = this.converters.get(lookup);
        if (converter != null) {
            return converter;
        }
        for (Class<?> anInterface : paramType.getInterfaces()) {
            converter = this.getConverterAssignableFrom(anInterface);
            if (converter == null) continue;
            this.converters.put(lookup, converter);
            return converter;
        }
        converter = this.getConverterAssignableFrom(paramType.getSuperclass());
        if (converter != null) {
            this.converters.put(lookup, converter);
        }
        return converter;
    }
}

