/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.dwrp;

import java.util.Map;
import org.directwebremoting.dwrp.JsonNestedOutboundVariable;
import org.directwebremoting.dwrp.MapOutboundVariable;
import org.directwebremoting.extend.OutboundVariable;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectJsonOutboundVariable
extends JsonNestedOutboundVariable
implements MapOutboundVariable {
    private Map<String, OutboundVariable> children;

    @Override
    public void setChildren(Map<String, OutboundVariable> children) {
        this.children = children;
    }

    @Override
    public String getAssignCode() {
        return ObjectJsonOutboundVariable.createJsonString(this.children);
    }

    protected static String createJsonString(Map<String, OutboundVariable> children) {
        StringBuffer buffer = new StringBuffer();
        buffer.append('{');
        boolean first = true;
        for (Map.Entry<String, OutboundVariable> entry : children.entrySet()) {
            String name = entry.getKey();
            OutboundVariable nested = entry.getValue();
            String innerAssignCode = nested.getAssignCode();
            if (!first) {
                buffer.append(',');
            }
            if (LocalUtil.isSimpleName(name)) {
                buffer.append(name);
                buffer.append(':');
                buffer.append(innerAssignCode);
            } else {
                buffer.append('\'');
                buffer.append(name);
                buffer.append("':");
                buffer.append(innerAssignCode);
            }
            first = false;
        }
        buffer.append('}');
        return buffer.toString();
    }

    public String toString() {
        return "ObjectJsonOutboundVariable:" + this.children;
    }
}

