/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.dwrp.ParseUtil;
import org.directwebremoting.extend.EnginePrivate;
import org.directwebremoting.extend.FormField;
import org.directwebremoting.extend.InboundContext;
import org.directwebremoting.extend.MarshallException;
import org.directwebremoting.json.InvalidJsonException;
import org.directwebremoting.json.JsonArray;
import org.directwebremoting.json.JsonBoolean;
import org.directwebremoting.json.JsonHack;
import org.directwebremoting.json.JsonNull;
import org.directwebremoting.json.JsonNumber;
import org.directwebremoting.json.JsonObject;
import org.directwebremoting.json.JsonString;
import org.directwebremoting.json.JsonValue;
import org.directwebremoting.util.Messages;

public final class InboundVariable {
    private InboundContext context;
    private String key;
    private String type;
    private FormField formField;
    private static final Log log = LogFactory.getLog(InboundVariable.class);

    public InboundVariable(InboundContext context, String key, String type, String value) {
        this(context, key, type, new FormField(value));
    }

    public InboundVariable(InboundContext context, String key, String type, FormField fileValue) {
        this.context = context;
        this.type = type;
        this.formField = fileValue;
        this.key = key;
    }

    public void dereference() throws MarshallException {
        int maxDepth = 0;
        while ("reference".equals(this.type)) {
            InboundVariable cd = this.context.getInboundVariable(this.formField.getString());
            if (cd == null) {
                throw new MarshallException(this.getClass(), Messages.getString("InboundVariable.MissingVariable", this.formField.getString()));
            }
            this.type = cd.type;
            this.formField = cd.getFormField();
            this.key = cd.key;
            if (++maxDepth <= 20) continue;
            throw new MarshallException(this.getClass(), "Max depth exceeded when dereferencing " + this.formField.getString());
        }
    }

    public InboundContext getLookup() {
        return this.context;
    }

    public String getNamedObjectType() {
        if (this.type.startsWith("Object_")) {
            return this.type.substring("Object_".length());
        }
        return null;
    }

    public JsonValue getJsonValue(OnJsonParseError onError) throws InvalidJsonException {
        return this.getJsonValue(onError, 0);
    }

    private JsonValue getJsonValue(OnJsonParseError onError, int currentDepth) throws InvalidJsonException {
        if (currentDepth > 50) {
            throw new InvalidJsonException("JSON structure too deeply nested. Is it recursive?");
        }
        String value = this.getValue();
        if (this.type.equalsIgnoreCase("boolean")) {
            return new JsonBoolean(Boolean.parseBoolean(value));
        }
        if (this.type.equalsIgnoreCase("number")) {
            return new JsonNumber(Double.parseDouble(value));
        }
        if (this.type.equalsIgnoreCase("string")) {
            return new JsonString(value);
        }
        if (this.type.equalsIgnoreCase("date")) {
            switch (onError) {
                case Throw: {
                    throw new InvalidJsonException("Can't use date in JSON");
                }
                case Skip: {
                    return new JsonNull();
                }
                case Hack: {
                    return new JsonHack("new Date(" + value + ")");
                }
            }
        } else if (this.type.equalsIgnoreCase("xml")) {
            switch (onError) {
                case Throw: {
                    throw new InvalidJsonException("Can't use XML in JSON");
                }
                case Skip: {
                    return new JsonNull();
                }
                case Hack: {
                    return new JsonHack(EnginePrivate.xmlStringToJavascriptDom(value));
                }
            }
        } else {
            if (this.type.equalsIgnoreCase("array")) {
                JsonArray array = new JsonArray();
                if (value.trim().equals("null")) {
                    return new JsonNull();
                }
                if (!value.startsWith("[")) {
                    throw new InvalidJsonException(Messages.getString("CollectionConverter.FormatError", "["));
                }
                if (!value.endsWith("]")) {
                    throw new InvalidJsonException(Messages.getString("CollectionConverter.FormatError", "]"));
                }
                value = value.substring(1, value.length() - 1);
                StringTokenizer st = new StringTokenizer(value, ",");
                int size = st.countTokens();
                for (int i = 0; i < size; ++i) {
                    String token = st.nextToken();
                    String[] split = ParseUtil.splitInbound(token);
                    String splitValue = split[1];
                    InboundVariable nested = this.context.getInboundVariable(splitValue);
                    array.add(nested.getJsonValue(onError, currentDepth + 1));
                }
                return array;
            }
            if (this.type.startsWith("Object_")) {
                JsonObject object = new JsonObject();
                if (value.trim().equals("null")) {
                    return new JsonNull();
                }
                if (!value.startsWith("{")) {
                    throw new InvalidJsonException(Messages.getString("MapConverter.FormatError", "{"));
                }
                if (!value.endsWith("}")) {
                    throw new InvalidJsonException(Messages.getString("MapConverter.FormatError", "}"));
                }
                value = value.substring(1, value.length() - 1);
                StringTokenizer st = new StringTokenizer(value, ",");
                int size = st.countTokens();
                for (int i = 0; i < size; ++i) {
                    String token = st.nextToken();
                    if (token.trim().length() == 0) continue;
                    int colonpos = token.indexOf(":");
                    if (colonpos == -1) {
                        throw new InvalidJsonException(Messages.getString("MapConverter.MissingSeparator", ":", token));
                    }
                    String valStr = token.substring(colonpos + 1).trim();
                    String[] splitIv = ParseUtil.splitInbound(valStr);
                    String splitIvValue = splitIv[1];
                    String keyStr = token.substring(0, colonpos).trim();
                    InboundVariable nested = this.context.getInboundVariable(splitIvValue);
                    object.put(keyStr, nested.getJsonValue(onError, currentDepth + 1));
                }
                return object;
            }
        }
        log.warn((Object)("Data type: " + this.type + " is not one that InboundVariable understands"));
        throw new InvalidJsonException("Unknown data type");
    }

    public boolean isNull() {
        return this.type.equals("null");
    }

    public String getValue() {
        return this.formField.getString();
    }

    public FormField getFormField() {
        return this.formField;
    }

    public String toString() {
        return this.type + ":" + this.formField.getString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof InboundVariable)) {
            return false;
        }
        InboundVariable that = (InboundVariable)obj;
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (!this.formField.equals(that.formField)) {
            return false;
        }
        return this.key != null && that.key != null;
    }

    public int hashCode() {
        return this.formField.hashCode() + this.type.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OnJsonParseError {
        Throw,
        Skip,
        Hack;

    }
}

