/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.AjaxFilterManager;
import org.directwebremoting.extend.Configurator;
import org.directwebremoting.extend.ConverterManager;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.DwrScopes;
import org.directwebremoting.guice.ExceptionLoggingCloseableHandler;
import org.directwebremoting.guice.InitParam;
import org.directwebremoting.guice.InternalAjaxFilterManager;
import org.directwebremoting.guice.InternalConfigurator;
import org.directwebremoting.guice.InternalConverterManager;
import org.directwebremoting.guice.InternalCreatorManager;
import org.directwebremoting.guice.ModifiableServletConfig;
import org.directwebremoting.guice.ParamName;
import org.directwebremoting.servlet.DwrServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwrGuiceServlet
extends DwrServlet {
    private volatile ServletContext servletContext;
    private static final String INIT_CREATOR_MANAGER = CreatorManager.class.getName();
    private static final String INIT_CONVERTER_MANAGER = ConverterManager.class.getName();
    private static final String INIT_AJAX_FILTER_MANAGER = AjaxFilterManager.class.getName();
    private static final Log log = LogFactory.getLog(DwrGuiceServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletContext = servletConfig.getServletContext();
        DwrGuiceUtil.pushServletContext(this.servletContext);
        try {
            ModifiableServletConfig config = new ModifiableServletConfig(servletConfig);
            this.setInitParameters(config);
            this.configureDelegatedTypes(config);
            super.init(config);
            DwrGuiceServlet.initApplicationScoped();
        }
        finally {
            DwrGuiceUtil.popServletContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        DwrGuiceUtil.pushServletContext(this.servletContext);
        try {
            List<Exception> exceptions = DwrGuiceServlet.destroyApplicationScoped();
            super.destroy();
            for (Exception ex : exceptions) {
                log.warn((Object)"During servlet shutdown", (Throwable)ex);
            }
        }
        finally {
            DwrGuiceUtil.popServletContext();
            this.servletContext = null;
        }
    }

    private void setInitParameters(ModifiableServletConfig config) {
        Injector injector = DwrGuiceUtil.getInjector();
        InjectedConfig cfg = new InjectedConfig(config);
        injector.injectMembers((Object)cfg);
        cfg.setParameters();
    }

    private void configureDelegatedTypes(ModifiableServletConfig config) {
        InternalCreatorManager.setTypeName(config.getInitParameter(INIT_CREATOR_MANAGER));
        InternalConverterManager.setTypeName(config.getInitParameter(INIT_CONVERTER_MANAGER));
        InternalAjaxFilterManager.setTypeName(config.getInitParameter(INIT_AJAX_FILTER_MANAGER));
        config.setInitParameter(INIT_CREATOR_MANAGER, InternalCreatorManager.class.getName());
        config.setInitParameter(INIT_CONVERTER_MANAGER, InternalConverterManager.class.getName());
        config.setInitParameter(INIT_AJAX_FILTER_MANAGER, InternalAjaxFilterManager.class.getName());
    }

    private static void initApplicationScoped() {
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key<?> key : DwrScopes.APPLICATION.getKeysInScope()) {
            injector.getInstance(key);
        }
    }

    private static List<Exception> destroyApplicationScoped() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        DwrScopes.APPLICATION.closeAll(new ExceptionLoggingCloseableHandler(exceptions));
        return exceptions;
    }

    static String classListToString(List<Class<?>> classList) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        for (Class<?> cls : classList) {
            if (count++ > 0) {
                buf.append(", ");
            }
            buf.append(cls.getName());
        }
        return buf.toString();
    }

    private static class InjectedConfig {
        @Inject(optional=true)
        @InitParam(value=ParamName.ALLOW_GET_FOR_SAFARI)
        Boolean allowGetForSafariButMakeForgeryEasier = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.CROSS_DOMAIN_SESSION_SECURITY)
        Boolean crossDomainSessionSecurity = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.ALLOW_SCRIPT_TAG_REMOTING)
        Boolean allowScriptTagRemoting = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.DEBUG)
        Boolean debug = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.SCRIPT_SESSION_TIMEOUT)
        Long scriptSessionTimeout = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.MAX_CALL_COUNT)
        Integer maxCallCount = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.ACTIVE_REVERSE_AJAX_ENABLED)
        Boolean activeReverseAjaxEnabled = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.MAX_WAIT_AFTER_WRITE)
        Long maxWaitAfterWrite = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.DISCONNECTED_TIME)
        Long disconnectedTime = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.POLL_AND_COMET_ENABLED)
        Boolean pollAndCometEnabled = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.MAX_WAITING_THREADS)
        Integer maxWaitingThreads = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.MAX_POLL_HITS_PER_SECOND)
        Integer maxPollHitsPerSecond = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.PRE_STREAM_WAIT_TIME)
        Long preStreamWaitTime = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.POST_STREAM_WAIT_TIME)
        Long postStreamWaitTime = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.IGNORE_LAST_MODIFIED)
        Boolean ignoreLastModified = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.SCRIPT_COMPRESSED)
        Boolean scriptCompressed = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.SESSION_COOKIE_NAME)
        String sessionCookieName = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.WELCOME_FILES)
        String welcomeFiles = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.NORMALIZE_INCLUDES_QUERY_STRING)
        Boolean normalizeIncludesQueryString = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.OVERRIDE_PATH)
        String overridePath = null;
        @Inject(optional=true)
        Configurator configurator = null;
        @Inject(optional=true)
        @InitParam(value=ParamName.CLASSES)
        List<Class<?>> classes = null;
        private final ModifiableServletConfig config;

        InjectedConfig(ModifiableServletConfig config) {
            this.config = config;
        }

        void setParameter(ParamName paramName, Object value) {
            if (value != null) {
                this.config.setInitParameter(paramName.getName(), value.toString());
            }
        }

        void setParameters() {
            this.setParameter(ParamName.ALLOW_GET_FOR_SAFARI, this.allowGetForSafariButMakeForgeryEasier);
            this.setParameter(ParamName.CROSS_DOMAIN_SESSION_SECURITY, this.crossDomainSessionSecurity);
            this.setParameter(ParamName.ALLOW_SCRIPT_TAG_REMOTING, this.allowScriptTagRemoting);
            this.setParameter(ParamName.DEBUG, this.debug);
            this.setParameter(ParamName.SCRIPT_SESSION_TIMEOUT, this.scriptSessionTimeout);
            this.setParameter(ParamName.MAX_CALL_COUNT, this.maxCallCount);
            this.setParameter(ParamName.ACTIVE_REVERSE_AJAX_ENABLED, this.activeReverseAjaxEnabled);
            this.setParameter(ParamName.MAX_WAIT_AFTER_WRITE, this.maxWaitAfterWrite);
            this.setParameter(ParamName.DISCONNECTED_TIME, this.disconnectedTime);
            this.setParameter(ParamName.POLL_AND_COMET_ENABLED, this.pollAndCometEnabled);
            this.setParameter(ParamName.MAX_WAITING_THREADS, this.maxWaitingThreads);
            this.setParameter(ParamName.MAX_POLL_HITS_PER_SECOND, this.maxPollHitsPerSecond);
            this.setParameter(ParamName.PRE_STREAM_WAIT_TIME, this.preStreamWaitTime);
            this.setParameter(ParamName.POST_STREAM_WAIT_TIME, this.postStreamWaitTime);
            this.setParameter(ParamName.IGNORE_LAST_MODIFIED, this.ignoreLastModified);
            this.setParameter(ParamName.SCRIPT_COMPRESSED, this.scriptCompressed);
            this.setParameter(ParamName.SESSION_COOKIE_NAME, this.sessionCookieName);
            this.setParameter(ParamName.WELCOME_FILES, this.welcomeFiles);
            this.setParameter(ParamName.NORMALIZE_INCLUDES_QUERY_STRING, this.normalizeIncludesQueryString);
            this.setParameter(ParamName.OVERRIDE_PATH, this.overridePath);
            if (this.configurator != null) {
                this.config.setInitParameter("customConfigurator", InternalConfigurator.class.getName());
            }
            if (this.classes != null) {
                this.config.setInitParameter(ParamName.CLASSES.getName(), DwrGuiceServlet.classListToString(this.classes));
            }
        }
    }
}

