/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.guice.AbstractDwrModule;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.DwrScopes;
import org.directwebremoting.guice.ExceptionLoggingCloseableHandler;

public abstract class DwrGuiceServletContextListener
extends AbstractDwrModule
implements ServletContextListener {
    private static final String INJECTOR = DwrGuiceServletContextListener.class.getPackage().getName() + ".Injector";
    private static final Class<?> PACKAGE = DwrGuiceServletContextListener.class;
    private static final String STAGE_KEY = "stage";
    private static final Log log = LogFactory.getLog(DwrGuiceServletContextListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        DwrGuiceUtil.pushServletContext(servletContext);
        try {
            Stage stage = this.getStage();
            Injector injector = Guice.createInjector((Stage)stage, (Module[])new Module[]{this});
            DwrGuiceServletContextListener.publishInjector(servletContext, injector);
        }
        finally {
            DwrGuiceUtil.popServletContext();
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        DwrScopes.GLOBAL.closeAll(new ExceptionLoggingCloseableHandler(exceptions));
        for (Exception e : exceptions) {
            log.warn((Object)("During context destroy, closing globally-scoped Closeables: " + e), (Throwable)e);
        }
    }

    protected abstract void configure();

    protected Stage getStage() {
        Stage stage = Stage.PRODUCTION;
        try {
            Preferences userNode = Preferences.userNodeForPackage(PACKAGE);
            String userStage = userNode.get(STAGE_KEY, null);
            if (userStage != null) {
                stage = Stage.valueOf((String)userStage);
            } else {
                Preferences systemNode = Preferences.systemNodeForPackage(PACKAGE);
                String systemStage = systemNode.get(STAGE_KEY, null);
                if (systemStage != null) {
                    stage = Stage.valueOf((String)systemStage);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stage;
    }

    protected ServletContext getServletContext() {
        return DwrGuiceUtil.getServletContext();
    }

    protected static Injector getPublishedInjector(ServletContext servletContext) {
        Injector injector = (Injector)servletContext.getAttribute(INJECTOR);
        if (injector == null) {
            throw new IllegalStateException("Cannot find Injector in servlet context. You need to register a concrete extension of " + DwrGuiceServletContextListener.class.getName() + " as a servlet context listener in your web.xml.");
        }
        return injector;
    }

    protected static void publishInjector(ServletContext servletContext, Injector injector) {
        servletContext.setAttribute(INJECTOR, (Object)injector);
    }
}

