/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.guice;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.extend.Creator;
import org.directwebremoting.extend.CreatorManager;
import org.directwebremoting.guice.DwrGuiceUtil;
import org.directwebremoting.guice.InternalCreator;
import org.directwebremoting.guice.Remoted;
import org.directwebremoting.impl.DefaultCreatorManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalCreatorManager
implements CreatorManager {
    private final CreatorManager creatorManager = InternalCreatorManager.getCreatorManager();
    private static final ThreadLocal<String> typeName = new ThreadLocal();
    private static final Log log = LogFactory.getLog(InternalCreatorManager.class);

    public InternalCreatorManager() {
        this.addCreators();
    }

    public void setDebug(boolean debug) {
        if (this.creatorManager instanceof DefaultCreatorManager) {
            DefaultCreatorManager dcm = (DefaultCreatorManager)this.creatorManager;
            dcm.setDebug(debug);
        }
    }

    @Override
    public boolean isDebug() {
        return this.creatorManager.isDebug();
    }

    @Override
    public void addCreatorType(String type, String className) {
        this.creatorManager.addCreatorType(type, className);
    }

    @Override
    public void addCreator(String scriptName, String type, Map<String, String> params) throws InstantiationException, IllegalAccessException, IllegalArgumentException {
        this.creatorManager.addCreator(scriptName, type, params);
    }

    @Override
    public void addCreator(String scriptName, Creator creator) throws IllegalArgumentException {
        this.creatorManager.addCreator(scriptName, creator);
    }

    @Override
    public Collection<String> getCreatorNames() throws SecurityException {
        return this.creatorManager.getCreatorNames();
    }

    @Override
    public Creator getCreator(String scriptName) throws SecurityException {
        return this.creatorManager.getCreator(scriptName);
    }

    @Override
    public void setCreators(Map<String, Creator> creators) {
        this.creatorManager.setCreators(creators);
    }

    public boolean isInitApplicationScopeCreatorsAtStartup() {
        if (this.creatorManager instanceof DefaultCreatorManager) {
            DefaultCreatorManager dcm = (DefaultCreatorManager)this.creatorManager;
            return dcm.isInitApplicationScopeCreatorsAtStartup();
        }
        return false;
    }

    public void setInitApplicationScopeCreatorsAtStartup(boolean initApplicationScopeCreatorsAtStartup) {
        if (this.creatorManager instanceof DefaultCreatorManager) {
            DefaultCreatorManager dcm = (DefaultCreatorManager)this.creatorManager;
            dcm.setInitApplicationScopeCreatorsAtStartup(initApplicationScopeCreatorsAtStartup);
        }
    }

    private void addCreators() {
        Injector injector = DwrGuiceUtil.getInjector();
        for (Key key : injector.getBindings().keySet()) {
            Class atype = key.getAnnotationType();
            if (atype == null || !Remoted.class.isAssignableFrom(atype)) continue;
            String scriptName = ((Remoted)Remoted.class.cast(key.getAnnotation())).value();
            if ("".equals(scriptName)) {
                Class cls = (Class)key.getTypeLiteral().getType();
                scriptName = cls.getSimpleName();
            }
            this.addCreator(scriptName, new InternalCreator(injector, key, scriptName));
        }
    }

    static void setTypeName(String name) {
        typeName.set(name);
    }

    private static CreatorManager getCreatorManager() {
        String name = typeName.get();
        try {
            Class<?> cls = Class.forName(name);
            return (CreatorManager)cls.newInstance();
        }
        catch (Exception e) {
            if (name != null && !"".equals(name)) {
                log.warn((Object)("Couldn't make CreatorManager from type: " + name));
            }
            return new DefaultCreatorManager();
        }
    }
}

