/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.impl.AbstractContainer;
import org.directwebremoting.util.LocalUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultContainer
extends AbstractContainer
implements Container {
    protected Map<String, Object> beans = new TreeMap<String, Object>();
    private static final Log log = LogFactory.getLog(DefaultContainer.class);

    public void addParameter(String askFor, Object valueParam) throws ContainerConfigurationException {
        Object value = valueParam;
        if (value instanceof String) {
            try {
                Class<?> impl = LocalUtil.classForName((String)value);
                value = impl.newInstance();
            }
            catch (ClassNotFoundException ex) {
            }
            catch (InstantiationException ex) {
                throw new ContainerConfigurationException("Unable to instantiate " + value);
            }
            catch (IllegalAccessException ex) {
                throw new ContainerConfigurationException("Unable to access " + value);
            }
        }
        if (!(value instanceof String)) {
            try {
                Class<?> iface = LocalUtil.classForName(askFor);
                if (!iface.isAssignableFrom(value.getClass())) {
                    log.error((Object)("Can't cast: " + value + " to " + askFor));
                }
            }
            catch (ClassNotFoundException ex) {
                // empty catch block
            }
        }
        if (log.isDebugEnabled()) {
            if (value instanceof String) {
                log.debug((Object)("Adding IoC setting: " + askFor + "=" + value));
            } else {
                log.debug((Object)("Adding IoC implementation: " + askFor + "=" + value.getClass().getName()));
            }
        }
        this.beans.put(askFor, value);
    }

    public String getParameter(String name) {
        Object value = this.beans.get(name);
        return value == null ? null : value.toString();
    }

    public void setupFinished() {
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            Method[] methods;
            Object ovalue = entry.getValue();
            if (ovalue instanceof String) continue;
            log.debug((Object)("Trying to autowire: " + ovalue.getClass().getName()));
            for (Method setter : methods = ovalue.getClass().getMethods()) {
                Object value;
                if (!setter.getName().startsWith("set") || setter.getName().length() <= 3 || setter.getParameterTypes().length != 1) continue;
                String name = Character.toLowerCase(setter.getName().charAt(3)) + setter.getName().substring(4);
                Class<?> propertyType = setter.getParameterTypes()[0];
                Object setting = this.beans.get(name);
                if (setting != null) {
                    if (propertyType.isAssignableFrom(setting.getClass())) {
                        log.debug((Object)("- autowire-by-name: " + name + "=" + setting));
                        DefaultContainer.invoke(setter, ovalue, setting);
                        continue;
                    }
                    if (setting.getClass() == String.class) {
                        try {
                            value = LocalUtil.simpleConvert((String)setting, propertyType);
                            log.debug((Object)("- autowire-by-name: " + name + "=" + value));
                            DefaultContainer.invoke(setter, ovalue, value);
                        }
                        catch (IllegalArgumentException ex) {}
                        continue;
                    }
                }
                if ((value = this.beans.get(propertyType.getName())) != null) {
                    log.debug((Object)("- autowire-by-type: " + name + "=" + value.getClass().getName()));
                    DefaultContainer.invoke(setter, ovalue, value);
                    continue;
                }
                log.debug((Object)("- skipped autowire: " + name));
            }
        }
        this.callInitializingBeans();
    }

    private static void invoke(Method setter, Object bean, Object value) {
        try {
            setter.invoke(bean, value);
        }
        catch (IllegalArgumentException ex) {
            log.error((Object)("- Internal error: " + ex.getMessage()));
        }
        catch (IllegalAccessException ex) {
            log.error((Object)("- Permission error: " + ex.getMessage()));
        }
        catch (InvocationTargetException ex) {
            log.error((Object)"- Exception during auto-wire: ", ex.getTargetException());
        }
    }

    @Override
    public Object getBean(String id) {
        return this.beans.get(id);
    }

    @Override
    public Collection<String> getBeanNames() {
        return Collections.unmodifiableCollection(this.beans.keySet());
    }
}

