/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.directwebremoting.extend.ContainerAbstraction;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.extend.Sleeper;
import org.directwebremoting.impl.JettyContinuationSleeper;
import org.directwebremoting.impl.ThreadDroppingServerLoadMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JettyContainerAbstraction
implements ContainerAbstraction {
    @Override
    public boolean isNativeEnvironment(ServletConfig servletConfig) {
        String serverInfo = servletConfig.getServletContext().getServerInfo();
        if (serverInfo.startsWith("jetty-")) {
            try {
                int version = Integer.parseInt(serverInfo.substring(6, 7));
                if (version >= 6) {
                    return true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public Sleeper createSleeper(HttpServletRequest request) {
        return new JettyContinuationSleeper(request);
    }

    @Override
    public Class<? extends ServerLoadMonitor> getServerLoadMonitorImplementation() {
        return ThreadDroppingServerLoadMonitor.class;
    }
}

