/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.impl;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.HubFactory;
import org.directwebremoting.ServerContextFactory;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.ContainerConfigurationException;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.util.FakeServletConfig;
import org.directwebremoting.util.FakeServletContext;
import org.directwebremoting.util.VersionUtil;

public class StartupUtil {
    private static final Log log = LogFactory.getLog(StartupUtil.class);

    public static Container outOfContainerInit() throws ContainerConfigurationException {
        try {
            FakeServletConfig servletConfig = new FakeServletConfig("test", new FakeServletContext());
            ServletContext servletContext = servletConfig.getServletContext();
            StartupUtil.logStartup(servletConfig);
            Container container = ContainerUtil.createAndSetupDefaultContainer(servletConfig);
            StartupUtil.initContainerBeans(servletConfig, servletContext, container);
            WebContextFactory.WebContextBuilder webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
            ContainerUtil.prepareForWebContextFilter(servletContext, servletConfig, container, webContextBuilder, null);
            ContainerUtil.publishContainer(container, servletConfig);
            ContainerUtil.configureContainerFully(container, servletConfig);
            return container;
        }
        catch (ContainerConfigurationException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContainerConfigurationException(ex);
        }
    }

    public static void outOfContainerDestroy(Container container) {
        WebContextFactory.WebContextBuilder webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
        if (webContextBuilder != null) {
            webContextBuilder.unset();
        }
    }

    public static void logStartup(ServletConfig config) {
        log.info((Object)("DWR Version " + VersionUtil.getVersion() + " starting."));
        log.info((Object)("- Servlet Engine: " + config.getServletContext().getServerInfo()));
        log.info((Object)("- Java Version:   " + System.getProperty("java.version")));
        log.info((Object)("- Java Vendor:    " + System.getProperty("java.vendor")));
    }

    public static void initContainerBeans(ServletConfig servletConfig, ServletContext servletContext, Container container) {
        StartupUtil.initWebContext(servletConfig, servletContext, container);
        StartupUtil.initServerContext(servletConfig, servletContext, container);
        StartupUtil.initHub(servletContext, container);
    }

    @Deprecated
    public static WebContextFactory.WebContextBuilder initWebContext(ServletConfig servletConfig, ServletContext servletContext, Container container) {
        WebContextFactory.WebContextBuilder webContextBuilder = container.getBean(WebContextFactory.WebContextBuilder.class);
        WebContextFactory.setWebContextBuilder(webContextBuilder);
        webContextBuilder.set(null, null, servletConfig, servletContext, container);
        return webContextBuilder;
    }

    @Deprecated
    public static ServerContextFactory.ServerContextBuilder initServerContext(ServletConfig servletConfig, ServletContext servletContext, Container container) {
        ServerContextFactory.ServerContextBuilder serverContextBuilder = container.getBean(ServerContextFactory.ServerContextBuilder.class);
        ServerContextFactory.setServerContextBuilder(serverContextBuilder);
        serverContextBuilder.set(servletConfig, servletContext, container);
        return serverContextBuilder;
    }

    @Deprecated
    public static HubFactory.HubBuilder initHub(ServletContext servletContext, Container container) {
        HubFactory.HubBuilder hubBuilder = container.getBean(HubFactory.HubBuilder.class);
        HubFactory.setHubBuilder(hubBuilder);
        hubBuilder.set(servletContext);
        return hubBuilder;
    }

    @Deprecated
    public static void setupLogging(ServletConfig servletConfig, HttpServlet servlet) {
    }
}

