/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.jms;

import javax.jms.Connection;
import javax.jms.ConnectionConsumer;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.jms.DwrConnectionMetaData;
import org.directwebremoting.jms.DwrSession;
import org.directwebremoting.jms.State;
import org.directwebremoting.jms.Unsupported;

public class DwrConnection
implements Connection {
    private ServletContext servletContext;
    private State state = State.STOPPED;
    private String clientId;
    private ExceptionListener listener;
    private static final Log log = LogFactory.getLog(DwrConnection.class);

    public DwrSession createSession(boolean transacted, int acknowledgeMode) throws JMSException {
        if (transacted) {
            log.error((Object)"transacted == true is not currently supported");
        }
        if (acknowledgeMode != 1) {
            log.error((Object)"acknowledgeMode != Session.AUTO_ACKNOWLEDGE is not currently supported");
        }
        return new DwrSession(this, transacted, acknowledgeMode);
    }

    public ConnectionConsumer createConnectionConsumer(Destination destination, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw Unsupported.noConnectionConsumers();
    }

    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String subscriptionName, String messageSelector, ServerSessionPool sessionPool, int maxMessages) throws JMSException {
        throw Unsupported.noConnectionConsumers();
    }

    public DwrConnectionMetaData getMetaData() throws JMSException {
        return new DwrConnectionMetaData();
    }

    public void start() throws JMSException {
        if (this.state == State.CLOSED) {
            throw new JMSException("Connection has been closed");
        }
        this.state = State.STARTED;
    }

    public void stop() throws JMSException {
        if (this.state == State.CLOSED) {
            throw new JMSException("Connection has been closed");
        }
        this.state = State.STOPPED;
    }

    public void close() throws JMSException {
        this.state = State.CLOSED;
    }

    public void setClientID(String clientId) throws JMSException {
        this.clientId = clientId;
    }

    public String getClientID() throws JMSException {
        return this.clientId;
    }

    public void setExceptionListener(ExceptionListener listener) throws JMSException {
        this.listener = listener;
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        return this.listener;
    }

    public State getState() {
        return this.state;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }
}

