/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.Container;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.impl.ContainerUtil;
import org.directwebremoting.impl.StartupUtil;
import org.directwebremoting.servlet.UrlProcessor;

public class DwrServlet
extends HttpServlet {
    private Container container = null;
    private WebContextFactory.WebContextBuilder webContextBuilder = null;
    private static final Log log = LogFactory.getLog(DwrServlet.class);

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        ServletContext servletContext = servletConfig.getServletContext();
        try {
            StartupUtil.logStartup(servletConfig);
            this.container = ContainerUtil.createAndSetupDefaultContainer(servletConfig);
            StartupUtil.initContainerBeans(servletConfig, servletContext, this.container);
            this.webContextBuilder = this.container.getBean(WebContextFactory.WebContextBuilder.class);
            ContainerUtil.prepareForWebContextFilter(servletContext, servletConfig, this.container, this.webContextBuilder, this);
            ContainerUtil.publishContainer(this.container, servletConfig);
            ContainerUtil.configureContainerFully(this.container, servletConfig);
        }
        catch (ExceptionInInitializerError ex) {
            log.fatal((Object)"ExceptionInInitializerError. Nested exception:", ex.getException());
            throw new ServletException((Throwable)ex);
        }
        catch (Exception ex) {
            log.fatal((Object)"DwrServlet.init() failed", (Throwable)ex);
            throw new ServletException((Throwable)ex);
        }
        finally {
            if (this.webContextBuilder != null) {
                this.webContextBuilder.unset();
            }
        }
    }

    public void destroy() {
        this.shutdown();
        super.destroy();
    }

    public void shutdown() {
        ServerLoadMonitor monitor = this.container.getBean(ServerLoadMonitor.class);
        monitor.shutdown();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doPost(req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.webContextBuilder.set(request, response, this.getServletConfig(), this.getServletContext(), this.container);
            UrlProcessor processor = this.container.getBean(UrlProcessor.class);
            processor.handle(request, response);
        }
        finally {
            this.webContextBuilder.unset();
        }
    }

    public Container getContainer() {
        return this.container;
    }
}

