/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.servlet;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.directwebremoting.WebContextFactory;
import org.directwebremoting.extend.ServerLoadMonitor;
import org.directwebremoting.servlet.JavaScriptHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EngineHandler
extends JavaScriptHandler {
    private String plainCallHandlerUrl = "/call/plaincall/";
    private String plainPollHandlerUrl = "/call/plainpoll/";
    private String htmlCallHandlerUrl = "/call/htmlcall/";
    private String htmlPollHandlerUrl = "/call/htmlpoll/";
    private String sessionCookieName = "JSESSIONID";
    private int maxWaitAfterWrite = -1;
    private String overridePath = null;
    private boolean allowGetForSafariButMakeForgeryEasier = false;
    private String scriptTagProtection = "throw 'allowScriptTagRemoting is false.';";
    private ServerLoadMonitor serverLoadMonitor;

    public EngineHandler() {
        this.setMimeType("text/javascript");
    }

    @Override
    protected String generateTemplate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.readResource("/org/directwebremoting/engine.js");
    }

    @Override
    public Map<String, String> getSearchReplacePairs() {
        HttpServletRequest request = WebContextFactory.get().getHttpServletRequest();
        HashMap<String, String> replace = new HashMap<String, String>();
        boolean streaming = true;
        if (this.maxWaitAfterWrite > -1 && this.maxWaitAfterWrite < 500) {
            streaming = false;
        }
        if (!this.serverLoadMonitor.supportsStreaming()) {
            streaming = false;
        }
        String pollWithXhr = streaming ? "false" : "true";
        replace.put("${pollWithXhr}", pollWithXhr);
        String path = request.getContextPath() + request.getServletPath();
        if (this.overridePath != null) {
            path = this.overridePath;
        }
        replace.put("${defaultPath}", path);
        replace.put("${sessionCookieName}", this.sessionCookieName);
        replace.put("${allowGetForSafariButMakeForgeryEasier}", String.valueOf(this.allowGetForSafariButMakeForgeryEasier));
        replace.put("${scriptTagProtection}", this.scriptTagProtection);
        replace.put("${plainCallHandlerUrl}", this.plainCallHandlerUrl);
        replace.put("${plainPollHandlerUrl}", this.plainPollHandlerUrl);
        replace.put("${htmlCallHandlerUrl}", this.htmlCallHandlerUrl);
        replace.put("${htmlPollHandlerUrl}", this.htmlPollHandlerUrl);
        return replace;
    }

    public void setServerLoadMonitor(ServerLoadMonitor serverLoadMonitor) {
        this.serverLoadMonitor = serverLoadMonitor;
    }

    public void setAllowGetForSafariButMakeForgeryEasier(boolean allowGetForSafariButMakeForgeryEasier) {
        this.allowGetForSafariButMakeForgeryEasier = allowGetForSafariButMakeForgeryEasier;
    }

    public void setScriptTagProtection(String scriptTagProtection) {
        this.scriptTagProtection = scriptTagProtection;
    }

    public void setOverridePath(String overridePath) {
        this.overridePath = overridePath;
    }

    public void setSessionCookieName(String sessionCookieName) {
        this.sessionCookieName = sessionCookieName;
    }

    public void setMaxWaitAfterWrite(int maxWaitAfterWrite) {
        this.maxWaitAfterWrite = maxWaitAfterWrite;
    }

    public void setPlainCallHandlerUrl(String plainCallHandlerUrl) {
        this.plainCallHandlerUrl = plainCallHandlerUrl;
    }

    public void setPlainPollHandlerUrl(String plainPollHandlerUrl) {
        this.plainPollHandlerUrl = plainPollHandlerUrl;
    }

    public void setHtmlCallHandlerUrl(String htmlCallHandlerUrl) {
        this.htmlCallHandlerUrl = htmlCallHandlerUrl;
    }

    public void setHtmlPollHandlerUrl(String htmlPollHandlerUrl) {
        this.htmlPollHandlerUrl = htmlPollHandlerUrl;
    }
}

