/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.directwebremoting.util.LocalUtil;

public class Continuation {
    private Object proxy;
    private static final Log log = LogFactory.getLog(Continuation.class);
    private static final String ATTRIBUTE_JETTY_CONTINUATION = "org.mortbay.jetty.ajax.Continuation";
    protected static Class<?> continuationClass = null;
    protected static Method suspendMethod = null;
    protected static Method resumeMethod = null;
    protected static Method getObject = null;
    protected static Method setObject = null;
    protected static boolean isJetty = false;
    protected static boolean isGrizzly = false;

    public Continuation(HttpServletRequest request) {
        this.proxy = request.getAttribute(ATTRIBUTE_JETTY_CONTINUATION);
        if (this.proxy == null && Continuation.isGrizzly()) {
            try {
                Class<?> gContinuation = LocalUtil.classForName("com.sun.grizzly.Continuation");
                Method gMethod = gContinuation.getMethod("getContinuation", new Class[0]);
                this.proxy = gMethod.invoke((Object)null, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public boolean isAvailable() {
        return this.proxy != null;
    }

    public void suspend(long sleepTime) throws Exception {
        try {
            suspendMethod.invoke(this.proxy, sleepTime);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public void resume() throws Exception {
        try {
            resumeMethod.invoke(this.proxy, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public Object getObject() throws Exception {
        try {
            return getObject.invoke(this.proxy, new Object[0]);
        }
        catch (InvocationTargetException ex) {
            return Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public void setObject(Object object) throws Exception {
        try {
            setObject.invoke(this.proxy, object);
        }
        catch (InvocationTargetException ex) {
            Continuation.rethrowWithoutWrapper(ex);
        }
    }

    public static void rethrowIfContinuation(Throwable th) {
        Throwable ex = th;
        if (ex instanceof InvocationTargetException) {
            ex = ((InvocationTargetException)ex).getTargetException();
        }
        if ("org.mortbay.jetty.RetryRequest".equals(ex.getClass().getName())) {
            throw (RuntimeException)ex;
        }
    }

    private static Object rethrowWithoutWrapper(InvocationTargetException ex) throws Exception {
        Throwable target = ex.getTargetException();
        if (target instanceof Exception) {
            throw (Exception)target;
        }
        if (target instanceof Error) {
            throw (Error)target;
        }
        throw ex;
    }

    public static boolean isJetty() {
        return isJetty;
    }

    public static boolean isGrizzly() {
        return isGrizzly;
    }

    static {
        try {
            try {
                continuationClass = LocalUtil.classForName("org.mortbay.util.ajax.Continuation");
                isJetty = true;
            }
            catch (Exception ex) {
                Class<?> gContinuation = LocalUtil.classForName("com.sun.grizzly.Continuation");
                Method gMethod = gContinuation.getMethod("getContinuation", new Class[0]);
                continuationClass = gMethod.invoke((Object)gMethod, new Object[0]).getClass();
                isGrizzly = true;
            }
            suspendMethod = continuationClass.getMethod("suspend", Long.TYPE);
            resumeMethod = continuationClass.getMethod("resume", new Class[0]);
            getObject = continuationClass.getMethod("getObject", new Class[0]);
            setObject = continuationClass.getMethod("setObject", Object.class);
        }
        catch (Exception ex) {
            isJetty = false;
            log.debug((Object)"No Jetty or Grizzly Continuation class, using standard Servlet API");
        }
    }
}

