/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.ast.descr;

import org.drools.drl.ast.descr.BaseDescr;

public class AttributeDescr
extends BaseDescr {
    private static final long serialVersionUID = 510L;
    private String name;
    private String value;
    private Type type;

    public AttributeDescr() {
    }

    public AttributeDescr(String name) {
        this(name, null, Type.EXPRESSION);
    }

    public AttributeDescr(String name, String value) {
        this(name, value, Type.EXPRESSION);
    }

    public AttributeDescr(String name, String value, Type type) {
        this.name = name;
        this.value = value;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public String getValueString() {
        if (this.type == Type.STRING || this.type == Type.DATE || this.name.equals("dialect")) {
            return "\"" + this.value + "\"";
        }
        if (this.name.equals("timer") || this.name.equals("duration")) {
            return "(" + this.value + ")";
        }
        return this.value;
    }

    public static enum Type {
        STRING,
        NUMBER,
        DATE,
        BOOLEAN,
        LIST,
        EXPRESSION;

    }
}

