/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.servlet.http.HttpSession;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.dspace.app.xmlui.utils.ContextUtil;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.eperson.EPerson;

public class CurrentActivityAction
extends AbstractAction {
    public static final int MAX_EVENTS;
    public static final String IP_HEADER;
    private static Queue<Event> events;
    private static boolean recordAnonymousEvents;
    private static boolean recordBotEvents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters parameters) throws Exception {
        Request request = ObjectModelHelper.getRequest((Map)objectModel);
        Context context = ContextUtil.obtainContext(objectModel);
        Queue<Event> queue = events;
        synchronized (queue) {
            Event event = new Event(context, request);
            boolean record = true;
            if (!recordAnonymousEvents && event.isAnonymous()) {
                record = false;
            }
            if (!recordBotEvents && event.isBot()) {
                record = false;
            }
            if (record) {
                events.add(event);
            }
            while (events.size() > MAX_EVENTS) {
                events.poll();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Event> getEvents() {
        ArrayList<Event> list = new ArrayList<Event>();
        Queue<Event> queue = events;
        synchronized (queue) {
            list.addAll(events);
        }
        return list;
    }

    public static boolean getRecordAnonymousEvents() {
        return recordAnonymousEvents;
    }

    public static void setRecordAnonymousEvents(boolean record) {
        recordAnonymousEvents = record;
    }

    public static boolean getRecordBotEvents() {
        return recordBotEvents;
    }

    public static void setRecordBotEvents(boolean record) {
        recordBotEvents = record;
    }

    static {
        events = new LinkedList<Event>();
        recordAnonymousEvents = true;
        recordBotEvents = false;
        MAX_EVENTS = ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.max") != null ? ConfigurationManager.getIntProperty((String)"xmlui.controlpanel.activity.max") : 250;
        IP_HEADER = ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.ipheader") != null ? ConfigurationManager.getProperty((String)"xmlui.controlpanel.activity.ipheader") : "X-Forwarded-For";
    }

    public static class Event {
        private String sessionID;
        private int epersonID = -1;
        private String url;
        private long timestamp;
        private String userAgent;
        private String ip;

        public Event(Context context, Request request) {
            EPerson eperson;
            if (context != null && (eperson = context.getCurrentUser()) != null) {
                this.epersonID = eperson.getID();
            }
            if (request != null) {
                this.url = request.getSitemapURI();
                HttpSession session = request.getSession(true);
                if (session != null) {
                    this.sessionID = session.getId();
                }
                this.userAgent = request.getHeader("User-Agent");
                this.ip = request.getHeader(IP_HEADER);
                if (this.ip == null) {
                    this.ip = request.getRemoteAddr();
                }
            }
            this.timestamp = System.currentTimeMillis();
        }

        public String getSessionID() {
            return this.sessionID;
        }

        public int getEPersonID() {
            return this.epersonID;
        }

        public String getURL() {
            return this.url;
        }

        public long getTimeStamp() {
            return this.timestamp;
        }

        public String getUserAgent() {
            return this.userAgent;
        }

        public String getIP() {
            return this.ip;
        }

        public boolean isAnonymous() {
            return this.epersonID == -1;
        }

        public boolean isBot() {
            if (this.userAgent == null) {
                return false;
            }
            String ua = this.userAgent.toLowerCase();
            return ua.contains("google/") || ua.contains("msnbot/") || ua.contains("googlebot/") || ua.contains("webcrawler/") || ua.contains("inktomi") || ua.contains("teoma") || ua.contains("bot");
        }

        public String getDectectedBrowser() {
            if (this.userAgent == null) {
                return "No browser provided";
            }
            String userAgentLower = this.userAgent.toLowerCase();
            if (userAgentLower.contains("google/")) {
                return "Google (bot)";
            }
            if (userAgentLower.contains("msnbot/")) {
                return "MSN (bot)";
            }
            if (userAgentLower.contains("googlebot/")) {
                return "Google (bot)";
            }
            if (userAgentLower.contains("webcrawler/")) {
                return "WebCrawler (bot)";
            }
            if (userAgentLower.contains("inktomi")) {
                return "Inktomi (bot)";
            }
            if (userAgentLower.contains("teoma")) {
                return "Teoma (bot)";
            }
            if (userAgentLower.contains("bot")) {
                return "Unknown (bot)";
            }
            if (this.userAgent.contains("Lotus-Notes/")) {
                return "Lotus-Notes";
            }
            if (this.userAgent.contains("Opera")) {
                return "Opera";
            }
            if (this.userAgent.contains("Safari/")) {
                if (this.userAgent.contains("Chrome")) {
                    return "Chrome";
                }
                return "Safari";
            }
            if (this.userAgent.contains("Konqueror/")) {
                return "Konqueror";
            }
            if (this.userAgent.contains("MSIE")) {
                if (this.userAgent.contains("MSIE 9")) {
                    return "MSIE 9";
                }
                if (this.userAgent.contains("MSIE 8")) {
                    return "MSIE 8";
                }
                if (this.userAgent.contains("MSIE 7")) {
                    return "MSIE 7";
                }
                if (this.userAgent.contains("MSIE 6")) {
                    return "MSIE 6";
                }
                if (this.userAgent.contains("MSIE 5")) {
                    return "MSIE 5";
                }
                return "MSIE";
            }
            if (this.userAgent.contains("Gecko/")) {
                if (this.userAgent.contains("Camio/")) {
                    return "Gecko/Camino";
                }
                if (this.userAgent.contains("Chimera/")) {
                    return "Gecko/Chimera";
                }
                if (this.userAgent.contains("Firebird/")) {
                    return "Gecko/Firebird";
                }
                if (this.userAgent.contains("Phoenix/")) {
                    return "Gecko/Phoenix";
                }
                if (this.userAgent.contains("Galeon")) {
                    return "Gecko/Galeon";
                }
                if (this.userAgent.contains("Firefox/1")) {
                    return "Firefox 1.x";
                }
                if (this.userAgent.contains("Firefox/2")) {
                    return "Firefox 2.x";
                }
                if (this.userAgent.contains("Firefox/3")) {
                    return "Firefox 3.x";
                }
                if (this.userAgent.contains("Firefox/4")) {
                    return "Firefox 4.x";
                }
                if (this.userAgent.contains("Firefox/")) {
                    return "Firefox";
                }
                if (this.userAgent.contains("Netscape/")) {
                    return "Netscape";
                }
                return "Gecko";
            }
            if (this.userAgent.contains("KHTML/")) {
                return "KHTML";
            }
            if (this.userAgent.contains("Netscape/")) {
                return "Netscape";
            }
            if (this.userAgent.contains("Mozilla/")) {
                return "Mozilla";
            }
            return "Unknown";
        }
    }
}

