/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.app.xmlui.aspect.administrative.collection;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.dspace.app.util.AuthorizeUtil;
import org.dspace.app.xmlui.aspect.administrative.FlowContainerUtils;
import org.dspace.app.xmlui.cocoon.AbstractDSpaceTransformer;
import org.dspace.app.xmlui.wing.Message;
import org.dspace.app.xmlui.wing.WingException;
import org.dspace.app.xmlui.wing.element.Body;
import org.dspace.app.xmlui.wing.element.Button;
import org.dspace.app.xmlui.wing.element.Cell;
import org.dspace.app.xmlui.wing.element.Division;
import org.dspace.app.xmlui.wing.element.List;
import org.dspace.app.xmlui.wing.element.PageMeta;
import org.dspace.app.xmlui.wing.element.Para;
import org.dspace.app.xmlui.wing.element.Row;
import org.dspace.app.xmlui.wing.element.Table;
import org.dspace.authorize.AuthorizeException;
import org.dspace.authorize.AuthorizeManager;
import org.dspace.content.Collection;
import org.dspace.core.ConfigurationManager;
import org.dspace.core.Context;
import org.dspace.core.LogManager;
import org.dspace.eperson.Group;
import org.dspace.xmlworkflow.Role;
import org.dspace.xmlworkflow.WorkflowConfigurationException;
import org.dspace.xmlworkflow.WorkflowUtils;

public class AssignCollectionRoles
extends AbstractDSpaceTransformer {
    private static final Message T_dspace_home = AssignCollectionRoles.message((String)"xmlui.general.dspace_home");
    private static final Message T_collection_trail = AssignCollectionRoles.message((String)"xmlui.administrative.collection.general.collection_trail");
    private static final Message T_options_metadata = AssignCollectionRoles.message((String)"xmlui.administrative.collection.general.options_metadata");
    private static final Message T_options_roles = AssignCollectionRoles.message((String)"xmlui.administrative.collection.general.options_roles");
    private static final Message T_options_harvest = AssignCollectionRoles.message((String)"xmlui.administrative.collection.GeneralCollectionHarvestingForm.options_harvest");
    private static final Message T_options_curate = AssignCollectionRoles.message((String)"xmlui.administrative.collection.general.options_curate");
    private static final Message T_submit_return = AssignCollectionRoles.message((String)"xmlui.general.return");
    private static final Message T_title = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.title");
    private static final Message T_trail = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.trail");
    private static final Message T_main_head = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.main_head");
    private static final Message T_no_role = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.no_role");
    private static final Message T_create = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.create");
    private static final Message T_delete = AssignCollectionRoles.message((String)"xmlui.general.delete");
    private static final Message T_restrict = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.restrict");
    private static final Message T_help_admins = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.help_admins");
    private static final Message T_help_wf_step1 = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.help_wf_step1");
    private static final Message T_help_wf_step2 = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.help_wf_step2");
    private static final Message T_help_wf_step3 = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.help_wf_step3");
    private static final Message T_help_submitters = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.help_submitters");
    private static final Message T_help_default_read = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.help_default_read");
    private static final Message T_default_read_custom = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.default_read_custom");
    private static final Message T_default_read_anonymous = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.default_read_anonymous");
    private static final Message T_edit_authorization = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.edit_authorization");
    private static final Message T_role_name = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.role_name");
    private static final Message T_role_group = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.role_group");
    private static final Message T_role_buttons = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.role_buttons");
    private static final Message T_label_admins = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_admins");
    private static final Message T_label_wf = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_wf");
    private static final Message T_label_wf_step1 = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_wf_step1");
    private static final Message T_label_wf_step2 = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_wf_step2");
    private static final Message T_label_wf_step3 = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_wf_step3");
    private static final Message T_label_submitters = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_submitters");
    private static final Message T_label_default_read = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.label_default_read");
    private static final Message T_sysadmins_only = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.sysadmins_only");
    private static final Message T_not_allowed = AssignCollectionRoles.message((String)"xmlui.administrative.collection.AssignCollectionRoles.not_allowed");
    private static Logger log = Logger.getLogger(AssignCollectionRoles.class);

    @Override
    public void addPageMeta(PageMeta pageMeta) throws WingException {
        pageMeta.addMetadata("title").addContent(T_title);
        pageMeta.addTrailLink(this.contextPath + "/", T_dspace_home);
        pageMeta.addTrail().addContent(T_collection_trail);
        pageMeta.addTrail().addContent(T_trail);
    }

    @Override
    public void addBody(Body body) throws WingException, SQLException, AuthorizeException {
        int collectionID = this.parameters.getParameterAsInteger("collectionID", -1);
        Collection thisCollection = Collection.find((Context)this.context, (int)collectionID);
        String baseURL = this.contextPath + "/admin/collection?administrative-continue=" + this.knot.getId();
        Group admins = thisCollection.getAdministrators();
        Group submitters = thisCollection.getSubmitters();
        HashMap roles = null;
        try {
            roles = WorkflowUtils.getCollectionRoles((Collection)thisCollection);
        }
        catch (WorkflowConfigurationException e) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"error while getting collection roles", (String)("Collection id: " + thisCollection.getID())));
        }
        catch (IOException e) {
            log.error((Object)LogManager.getHeader((Context)this.context, (String)"error while getting collection roles", (String)("Collection id: " + thisCollection.getID())));
        }
        Group defaultRead = null;
        int defaultReadID = FlowContainerUtils.getCollectionDefaultRead(this.context, collectionID);
        if (defaultReadID >= 0) {
            defaultRead = Group.find((Context)this.context, (int)defaultReadID);
        }
        Division main = body.addInteractiveDivision("collection-assign-roles", this.contextPath + "/admin/collection", "post", "primary administrative collection");
        main.setHead(T_main_head.parameterize(new Object[]{thisCollection.getMetadata("name")}));
        List options = main.addList("options", "simple", "horizontal");
        options.addItem().addXref(baseURL + "&submit_metadata", T_options_metadata);
        options.addItem().addHighlight("bold").addXref(baseURL + "&submit_roles", T_options_roles);
        options.addItem().addXref(baseURL + "&submit_harvesting", T_options_harvest);
        options.addItem().addXref(baseURL + "&submit_curate", T_options_curate);
        Table rolesTable = main.addTable("roles-table", 6, 5);
        Row tableHeader = rolesTable.addRow("header");
        tableHeader.addCell().addContent(T_role_name);
        tableHeader.addCell().addContent(T_role_group);
        tableHeader.addCell().addContent(T_role_buttons);
        rolesTable.addRow();
        Row tableRow = rolesTable.addRow("data");
        tableRow.addCell("header").addContent(T_label_admins);
        if (admins != null) {
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)this.context, (Collection)thisCollection);
                tableRow.addCell().addXref(baseURL + "&submit_edit_admin", admins.getName());
            }
            catch (AuthorizeException authex) {
                tableRow.addCell().addContent(T_not_allowed);
            }
            try {
                AuthorizeUtil.authorizeRemoveAdminGroup((Context)this.context, (Collection)thisCollection);
                tableRow.addCell().addButton("submit_delete_admin").setValue(T_delete);
            }
            catch (AuthorizeException authex) {}
        } else {
            tableRow.addCell().addContent(T_no_role);
            try {
                AuthorizeUtil.authorizeManageAdminGroup((Context)this.context, (Collection)thisCollection);
                tableRow.addCell().addButton("submit_create_admin").setValue(T_create);
            }
            catch (AuthorizeException authex) {
                tableRow.addCell().addContent(T_not_allowed);
            }
        }
        tableRow = rolesTable.addRow("data");
        tableRow.addCell();
        tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_admins);
        tableRow = rolesTable.addRow("data");
        tableRow.addCell("header").addContent(T_label_submitters);
        try {
            AuthorizeUtil.authorizeManageSubmittersGroup((Context)this.context, (Collection)thisCollection);
            if (submitters != null) {
                tableRow.addCell().addXref(baseURL + "&submit_edit_submit", submitters.getName());
                tableRow.addCell().addButton("submit_delete_submit").setValue(T_delete);
            } else {
                tableRow.addCell().addContent(T_no_role);
                tableRow.addCell().addButton("submit_create_submit").setValue(T_create);
            }
        }
        catch (AuthorizeException authex) {
            tableRow.addCell().addContent(T_not_allowed);
        }
        tableRow = rolesTable.addRow("data");
        tableRow.addCell();
        tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_submitters);
        tableRow = rolesTable.addRow("data");
        tableRow.addCell("header").addContent(T_label_default_read);
        if (defaultRead == null) {
            tableRow.addCell(1, 2).addContent(T_default_read_custom);
        } else if (defaultRead.getID() == 0) {
            tableRow.addCell().addContent(T_default_read_anonymous);
            this.addAdministratorOnlyButton(tableRow.addCell(), "submit_create_default_read", T_restrict);
        } else {
            tableRow.addCell().addXref(baseURL + "&submit_edit_default_read", defaultRead.getName());
            this.addAdministratorOnlyButton(tableRow.addCell(), "submit_delete_default_read", T_delete);
        }
        tableRow = rolesTable.addRow("data");
        tableRow.addCell();
        tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_default_read);
        if (ConfigurationManager.getProperty((String)"workflow", (String)"workflow.framework").equals("xmlworkflow")) {
            this.addXMLWorkflowRoles(thisCollection, baseURL, roles, rolesTable);
        } else {
            this.addOriginalWorkflowRoles(thisCollection, baseURL, rolesTable);
        }
        try {
            AuthorizeUtil.authorizeManageCollectionPolicy((Context)this.context, (Collection)thisCollection);
            Cell authCell = rolesTable.addRow().addCell(1, 3);
            authCell.addXref(baseURL + "&submit_authorizations", T_edit_authorization);
        }
        catch (AuthorizeException authex) {
            // empty catch block
        }
        Para buttonList = main.addPara();
        buttonList.addButton("submit_return").setValue(T_submit_return);
        main.addHidden("administrative-continue").setValue(this.knot.getId());
    }

    private void addOriginalWorkflowRoles(Collection thisCollection, String baseURL, Table rolesTable) throws SQLException, WingException {
        try {
            Group wfStep1 = thisCollection.getWorkflowGroup(1);
            Group wfStep2 = thisCollection.getWorkflowGroup(2);
            Group wfStep3 = thisCollection.getWorkflowGroup(3);
            AuthorizeUtil.authorizeManageWorkflowsGroup((Context)this.context, (Collection)thisCollection);
            Row tableRow = rolesTable.addRow("data");
            tableRow.addCell("header").addContent(T_label_wf_step1);
            if (wfStep1 != null) {
                tableRow.addCell().addXref(baseURL + "&submit_edit_wf_step1", wfStep1.getName());
                tableRow.addCell().addButton("submit_delete_wf_step1").setValue(T_delete);
            } else {
                tableRow.addCell().addContent(T_no_role);
                tableRow.addCell().addButton("submit_create_wf_step1").setValue(T_create);
            }
            tableRow = rolesTable.addRow("data");
            tableRow.addCell();
            tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_wf_step1);
            tableRow = rolesTable.addRow("data");
            tableRow.addCell("header").addContent(T_label_wf_step2);
            if (wfStep2 != null) {
                tableRow.addCell().addXref(baseURL + "&submit_edit_wf_step2", wfStep2.getName());
                tableRow.addCell().addButton("submit_delete_wf_step2").setValue(T_delete);
            } else {
                tableRow.addCell().addContent(T_no_role);
                tableRow.addCell().addButton("submit_create_wf_step2").setValue(T_create);
            }
            tableRow = rolesTable.addRow("data");
            tableRow.addCell();
            tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_wf_step2);
            tableRow = rolesTable.addRow("data");
            tableRow.addCell("header").addContent(T_label_wf_step3);
            if (wfStep3 != null) {
                tableRow.addCell().addXref(baseURL + "&submit_edit_wf_step3", wfStep3.getName());
                tableRow.addCell().addButton("submit_delete_wf_step3").setValue(T_delete);
            } else {
                tableRow.addCell().addContent(T_no_role);
                tableRow.addCell().addButton("submit_create_wf_step3").setValue(T_create);
            }
            tableRow = rolesTable.addRow("data");
            tableRow.addCell();
            tableRow.addCell(1, 2).addHighlight("fade offset").addContent(T_help_wf_step3);
        }
        catch (AuthorizeException authex) {
            Row tableRow = rolesTable.addRow("data");
            tableRow.addCell("header").addContent(T_label_wf);
            tableRow.addCell().addContent(T_not_allowed);
        }
    }

    private void addXMLWorkflowRoles(Collection thisCollection, String baseURL, HashMap<String, Role> roles, Table rolesTable) throws WingException, SQLException {
        if (roles != null) {
            for (String roleId : roles.keySet()) {
                Role role = roles.get(roleId);
                if (role.getScope() != Role.Scope.COLLECTION) continue;
                Row tableRow = rolesTable.addRow("data");
                tableRow.addCell("header").addContent(role.getName());
                Group roleGroup = WorkflowUtils.getRoleGroup((Context)this.context, (int)thisCollection.getID(), (Role)role);
                if (roleGroup != null) {
                    tableRow.addCell().addXref(baseURL + "&submit_edit_wf_role_" + roleId, roleGroup.getName());
                    this.addAdministratorOnlyButton(tableRow.addCell(), "submit_delete_wf_role_" + roleId, T_delete);
                } else {
                    tableRow.addCell().addContent(T_no_role);
                    this.addAdministratorOnlyButton(tableRow.addCell(), "submit_create_wf_role_" + roleId, T_create);
                }
                tableRow = rolesTable.addRow("data");
                tableRow.addCell();
                if (role.getDescription() == null) continue;
                tableRow.addCell(1, 2).addHighlight("fade offset").addContent(role.getDescription());
            }
        }
    }

    private void addAdministratorOnlyButton(Cell cell, String buttonName, Message buttonLabel) throws WingException, SQLException {
        Button button = cell.addButton(buttonName);
        button.setValue(buttonLabel);
        if (!AuthorizeManager.isAdmin((Context)this.context)) {
            button.setDisabled();
            cell.addHighlight("fade").addContent(T_sysadmins_only);
        }
    }
}

